/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.ThreadLoggingEnvironment;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.utils.ILogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/GradleSyncLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/configure/ThreadLoggingEnvironment;", "variantName", "", "tag", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/builder/errors/EvalIssueReporter;Lcom/android/utils/ILogger;)V", "error", "", "message", "info", "warn", "gradle"})
public final class GradleSyncLoggingEnvironment
extends ThreadLoggingEnvironment {
    private final String variantName;
    private final String tag;
    private final EvalIssueReporter issueReporter;
    private final ILogger logger;

    @Override
    public void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        GradleException e = new GradleException(message);
        this.issueReporter.reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException((Throwable)e, message));
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.logger.warning(message, new Object[0]);
    }

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.logger.info(this.variantName + '|' + this.tag + ' ' + message, new Object[0]);
    }

    public GradleSyncLoggingEnvironment(@NotNull String variantName, @NotNull String tag, @NotNull EvalIssueReporter issueReporter, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.variantName = variantName;
        this.tag = tag;
        this.issueReporter = issueReporter;
        this.logger = logger;
    }
}

