/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.utils.ExceptionRunnable;
import com.android.builder.utils.FileCache;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FixStackFramesDelegate {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(FixStackFramesDelegate.class);
    private static final FileTime ZERO = FileTime.fromMillis(0L);
    private static final long CACHE_VERSION = 1L;
    private final Set<File> bootClasspath;
    private final Set<File> classesToFix;
    private final Set<File> referencedClasses;
    private final File outFolder;
    private final FileCache userCache;
    private URLClassLoader classLoader = null;

    public FixStackFramesDelegate(Set<File> bootClasspath, Set<File> classesToFix, Set<File> referencedClasses, File outFolder, FileCache userCache) {
        this.bootClasspath = bootClasspath;
        this.classesToFix = classesToFix;
        this.referencedClasses = referencedClasses;
        this.outFolder = outFolder;
        this.userCache = userCache;
    }

    private URLClassLoader getClassLoader() throws MalformedURLException {
        if (this.classLoader == null) {
            ImmutableList.Builder urls = new ImmutableList.Builder();
            for (File file : this.bootClasspath) {
                if (!file.exists()) continue;
                urls.add((Object)file.toURI().toURL());
            }
            for (File file : Iterables.concat(this.classesToFix, this.referencedClasses)) {
                if (!file.isDirectory() && !file.isFile()) continue;
                urls.add((Object)file.toURI().toURL());
            }
            ImmutableList allUrls = urls.build();
            URL[] classLoaderUrls = (URL[])allUrls.toArray((Object[])new URL[0]);
            this.classLoader = new URLClassLoader(classLoaderUrls);
        }
        return this.classLoader;
    }

    private String getUniqueName(File input2) {
        return Hashing.sha256().hashBytes(input2.getAbsolutePath().getBytes(StandardCharsets.UTF_8)).toString() + ".jar";
    }

    public void doFullRun(WorkerExecutorFacade workers) throws IOException {
        FileUtils.cleanOutputDir((File)this.outFolder);
        try (WorkerExecutorFacade facade = workers;){
            for (File file : this.classesToFix) {
                if (!file.isFile()) continue;
                File out = new File(this.outFolder, this.getUniqueName(file));
                facade.submit(FixStackFramesRunnable.class, (Serializable)new Params(file, out, this.getClassLoader(), this.userCache));
            }
        }
    }

    public void doIncrementalRun(WorkerExecutorFacade workers, Map<File, FileStatus> changedInput) throws IOException {
        Set jarsToProcess = this.classesToFix.stream().filter(File::isFile).collect(Collectors.toSet());
        try (WorkerExecutorFacade facade = workers;){
            for (Map.Entry<File, FileStatus> entry : changedInput.entrySet()) {
                File out = new File(this.outFolder, this.getUniqueName(entry.getKey()));
                Files.deleteIfExists(out.toPath());
                if (!jarsToProcess.contains(entry.getKey()) || entry.getValue() != FileStatus.NEW && entry.getValue() != FileStatus.CHANGED) continue;
                facade.submit(FixStackFramesRunnable.class, (Serializable)new Params(entry.getKey(), out, this.getClassLoader(), this.userCache));
            }
        }
    }

    private static class FixStackFramesRunnable
    implements Runnable {
        private final Params params;

        @Inject
        public FixStackFramesRunnable(Params params) {
            this.params = params;
        }

        @Override
        public void run() {
            try {
                ExceptionRunnable fileCreator = this.createFile(this.params.input, this.params.output, this.params.classLoader);
                if (this.params.userCache != null) {
                    FileCache.Inputs key = new FileCache.Inputs.Builder(FileCache.Command.FIX_STACK_FRAMES).putFile("file", this.params.input, FileCache.FileProperties.PATH_SIZE_TIMESTAMP).putLong("version", 1L).build();
                    this.params.userCache.createFile(this.params.output, key, fileCreator);
                } else {
                    fileCreator.run();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private ExceptionRunnable createFile(File input2, File output2, URLClassLoader classLoader) {
            return () -> {
                try (ZipFile inputZip = new ZipFile(input2);
                     ZipOutputStream outputZip = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(output2.toPath(), new OpenOption[0])));){
                    Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
                    while (inEntries.hasMoreElements()) {
                        ZipEntry entry = inEntries.nextElement();
                        if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                            throw new InvalidPathException(entry.getName(), "Entry name contains invalid characters");
                        }
                        if (!entry.getName().endsWith(".class")) continue;
                        BufferedInputStream originalFile = new BufferedInputStream(inputZip.getInputStream(entry));
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        byte[] newEntryContent = FixStackFramesRunnable.getFixedClass(originalFile, classLoader);
                        CRC32 crc32 = new CRC32();
                        crc32.update(newEntryContent);
                        outEntry.setCrc(crc32.getValue());
                        outEntry.setMethod(0);
                        outEntry.setSize(newEntryContent.length);
                        outEntry.setCompressedSize(newEntryContent.length);
                        outEntry.setLastAccessTime(ZERO);
                        outEntry.setLastModifiedTime(ZERO);
                        outEntry.setCreationTime(ZERO);
                        outputZip.putNextEntry(outEntry);
                        outputZip.write(newEntryContent);
                        outputZip.closeEntry();
                    }
                }
            };
        }

        private static byte[] getFixedClass(InputStream originalFile, URLClassLoader classLoader) throws IOException {
            byte[] bytes = ByteStreams.toByteArray((InputStream)originalFile);
            try {
                ClassReader classReader = new ClassReader(bytes);
                FixFramesVisitor classWriter = new FixFramesVisitor(2, classLoader);
                classReader.accept((ClassVisitor)classWriter, 4);
                return classWriter.toByteArray();
            }
            catch (Throwable t) {
                logger.verbose(t.getMessage(), new Object[0]);
                return bytes;
            }
        }
    }

    private static class Params
    implements Serializable {
        private final File input;
        private final File output;
        private final transient URLClassLoader classLoader;
        private final transient FileCache userCache;

        private Params(File input2, File output2, URLClassLoader classLoader, FileCache userCache) {
            this.input = input2;
            this.output = output2;
            this.classLoader = classLoader;
            this.userCache = userCache;
        }
    }

    private static class FixFramesVisitor
    extends ClassWriter {
        private final URLClassLoader classLoader;

        public FixFramesVisitor(int flags, URLClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            URLClassLoader classLoader = this.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, classLoader);
                d = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to find common supper type for %s and %s.", type1, type2), e);
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }
}

