/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import java.io.IOException;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class PreColdSwapTask
extends AndroidVariantTask {
    private static final Logger LOG = Logging.getLogger(PreColdSwapTask.class);
    private TransformVariantScope transformVariantScope;
    private InstantRunVariantScope instantRunVariantScope;
    private InstantRunBuildContext instantRunContext;

    @TaskAction
    public void disableBuildTasksAsNeeded() throws IOException {
        LOG.info("PreColdSwapTask : build mode is {}", (Object)this.instantRunContext.getBuildMode().toString());
        switch (this.instantRunContext.getBuildMode()) {
            case HOT_WARM: {
                this.instantRunVariantScope.getColdSwapBuildTasks().forEach(this::disableTask);
                this.disableTask(this.instantRunVariantScope.getTaskContainer().getPackageAndroidTask());
                break;
            }
            case COLD: 
            case FULL: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown " + InstantRunBuildMode.class.getName()));
            }
        }
    }

    private void disableTask(TaskProvider<? extends Task> task) {
        LOG.info("Disabling task {}", (Object)task.getName());
        task.configure(t -> t.setEnabled(false));
    }

    public static class CreationAction
    extends TaskCreationAction<PreColdSwapTask> {
        protected final TransformVariantScope transformVariantScope;
        protected final InstantRunVariantScope instantRunVariantScope;
        private final TaskProvider<TransformTask> verifierTask;
        protected final String name;

        public CreationAction(String name, TransformVariantScope transformVariantScope, InstantRunVariantScope instantRunVariantScope, TaskProvider<TransformTask> verifierTask) {
            this.name = name;
            this.transformVariantScope = transformVariantScope;
            this.instantRunVariantScope = instantRunVariantScope;
            this.verifierTask = verifierTask;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName(this.name);
        }

        @Override
        public Class<PreColdSwapTask> getType() {
            return PreColdSwapTask.class;
        }

        @Override
        public void configure(PreColdSwapTask task) {
            task.setVariantName(this.instantRunVariantScope.getFullVariantName());
            task.transformVariantScope = this.transformVariantScope;
            task.instantRunVariantScope = this.instantRunVariantScope;
            task.instantRunContext = this.instantRunVariantScope.getInstantRunBuildContext();
            task.dependsOn(new Object[]{this.verifierTask});
        }
    }
}

