/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.ArtifactConfigurationException;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.artifact.InputArtifactProvider;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/api/artifact/InputArtifactProviderImpl;", "Lcom/android/build/api/artifact/InputArtifactProvider;", "artifactsHolder", "Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;", "referencedInputTypes", "", "Lcom/android/build/api/artifact/ArtifactType;", "transformedInputTypes", "defaultValue", "Lorg/gradle/api/file/FileCollection;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;Ljava/util/Collection;Ljava/util/Collection;Lorg/gradle/api/file/FileCollection;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "artifact", "Lcom/android/build/api/artifact/BuildableArtifact;", "getArtifact", "()Lcom/android/build/api/artifact/BuildableArtifact;", "type", "mapOfInputs", "", "gradle"})
public final class InputArtifactProviderImpl
implements InputArtifactProvider {
    private BuildArtifactsHolder artifactsHolder;
    private Collection<? extends ArtifactType> referencedInputTypes;
    private Collection<? extends ArtifactType> transformedInputTypes;
    private FileCollection defaultValue;
    private final DslScope dslScope;

    /*
     * WARNING - void declaration
     */
    private final Map<ArtifactType, BuildableArtifact> mapOfInputs() {
        void var3_3;
        Object object;
        ArtifactType it;
        Object object2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.transformedInputTypes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ArtifactType artifactType = (ArtifactType)item$iv$iv;
            object2 = destination$iv$iv;
            object = TuplesKt.to((Object)it, (Object)this.artifactsHolder.getArtifactFiles(it));
            object2.add(object);
        }
        $receiver$iv = this.referencedInputTypes;
        object2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ArtifactType)item$iv$iv;
            object = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)this.artifactsHolder.getFinalArtifactFiles(it));
            object.add(pair);
        }
        object = (List)var3_3;
        return MapsKt.plus((Map)object2, (Map)MapsKt.toMap((Iterable)((Iterable)object)));
    }

    @NotNull
    public BuildableArtifact getArtifact() {
        BuildableArtifact buildableArtifact;
        Map<ArtifactType, BuildableArtifact> map2 = this.mapOfInputs();
        Map<ArtifactType, BuildableArtifact> $receiver = map2;
        if ($receiver.isEmpty()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("No artifacts was defined for input.", null, null, 6, null));
            buildableArtifact = new BuildableArtifactImpl(this.defaultValue, this.dslScope);
        } else if ($receiver.size() > 1) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Multiple inputs types were defined, use getArtifact(ArtifactType) method to disambiguate : " + Joiner.on((String)",").join((Iterable)this.mapOfInputs().keySet()), null, null, 6, null));
            buildableArtifact = new BuildableArtifactImpl(this.defaultValue, this.dslScope);
        } else {
            buildableArtifact = (BuildableArtifact)CollectionsKt.single((Iterable)this.mapOfInputs().values());
        }
        return buildableArtifact;
    }

    @NotNull
    public BuildableArtifact getArtifact(@NotNull ArtifactType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        BuildableArtifact buildableArtifact = this.mapOfInputs().get(type);
        if (buildableArtifact == null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Artifact was not defined for input of type: " + type + '.', null, null, 6, null));
            return new BuildableArtifactImpl(this.defaultValue, this.dslScope);
        }
        return buildableArtifact;
    }

    public InputArtifactProviderImpl(@NotNull BuildArtifactsHolder artifactsHolder, @NotNull Collection<? extends ArtifactType> referencedInputTypes, @NotNull Collection<? extends ArtifactType> transformedInputTypes, @NotNull FileCollection defaultValue, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)artifactsHolder, (String)"artifactsHolder");
        Intrinsics.checkParameterIsNotNull(referencedInputTypes, (String)"referencedInputTypes");
        Intrinsics.checkParameterIsNotNull(transformedInputTypes, (String)"transformedInputTypes");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.artifactsHolder = artifactsHolder;
        this.referencedInputTypes = referencedInputTypes;
        this.transformedInputTypes = transformedInputTypes;
        this.defaultValue = defaultValue;
        this.dslScope = dslScope;
        Set common = CollectionsKt.intersect((Iterable)this.referencedInputTypes, (Iterable)this.transformedInputTypes);
        if (!common.isEmpty()) {
            throw (Throwable)new ArtifactConfigurationException(Joiner.on((String)",").join((Iterable)common) + " types are requested as intermediates and final types input");
        }
    }
}

