/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2ErrorUtils;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.symbols.SymbolIo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.BuildException;

@CacheableTask
public class LinkApplicationAndroidResourcesTask
extends ProcessAndroidResources {
    private static final String IR_APK_FILE_NAME = "resources";
    private static final Logger LOG = Logging.getLogger(LinkApplicationAndroidResourcesTask.class);
    private File sourceOutputDir;
    private Supplier<File> textSymbolOutputDir = () -> null;
    private File symbolsWithPackageNameOutputFile;
    private File proguardOutputFile;
    private File mainDexListProguardOutputFile;
    private FileCollection dependenciesFileCollection;
    private FileCollection sharedLibraryDependencies;
    private Supplier<Integer> resOffsetSupplier = null;
    private MultiOutputPolicy multiOutputPolicy;
    private VariantType type;
    private FileCollection aapt2FromMaven;
    private boolean debuggable;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;
    private InstantRunBuildContext buildContext;
    private FileCollection featureResourcePackages;
    private Supplier<String> originalApplicationId;
    private String buildTargetDensity;
    private boolean useConditionalKeepRules;
    private File resPackageOutputFolder;
    private String projectBaseName;
    private InternalArtifactType taskInputType;
    private boolean isNamespaced = false;
    private VariantScope variantScope;
    SplitList splitList;
    private Supplier<String> applicationId;
    private File supportDirectory;
    private BuildableArtifact apkList;
    private BuildableArtifact convertedLibraryDependencies;
    private BuildableArtifact inputResourcesDir;
    boolean isLibrary;

    @Input
    public boolean getUseConditionalKeepRules() {
        return this.useConditionalKeepRules;
    }

    @Input
    public InternalArtifactType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    public InstantRunPatchingPolicy getPatchingPolicy() {
        return this.buildContext.getPatchingPolicy();
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    public boolean canHaveSplits() {
        return this.variantScope.getType().getCanHaveSplits();
    }

    @Internal
    private Set<String> getSplits(SplitList splitList) {
        return splitList.getSplits(this.multiOutputPolicy);
    }

    @Input
    public String getApplicationId() {
        return this.applicationId.get();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getApkList() {
        return this.apkList;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public BuildableArtifact getConvertedLibraryDependencies() {
        return this.convertedLibraryDependencies;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        BuildElements manifestBuildElements = ExistingBuildElements.from((ArtifactType)this.taskInputType, (Provider<Directory>)this.manifestFiles);
        ImmutableSet featureResourcePackages = this.featureResourcePackages != null ? this.featureResourcePackages.getFiles() : ImmutableSet.of();
        Set dependencies = this.dependenciesFileCollection != null ? this.dependenciesFileCollection.getFiles() : Collections.emptySet();
        Set imports = this.sharedLibraryDependencies != null ? this.sharedLibraryDependencies.getFiles() : Collections.emptySet();
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        try {
            Aapt2ServiceKey aapt2ServiceKey = Aapt2DaemonManagerService.registerAaptService(this.aapt2FromMaven, this.getBuildTools(), this.getILogger());
            List unprocessedManifest = manifestBuildElements.stream().collect(Collectors.toList());
            BuildOutput mainOutput = this.chooseOutput(manifestBuildElements);
            unprocessedManifest.remove(mainOutput);
            buildOutputs.add((Object)this.invokeAaptForSplit(mainOutput, dependencies, imports, this.splitList, (Set<File>)featureResourcePackages, mainOutput.getApkInfo(), true, aapt2ServiceKey));
            if (this.variantScope.getType().getCanHaveSplits()) {
                for (BuildOutput manifestBuildOutput : unprocessedManifest) {
                    ApkInfo apkInfo = manifestBuildOutput.getApkInfo();
                    if (!apkInfo.requiresAapt()) continue;
                    executor.execute(() -> this.lambda$doFullTaskAction$1(manifestBuildOutput, dependencies, imports, (Set)featureResourcePackages, apkInfo, aapt2ServiceKey));
                }
            }
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
                buildOutputs.add(taskResult.getValue());
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.multiOutputPolicy == MultiOutputPolicy.SPLITS) {
            List unprocessedManifest = manifestBuildElements.stream().collect(Collectors.toList());
            for (BuildOutput manifestBuildOutput : unprocessedManifest) {
                ApkInfo apkInfo = manifestBuildOutput.getApkInfo();
                if (apkInfo.getFilters().stream().anyMatch(f -> f.getFilterType().equals(VariantOutput.FilterType.ABI))) continue;
                File packagedResForSplit = LinkApplicationAndroidResourcesTask.findPackagedResForSplit(this.resPackageOutputFolder, apkInfo);
                if (packagedResForSplit != null) {
                    buildOutputs.add((Object)new BuildOutput(InternalArtifactType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, apkInfo, packagedResForSplit));
                    continue;
                }
                this.getLogger().warn("Cannot find output for " + apkInfo);
            }
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(this.resPackageOutputFolder);
    }

    BuildOutput chooseOutput(BuildElements manifestBuildElements) {
        switch (this.multiOutputPolicy) {
            case SPLITS: {
                java.util.Optional<BuildOutput> main = manifestBuildElements.stream().filter(output2 -> output2.getApkInfo().getType() == VariantOutput.OutputType.MAIN).findFirst();
                if (!main.isPresent()) {
                    throw new RuntimeException("No main apk found");
                }
                return main.get();
            }
            case MULTI_APK: {
                java.util.Optional<BuildOutput> nonDensity = manifestBuildElements.stream().filter(output2 -> output2.getApkInfo().getFilter(VariantOutput.FilterType.DENSITY) == null).findFirst();
                if (!nonDensity.isPresent()) {
                    throw new RuntimeException("No non-density apk found");
                }
                return nonDensity.get();
            }
        }
        throw new RuntimeException("Unexpected MultiOutputPolicy type: " + (Object)((Object)this.multiOutputPolicy));
    }

    File getOutputBaseNameFile(ApkInfo apkInfo) {
        return new File(this.resPackageOutputFolder, "resources-" + apkInfo.getFullName() + ".ap_");
    }

    BuildOutput invokeAaptForSplit(BuildOutput manifestOutput, Set<File> dependencies, Set<File> imports, SplitList splitList, Set<File> featureResourcePackages, ApkInfo apkInfo, boolean generateCode, Aapt2ServiceKey aapt2ServiceKey) throws IOException {
        FilterData densityFilterData;
        ImmutableList.Builder featurePackagesBuilder = ImmutableList.builder();
        for (File featurePackage : featureResourcePackages) {
            BuildElements buildElements = ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, featurePackage);
            if (buildElements.isEmpty()) continue;
            BuildOutput mainBuildOutput = buildElements.elementByType(VariantOutput.OutputType.MAIN);
            if (mainBuildOutput != null) {
                featurePackagesBuilder.add((Object)mainBuildOutput.getOutputFile());
                continue;
            }
            throw new IOException("Cannot find PROCESSED_RES output for " + this.variantScope.getOutputScope().getMainSplit());
        }
        File resOutBaseNameFile = this.getOutputBaseNameFile(apkInfo);
        File manifestFile = manifestOutput.getOutputFile();
        String packageForR = null;
        File srcOut = null;
        File symbolOutputDir = null;
        File proguardOutputFile = null;
        File mainDexListProguardOutputFile = null;
        if (generateCode) {
            packageForR = this.isNamespaced && this.variantScope.getVariantData().getType() == VariantTypeImpl.FEATURE ? "dummy" : this.originalApplicationId.get();
            srcOut = this.getSourceOutputDir();
            if (srcOut != null) {
                FileUtils.cleanOutputDir((File)srcOut);
            }
            symbolOutputDir = this.textSymbolOutputDir.get();
            proguardOutputFile = this.getProguardOutputFile();
            mainDexListProguardOutputFile = this.getMainDexListProguardOutputFile();
        }
        String preferredDensity = (densityFilterData = apkInfo.getFilter(VariantOutput.FilterType.DENSITY)) != null ? densityFilterData.getIdentifier() : (splitList.getResourceConfigs().isEmpty() ? this.buildTargetDensity : null);
        try {
            if (this.buildContext.isInInstantRunMode() && this.buildContext.getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
                this.supportDirectory.mkdirs();
                manifestFile = InstantRunSliceSplitApkBuilder.generateSplitApkManifest(this.supportDirectory, IR_APK_FILE_NAME, this.applicationId, apkInfo.getVersionName(), apkInfo.getVersionCode(), manifestOutput.getProperties().get("minSdkVersion"));
            }
            AaptPackageConfig.Builder configBuilder = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setCustomPackageForR(packageForR).setSymbolOutputDir(symbolOutputDir).setSourceOutputDir(srcOut).setResourceOutputApk(resOutBaseNameFile).setProguardOutputFile(proguardOutputFile).setMainDexListProguardOutputFile(mainDexListProguardOutputFile).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setResourceConfigs(splitList.getResourceConfigs()).setSplits(this.getSplits(splitList)).setPreferredDensity(preferredDensity).setPackageId(this.getResOffset()).setAllowReservedPackageId(this.resOffsetSupplier != null && this.resOffsetSupplier.get() < 127).setDependentFeatures((Collection)featurePackagesBuilder.build()).setImports(imports).setIntermediateDir(this.getIncrementalFolder()).setAndroidTarget(this.getBuilder().getTarget()).setUseConditionalKeepRules(this.useConditionalKeepRules);
            if (this.isNamespaced) {
                ImmutableList.Builder packagedDependencies = ImmutableList.builder();
                packagedDependencies.addAll(dependencies);
                if (this.convertedLibraryDependencies != null) {
                    try (Stream<Path> list = Files.list(BuildableArtifactUtil.singleFile(this.convertedLibraryDependencies).toPath());){
                        list.map(Path::toFile).forEach(arg_0 -> ((ImmutableList.Builder)packagedDependencies).add(arg_0));
                    }
                }
                configBuilder.setStaticLibraryDependencies(packagedDependencies.build());
            } else {
                if (generateCode) {
                    configBuilder.setLibrarySymbolTableFiles(dependencies);
                }
                configBuilder.setResourceDir(BuildableArtifactUtil.singleFile((BuildableArtifact)Preconditions.checkNotNull((Object)this.getInputResourcesDir())));
            }
            Preconditions.checkNotNull((Object)aapt2ServiceKey, (Object)"AAPT2 daemon manager service not initialized");
            try (Aapt2DaemonManager.LeasedAaptDaemon aaptDaemon = Aapt2DaemonManagerService.getAaptDaemon(aapt2ServiceKey);){
                AndroidBuilder.processResources((BlockingResourceLinker)aaptDaemon, (AaptPackageConfig)configBuilder.build(), (ILogger)this.getILogger());
            }
            catch (Aapt2Exception e) {
                throw Aapt2ErrorUtils.rewriteLinkException(e, new MergingLog(this.getMergeBlameLogFolder()));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Aapt output file {}", (Object)resOutBaseNameFile.getAbsolutePath());
            }
            if (generateCode && (this.isLibrary || !dependencies.isEmpty()) && this.symbolsWithPackageNameOutputFile != null) {
                SymbolIo.writeSymbolListWithPackageName((Path)((File)Preconditions.checkNotNull((Object)this.getTextSymbolOutputFile())).toPath(), (Path)manifestFile.toPath(), (Path)this.symbolsWithPackageNameOutputFile.toPath());
            }
            return new BuildOutput((ArtifactType)InternalArtifactType.PROCESSED_RES, apkInfo, resOutBaseNameFile, manifestOutput.getProperties());
        }
        catch (ProcessException e) {
            throw new BuildException("Failed to process resources, see aapt output above for details.", (Throwable)e);
        }
    }

    private static File findPackagedResForSplit(File outputFolder, ApkInfo apkInfo) {
        Pattern resourcePattern = Pattern.compile("resources-" + apkInfo.getFullName() + ".ap__(.*)");
        if (outputFolder == null) {
            return null;
        }
        File[] files2 = outputFolder.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                Matcher match = resourcePattern.matcher(file.getName());
                if (!match.matches() || match.group(1).isEmpty() || !LinkApplicationAndroidResourcesTask.isValidSplit(apkInfo, match.group(1))) continue;
                return file;
            }
        }
        return null;
    }

    private static boolean isValidSplit(ApkInfo apkInfo, String splitWithOptionalSuffix) {
        FilterData splitFilter = apkInfo.getFilter(VariantOutput.FilterType.DENSITY);
        if (splitFilter != null && splitWithOptionalSuffix.startsWith(splitFilter.getIdentifier())) {
            return true;
        }
        String mangledName = LinkApplicationAndroidResourcesTask.unMangleSplitName(splitWithOptionalSuffix);
        splitFilter = apkInfo.getFilter(VariantOutput.FilterType.LANGUAGE);
        return splitFilter != null && mangledName.equals(splitFilter.getIdentifier());
    }

    public static String unMangleSplitName(String splitWithOptionalSuffix) {
        String mangledName = splitWithOptionalSuffix.replaceAll("_", ",");
        return mangledName.contains("-r") ? mangledName : mangledName.replace("-", "-r");
    }

    @Optional
    @Input
    public Integer getResOffset() {
        return this.resOffsetSupplier != null ? this.resOffsetSupplier.get() : null;
    }

    @Input
    public boolean isInstantRunMode() {
        return this.buildContext.isInInstantRunMode();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getInputResourcesDir() {
        return this.inputResourcesDir;
    }

    @Override
    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputFile
    @Optional
    public File getTextSymbolOutputFile() {
        File outputDir = this.textSymbolOutputDir.get();
        return outputDir != null ? new File(outputDir, "R.txt") : null;
    }

    @OutputFile
    @Optional
    public File getSymbolslWithPackageNameOutputFile() {
        return this.symbolsWithPackageNameOutputFile;
    }

    @OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @OutputFile
    @Optional
    public File getMainDexListProguardOutputFile() {
        return this.mainDexListProguardOutputFile;
    }

    public void setAaptMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
        this.mainDexListProguardOutputFile = mainDexListProguardOutputFile;
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getDependenciesFileCollection() {
        return this.dependenciesFileCollection;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getSharedLibraryDependencies() {
        return this.sharedLibraryDependencies;
    }

    @Input
    public String getTypeAsString() {
        return this.type.getName();
    }

    @Internal
    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Internal
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureResourcePackages() {
        return this.featureResourcePackages;
    }

    @Input
    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    @Input
    public String getOriginalApplicationId() {
        return this.originalApplicationId.get();
    }

    @Nested
    @Optional
    public SplitList getSplitListInput() {
        return this.splitList;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    public File getResPackageOutputFolder() {
        return this.resPackageOutputFolder;
    }

    @Input
    public boolean isLibrary() {
        return this.isLibrary;
    }

    @Input
    public boolean isNamespaced() {
        return this.isNamespaced;
    }

    private /* synthetic */ BuildOutput lambda$doFullTaskAction$1(BuildOutput manifestBuildOutput, Set dependencies, Set imports, Set featureResourcePackages, ApkInfo apkInfo, Aapt2ServiceKey aapt2ServiceKey) throws Exception {
        return this.invokeAaptForSplit(manifestBuildOutput, dependencies, imports, this.splitList, featureResourcePackages, apkInfo, false, aapt2ServiceKey);
    }

    public static final class NamespacedCreationAction
    extends BaseCreationAction {
        private File sourceOutputDir;

        public NamespacedCreationAction(VariantScope scope, boolean generateLegacyMultidexMainDexProguardRules, String baseName) {
            super(scope, generateLegacyMultidexMainDexProguardRules, baseName, false);
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.sourceOutputDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.RUNTIME_R_CLASS_SOURCES, taskName, "out");
        }

        @Override
        public final void configure(LinkApplicationAndroidResourcesTask task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            ProjectOptions projectOptions = variantScope.getGlobalScope().getProjectOptions();
            task.sourceOutputDir = this.sourceOutputDir;
            ArrayList<Object> dependencies = new ArrayList<Object>(2);
            dependencies.add(variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.RES_STATIC_LIBRARY).get());
            dependencies.add(variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY));
            if (variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced() && projectOptions.get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
                task.convertedLibraryDependencies = variantScope.getArtifacts().getArtifactFiles(InternalArtifactType.RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES);
            }
            task.dependenciesFileCollection = (FileCollection)variantScope.getGlobalScope().getProject().files(new Object[]{dependencies});
            task.sharedLibraryDependencies = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY);
            task.isNamespaced = true;
        }
    }

    public static final class CreationAction
    extends BaseCreationAction {
        protected final Supplier<File> symbolLocation;
        private final File symbolsWithPackageNameOutputFile;
        private final TaskManager.MergeType sourceArtifactType;
        private File sourceOutputDir;

        public CreationAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageNameOutputFile, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceArtifactType, String baseName, boolean isLibrary) {
            super(scope, generateLegacyMultidexMainDexProguardRules, baseName, isLibrary);
            this.symbolLocation = symbolLocation;
            this.symbolsWithPackageNameOutputFile = symbolsWithPackageNameOutputFile;
            this.sourceArtifactType = sourceArtifactType;
        }

        @Override
        protected final void preconditionsCheck(BaseVariantData variantData) {
            if (variantData.getType().isAar()) {
                throw new IllegalArgumentException("Use GenerateLibraryRFileTask");
            }
            Preconditions.checkState((this.sourceArtifactType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (String)"source output type should be MERGE", (Object)((Object)this.sourceArtifactType));
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.sourceOutputDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES, taskName, "r");
        }

        @Override
        public final void configure(LinkApplicationAndroidResourcesTask task) {
            super.configure(task);
            task.sourceOutputDir = this.sourceOutputDir;
            task.dependenciesFileCollection = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME);
            task.inputResourcesDir = this.getVariantScope().getArtifacts().getFinalArtifactFiles(this.sourceArtifactType.getOutputType());
            task.textSymbolOutputDir = this.symbolLocation;
            task.symbolsWithPackageNameOutputFile = this.symbolsWithPackageNameOutputFile;
        }
    }

    private static abstract class BaseCreationAction
    extends VariantTaskCreationAction<LinkApplicationAndroidResourcesTask> {
        private final boolean generateLegacyMultidexMainDexProguardRules;
        private final String baseName;
        private final boolean isLibrary;
        private File resPackageOutputFolder;
        private File proguardOutputFile;
        private File aaptMainDexListProguardOutputFile;

        public BaseCreationAction(VariantScope scope, boolean generateLegacyMultidexMainDexProguardRules, String baseName, boolean isLibrary) {
            super(scope);
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
            this.baseName = baseName;
            this.isLibrary = isLibrary;
        }

        @Override
        public final String getName() {
            return this.getVariantScope().getTaskName("process", "Resources");
        }

        @Override
        public final Class<LinkApplicationAndroidResourcesTask> getType() {
            return LinkApplicationAndroidResourcesTask.class;
        }

        protected void preconditionsCheck(BaseVariantData variantData) {
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            VariantScope variantScope = this.getVariantScope();
            this.resPackageOutputFolder = variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.PROCESSED_RES, taskName, "out");
            if (LinkApplicationAndroidResourcesTask.generatesProguardOutputFile(variantScope)) {
                this.proguardOutputFile = variantScope.getProcessAndroidResourcesProguardOutputFile();
                variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AAPT_PROGUARD_FILE, (Collection<? extends Object>)ImmutableList.of((Object)this.proguardOutputFile), taskName);
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                this.aaptMainDexListProguardOutputFile = variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES, taskName, "manifest_keep.txt");
            }
        }

        @Override
        public void handleProvider(TaskProvider<? extends LinkApplicationAndroidResourcesTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setProcessAndroidResTask(taskProvider);
        }

        @Override
        public void configure(LinkApplicationAndroidResourcesTask task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            BaseVariantData variantData = variantScope.getVariantData();
            ProjectOptions projectOptions = variantScope.getGlobalScope().getProjectOptions();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            this.preconditionsCheck(variantData);
            task.resPackageOutputFolder = this.resPackageOutputFolder;
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(variantScope.getGlobalScope());
            task.applicationId = TaskInputHelper.memoize(config2::getApplicationId);
            task.setIncrementalFolder(variantScope.getIncrementalDir(this.getName()));
            if (variantData.getType().getCanHaveSplits()) {
                Splits splits = variantScope.getGlobalScope().getExtension().getSplits();
                ImmutableSet densitySet = splits.getDensity().isEnable() ? ImmutableSet.copyOf(splits.getDensityFilters()) : ImmutableSet.of();
                ImmutableSet languageSet = splits.getLanguage().isEnable() ? ImmutableSet.copyOf(splits.getLanguageFilters()) : ImmutableSet.of();
                ImmutableSet abiSet = splits.getAbi().isEnable() ? ImmutableSet.copyOf(splits.getAbiFilters()) : ImmutableSet.of();
                ImmutableSet resConfigSet = ImmutableSet.copyOf((Collection)variantScope.getVariantConfiguration().getMergedFlavor().getResourceConfigurations());
                task.splitList = new SplitList((ImmutableSet<String>)densitySet, (ImmutableSet<String>)languageSet, (ImmutableSet<String>)abiSet, (ImmutableSet<String>)resConfigSet);
            } else {
                task.splitList = new SplitList((ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of());
            }
            task.multiOutputPolicy = variantData.getMultiOutputPolicy();
            task.apkList = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            if (LinkApplicationAndroidResourcesTask.generatesProguardOutputFile(variantScope)) {
                task.setProguardOutputFile(this.proguardOutputFile);
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                task.setAaptMainDexListProguardOutputFile(this.aaptMainDexListProguardOutputFile);
            }
            task.variantScope = variantScope;
            task.outputScope = variantData.getOutputScope();
            task.originalApplicationId = TaskInputHelper.memoize(config2::getOriginalApplicationId);
            boolean aaptFriendlyManifestsFilePresent = variantScope.getArtifacts().hasFinalProduct(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            task.taskInputType = aaptFriendlyManifestsFilePresent ? InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS : variantScope.getManifestArtifactType();
            task.setManifestFiles((Provider<Directory>)variantScope.getArtifacts().getFinalProduct(task.taskInputType));
            task.setType(config2.getType());
            task.setDebuggable(((CoreBuildType)config2.getBuildType()).isDebuggable());
            task.setAaptOptions(variantScope.getGlobalScope().getExtension().getAaptOptions());
            task.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            task.useConditionalKeepRules = projectOptions.get(BooleanOption.CONDITIONAL_KEEP_RULES);
            task.setMergeBlameLogFolder(variantScope.getResourceBlameLogDir());
            task.buildContext = variantScope.getInstantRunBuildContext();
            VariantType variantType = variantScope.getType();
            task.featureResourcePackages = variantType.isForTesting() ? null : variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG);
            if (variantType.isFeatureSplit()) {
                task.resOffsetSupplier = FeatureSetMetadata.getInstance().getResOffsetSupplierForTask(variantScope, (Task)task);
            }
            task.projectBaseName = this.baseName;
            task.isLibrary = this.isLibrary;
            task.supportDirectory = new File(variantScope.getInstantRunSplitApkOutputFolder(), LinkApplicationAndroidResourcesTask.IR_APK_FILE_NAME);
        }
    }
}

