/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LibraryJniLibsTransform
extends Transform {
    private final String name;
    private final File jniLibsFolder;
    private final Set<QualifiedContent.ScopeType> scopes;
    private final Pattern pattern = Pattern.compile("lib/[^/]+/[^/]+\\.so");

    public LibraryJniLibsTransform(String name, File jniLibsFolder, Set<QualifiedContent.ScopeType> scopes) {
        this.name = name;
        this.jniLibsFolder = jniLibsFolder;
        this.scopes = scopes;
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_NATIVE_LIBS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return false;
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.jniLibsFolder);
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        FileUtils.cleanOutputDir((File)this.jniLibsFolder);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        for (TransformInput input2 : invocation.getReferencedInputs()) {
            for (JarInput jarInput : input2.getJarInputs()) {
                executor.execute(() -> {
                    this.copyFromJar(jarInput.getFile());
                    return null;
                });
            }
            for (DirectoryInput directoryInput : input2.getDirectoryInputs()) {
                executor.execute(() -> {
                    this.copyFromFolder(directoryInput.getFile());
                    return null;
                });
            }
        }
        executor.waitForTasksWithQuickFail(true);
    }

    private void copyFromFolder(File rootDirectory) throws IOException {
        this.copyFromFolder(rootDirectory, Lists.newArrayListWithCapacity((int)3));
    }

    private void copyFromFolder(File from, List<String> pathSegments) throws IOException {
        File[] children = from.listFiles((file, name) -> file.isDirectory() || name.endsWith(".so"));
        if (children != null) {
            for (File child : children) {
                pathSegments.add(child.getName());
                if (child.isDirectory()) {
                    this.copyFromFolder(child, pathSegments);
                } else if (child.isFile() && this.pattern.matcher(Joiner.on((char)'/').join(pathSegments)).matches()) {
                    File to = FileUtils.join((File)this.jniLibsFolder, pathSegments.subList(1, 3));
                    FileUtils.mkdirs((File)to.getParentFile());
                    Files.copy((File)child, (File)to);
                }
                pathSegments.remove(pathSegments.size() - 1);
            }
        }
    }

    private void copyFromJar(File jarFile) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!this.pattern.matcher(entryPath).matches() || !ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) continue;
                buffer.reset();
                ByteStreams.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)buffer);
                File to = LibraryJniLibsTransform.computeFile(this.jniLibsFolder, entryPath);
                FileUtils.mkdirs((File)to.getParentFile());
                Files.write((byte[])buffer.toByteArray(), (File)to);
            }
        }
    }

    private static File computeFile(File rootFolder, String path) {
        path = FileUtils.toSystemDependentPath((String)path.substring(4));
        return new File(rootFolder, path);
    }
}

