/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.builder.model.AndroidArtifactOutput;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class AndroidArtifactOutputImpl
implements AndroidArtifactOutput,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EarlySyncBuildOutput mainOutput;
    private final EarlySyncBuildOutput manifestOutput;
    private final Collection<EarlySyncBuildOutput> splitApksOutputs;

    public AndroidArtifactOutputImpl(EarlySyncBuildOutput mainOutput, EarlySyncBuildOutput manifestOutput) {
        this(mainOutput, manifestOutput, (List<EarlySyncBuildOutput>)ImmutableList.of());
    }

    public AndroidArtifactOutputImpl(EarlySyncBuildOutput mainApk, EarlySyncBuildOutput manifestOutput, List<EarlySyncBuildOutput> splitApksOutputs) {
        this.mainOutput = mainApk;
        this.manifestOutput = manifestOutput;
        this.splitApksOutputs = splitApksOutputs;
    }

    public File getOutputFile() {
        return this.getMainOutputFile().getOutputFile();
    }

    public OutputFile getMainOutputFile() {
        return this.mainOutput;
    }

    public Collection<OutputFile> getOutputs() {
        ImmutableList.Builder outputFileBuilder = ImmutableList.builder();
        outputFileBuilder.add((Object)this.mainOutput);
        this.splitApksOutputs.forEach(arg_0 -> ((ImmutableList.Builder)outputFileBuilder).add(arg_0));
        return outputFileBuilder.build();
    }

    public String getAssembleTaskName() {
        throw new RuntimeException("Deprecated.");
    }

    public String getOutputType() {
        return this.mainOutput.getOutputType();
    }

    public Collection<String> getFilterTypes() {
        return this.mainOutput.getFilterTypes();
    }

    public String getFilter(String filterType) {
        return this.mainOutput.getFilter(filterType);
    }

    public Collection<FilterData> getFilters() {
        return this.mainOutput.getFilters();
    }

    public File getGeneratedManifest() {
        return this.manifestOutput.getOutputFile();
    }

    public int getVersionCode() {
        return this.mainOutput.getVersionCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidArtifactOutputImpl that = (AndroidArtifactOutputImpl)o;
        return Objects.equals(this.mainOutput, that.mainOutput) && Objects.equals(this.manifestOutput, that.manifestOutput) && Objects.equals(this.splitApksOutputs, that.splitApksOutputs);
    }

    public int hashCode() {
        return Objects.hash(this.splitApksOutputs, this.manifestOutput, this.mainOutput);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("output", (Object)this.mainOutput).add("manifest", (Object)this.manifestOutput).add("pure splits", this.splitApksOutputs).toString();
    }
}

