/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\t"}, d2={"getApkFiles", "", "Ljava/nio/file/Path;", "apkBundle", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "moduleName", "", "getDeviceJson", "gradle"})
@JvmName(name="BundleInstallUtils")
public final class BundleInstallUtils {
    @NotNull
    public static final Path getDeviceJson(@NotNull DeviceConfigProvider device) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Object object = device.getApiCodeName();
        if (object == null) {
            object = device.getApiLevel();
        }
        String api = object;
        int density = device.getDensity();
        List abis = device.getAbis();
        Set languages = device.getLanguageSplits();
        Path $receiver = path = Files.createTempFile("apkSelect", "", new FileAttribute[0]);
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append("{\n").append("  \"supportedAbis\": [");
        List list = abis;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"abis");
        String json = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append("],\n").append("  \"screenDensity\": ").append(density).append(",\n").append("  \"sdkVersion\": ").append((Object)api).toString();
        if (languages != null && !languages.isEmpty()) {
            json = json + ",\n  \"supportedLocales\": [ " + Joiner.on((char)',').join((Iterable)languages) + " ]\n";
        }
        String string = json = json + '}';
        Charset charset = Charsets.UTF_8;
        Path path2 = $receiver;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path2, byArray2, new OpenOption[0]);
        Path path3 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.createTempFile(\"ap\u2026ay(Charsets.UTF_8))\n    }");
        return path3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> getApkFiles(@NotNull Path apkBundle, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Object it2;
        Intrinsics.checkParameterIsNotNull((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Path jsonFile = BundleInstallUtils.getDeviceJson(device);
        Path path = Files.createTempDirectory("apkSelect", new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Files.createTempDirectory(\"apkSelect\")");
        Path tempFolder = path;
        Devices.DeviceSpec.Builder builder = Devices.DeviceSpec.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Devices.DeviceSpec.newBuilder()");
        Devices.DeviceSpec.Builder builder2 = builder;
        Closeable closeable = Files.newBufferedReader(jsonFile, Charsets.UTF_8);
        Object object = null;
        try {
            it2 = (BufferedReader)closeable;
            boolean bl = false;
            JsonFormat.parser().merge((Reader)it2, (Message.Builder)builder2);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(apkBundle).setDeviceSpec(builder2.build()).setOutputDirectory(tempFolder);
        String string = moduleName;
        if (string != null) {
            it2 = object = string;
            boolean bl = false;
            command.setModules(ImmutableSet.of((Object)it2));
        }
        ImmutableList immutableList = command.build().execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"command.build().execute()");
        return (List)immutableList;
    }

    @NotNull
    public static /* synthetic */ List getApkFiles$default(Path path, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(path, deviceConfigProvider, string);
    }
}

