/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.testing.MockableJarGenerator;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class MockableJarTransform
extends ArtifactTransform {
    private final boolean returnDefaultValues;

    @Inject
    public MockableJarTransform(boolean returnDefaultValues) {
        this.returnDefaultValues = returnDefaultValues;
    }

    public List<File> transform(File input2) {
        File outputDir = this.getOutputDirectory();
        FileUtils.mkdirs((File)outputDir);
        File outputFile = new File(outputDir, input2.getName());
        System.out.println("Calling mockable JAR artifact transform to create file: " + outputFile.getAbsolutePath() + " with input " + input2.getAbsolutePath());
        MockableJarGenerator generator = new MockableJarGenerator(this.returnDefaultValues);
        try {
            generator.createMockableJar(input2, outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create mockable android.jar", e);
        }
        return ImmutableList.of((Object)outputFile);
    }
}

