/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.Constructor;
import com.android.build.gradle.internal.incremental.LocalVariable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class ConstructorBuilder {
    public static Constructor build(String owner, MethodNode method) {
        BasicInterpreter interpreter = new BasicInterpreter(){
            boolean done = false;

            public BasicValue newValue(Type type) {
                if (type == null) {
                    return BasicValue.UNINITIALIZED_VALUE;
                }
                if (type.getSort() == 0) {
                    return null;
                }
                LocalValue ret = this.done ? super.newValue(type) : new LocalValue(type);
                this.done = true;
                return ret;
            }
        };
        Analyzer analyzer = new Analyzer((Interpreter)interpreter);
        AbstractInsnNode[] instructions = method.instructions.toArray();
        try {
            Frame[] frames = analyzer.analyze(owner, method);
            if (frames.length != instructions.length) {
                throw new IllegalStateException("The number of frames is not equals to the number of instructions");
            }
            int stackAtThis = -1;
            boolean poppedThis = false;
            int firstLocal = 1;
            for (Type type : Type.getArgumentTypes((String)method.desc)) {
                firstLocal += type.getSize();
            }
            LinkedHashSet<LocalVariable> variables = new LinkedHashSet<LocalVariable>();
            VarInsnNode lastThis = null;
            int localsAtLastThis = 0;
            int recentLine = -1;
            for (int i = 0; i < instructions.length; ++i) {
                AbstractInsnNode insn = instructions[i];
                Frame frame = frames[i];
                if (frame.getStackSize() < stackAtThis) {
                    poppedThis = true;
                }
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode methodhInsn = (MethodInsnNode)insn;
                    Type[] types = Type.getArgumentTypes((String)methodhInsn.desc);
                    Value value = frame.getStack(frame.getStackSize() - types.length - 1);
                    if (!(value instanceof LocalValue) || !methodhInsn.name.equals("<init>")) continue;
                    if (poppedThis) {
                        throw new IllegalStateException("Unexpected constructor structure.");
                    }
                    return ConstructorBuilder.split(owner, method, lastThis, methodhInsn, recentLine, new ArrayList<LocalVariable>(variables), localsAtLastThis);
                }
                if (insn instanceof VarInsnNode) {
                    Type type;
                    VarInsnNode var = (VarInsnNode)insn;
                    if (var.var == 0) {
                        lastThis = var;
                        localsAtLastThis = variables.size();
                        stackAtThis = frame.getStackSize();
                        poppedThis = false;
                    }
                    if ((type = ByteCodeUtils.getTypeForStoreOpcode(var.getOpcode())) == null || var.var < firstLocal) continue;
                    variables.add(new LocalVariable(type, var.var));
                    continue;
                }
                if (!(insn instanceof LineNumberNode)) continue;
                LineNumberNode lineNumberNode = (LineNumberNode)insn;
                recentLine = lineNumberNode.line;
            }
            throw new IllegalStateException("Unexpected constructor structure.");
        }
        catch (AnalyzerException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor split(String owner, MethodNode method, VarInsnNode loadThis, MethodInsnNode delegation, int loadThisLine, List<LocalVariable> variables, int localsAtLoadThis) {
        AbstractInsnNode insn;
        String[] exceptions = method.exceptions.toArray(new String[method.exceptions.size()]);
        String newDesc = method.desc.replace(")V", ")Ljava/lang/Object;");
        newDesc = newDesc.replace("(", "([L" + owner + ";");
        Type[] argumentTypes = Type.getArgumentTypes((String)newDesc);
        LinkedList fixed = Lists.newLinkedList();
        for (insn = method.instructions.getFirst(); insn != loadThis; insn = insn.getNext()) {
            fixed.add(insn);
        }
        fixed.add(loadThis);
        MethodNode initArgs = new MethodNode(9, "init$args", newDesc, null, exceptions);
        GeneratorAdapter mv = new GeneratorAdapter((MethodVisitor)initArgs, initArgs.access, initArgs.name, initArgs.desc);
        int newArgument = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        mv.loadLocal(newArgument);
        ByteCodeUtils.restoreVariables(mv, variables.subList(0, localsAtLoadThis));
        for (insn = loadThis.getNext(); insn != delegation; insn = insn.getNext()) {
            insn.accept((MethodVisitor)mv);
        }
        LabelNode labelBefore = new LabelNode();
        labelBefore.accept((MethodVisitor)mv);
        Type[] returnTypes = Type.getArgumentTypes((String)delegation.desc);
        mv.push(returnTypes.length + 2);
        mv.newArray(Type.getType(Object.class));
        int args2 = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        mv.storeLocal(args2);
        for (int i = returnTypes.length - 1; i >= 0; --i) {
            Type type = returnTypes[i];
            mv.loadLocal(args2);
            mv.swap(type, Type.getType(Object.class));
            mv.push(i + 2);
            mv.swap(type, Type.INT_TYPE);
            mv.box(type);
            mv.arrayStore(Type.getType(Object.class));
        }
        mv.loadLocal(args2);
        mv.push(1);
        mv.push(delegation.owner + "." + delegation.desc);
        mv.arrayStore(Type.getType(Object.class));
        mv.loadLocal(args2);
        mv.push(0);
        mv.push(argumentTypes.length + 1);
        mv.newArray(Type.getType(Object.class));
        ByteCodeUtils.loadVariableArray(mv, ByteCodeUtils.toLocalVariables(Arrays.asList(argumentTypes)), 0);
        mv.dup();
        mv.push(argumentTypes.length);
        ByteCodeUtils.newVariableArray(mv, variables);
        mv.arrayStore(Type.getType(Object.class));
        mv.arrayStore(Type.getType(Object.class));
        mv.loadLocal(args2);
        mv.returnValue();
        initArgs.desc = initArgs.desc.replace(")", "[Ljava/lang/Object;)");
        newDesc = method.desc.replace("(", "(L" + owner + ";");
        MethodNode body = new MethodNode(9, "init$body", newDesc, null, exceptions);
        mv = new GeneratorAdapter((MethodVisitor)body, body.access, body.name, body.desc);
        newArgument = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        LabelNode labelAfter = new LabelNode();
        labelAfter.accept((MethodVisitor)body);
        HashSet<LabelNode> bodyLabels = new HashSet<LabelNode>();
        mv.loadLocal(newArgument);
        ByteCodeUtils.restoreVariables(mv, variables);
        for (insn = delegation.getNext(); insn != null; insn = insn.getNext()) {
            if (insn instanceof LabelNode) {
                bodyLabels.add((LabelNode)insn);
            }
            insn.accept((MethodVisitor)mv);
        }
        for (TryCatchBlockNode tryCatch : method.tryCatchBlocks) {
            tryCatch.accept((MethodVisitor)mv);
        }
        for (LocalVariableNode variable : method.localVariables) {
            boolean startsInBody = bodyLabels.contains(variable.start);
            boolean endsInBody = bodyLabels.contains(variable.end);
            if (!startsInBody && !endsInBody) {
                if (variable.index == 0) continue;
                variable.accept((MethodVisitor)initArgs);
                continue;
            }
            if (startsInBody && endsInBody) {
                variable.accept((MethodVisitor)body);
                continue;
            }
            if (!startsInBody && endsInBody) {
                if (variable.index != 0) {
                    LocalVariableNode var0 = new LocalVariableNode(variable.name, variable.desc, variable.signature, variable.start, labelBefore, variable.index);
                    var0.accept((MethodVisitor)initArgs);
                }
                LocalVariableNode var1 = new LocalVariableNode(variable.name, variable.desc, variable.signature, labelAfter, variable.end, variable.index);
                var1.accept((MethodVisitor)body);
                continue;
            }
            throw new IllegalStateException("Local variable starts after it ends.");
        }
        body.desc = body.desc.replace(")", "[Ljava/lang/Object;)");
        return new Constructor(owner, fixed, loadThis, loadThisLine, initArgs, delegation, body, variables, localsAtLoadThis);
    }

    public static class LocalValue
    extends BasicValue {
        public LocalValue(Type type) {
            super(type);
        }

        public String toString() {
            return "*";
        }
    }
}

