/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.packaging.JarMerger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/DexRelocator;", "Lcom/android/builder/packaging/JarMerger$Relocator;", "prefix", "", "(Ljava/lang/String;)V", "classesDexNameUsed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClassesDexNameUsed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "getIndex", "()Ljava/util/concurrent/atomic/AtomicInteger;", "relocate", "entryPath", "gradle"})
final class DexRelocator
implements JarMerger.Relocator {
    @NotNull
    private final AtomicInteger index;
    @NotNull
    private final AtomicBoolean classesDexNameUsed;
    private final String prefix;

    @NotNull
    public final AtomicInteger getIndex() {
        return this.index;
    }

    @NotNull
    public final AtomicBoolean getClassesDexNameUsed() {
        return this.classesDexNameUsed;
    }

    @NotNull
    public String relocate(@NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        if (StringsKt.startsWith$default((String)entryPath, (String)"classes", (boolean)false, (int)2, null)) {
            String string;
            if (Intrinsics.areEqual((Object)entryPath, (Object)"classes.dex") && !this.classesDexNameUsed.get()) {
                this.classesDexNameUsed.set(true);
                string = this.prefix + "/classes.dex";
            } else {
                int entryIndex = this.index.getAndIncrement();
                string = this.prefix + "/classes" + entryIndex + ".dex";
            }
            return string;
        }
        return this.prefix + '/' + entryPath;
    }

    public DexRelocator(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.index = new AtomicInteger(2);
        this.classesDexNameUsed = new AtomicBoolean(false);
    }
}

