/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.internal.res.namespaced.AutoNamespaceDependenciesTask;
import com.android.build.gradle.internal.res.namespaced.NamespaceDependencyParams;
import com.android.build.gradle.internal.res.namespaced.NamespaceRewriter;
import com.android.ide.common.symbols.SymbolTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceDependencyRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/res/namespaced/NamespaceDependencyParams;", "(Lcom/android/build/gradle/internal/res/namespaced/NamespaceDependencyParams;)V", "getParams", "()Lcom/android/build/gradle/internal/res/namespaced/NamespaceDependencyParams;", "run", "", "gradle"})
final class NamespaceDependencyRunnable
implements Runnable {
    @NotNull
    private final NamespaceDependencyParams params;

    @Override
    public void run() {
        Logger logger = Logging.getLogger(AutoNamespaceDependenciesTask.class);
        Preconditions.checkNotNull((Object)this.params.getManifest(), (String)("Manifest missing for library " + this.params.getDependencyName()), (Object[])new Object[0]);
        logger.info("Started rewriting " + this.params.getDependencyName());
        ImmutableList<SymbolTable> immutableList = this.params.getSymbolTables();
        Logger logger2 = AutoNamespaceDependenciesTask.Companion.getLog$gradle();
        if (logger2 == null) {
            Logger logger3 = logger;
            logger2 = logger3;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
        }
        NamespaceRewriter rewriter = new NamespaceRewriter(immutableList, logger2);
        try {
            ImmutableCollection<File> immutableCollection = this.params.getInputClasses();
            if (immutableCollection == null) {
                Intrinsics.throwNpe();
            }
            Iterable $this$forEach$iv = (Iterable)immutableCollection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                File file = this.params.getOutputClassesDirectory();
                StringBuilder stringBuilder = new StringBuilder().append("namespaced-").append(this.params.getDependencySanitizedName()).append('-');
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                File out = new File(file, stringBuilder.append(file2.getName()).toString());
                rewriter.rewriteJar(it, out);
            }
        }
        catch (Exception e) {
            throw (Throwable)new IOException("Failed to transform jar + " + this.params.getTransitiveFiles(), e);
        }
        File file = this.params.getManifest();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"params.manifest!!.toPath()");
        Path path2 = this.params.getOutputManifests().toPath().resolve(this.params.getDependencySanitizedName() + "_AndroidManifest.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"params.outputManifests.t\u2026me}_AndroidManifest.xml\")");
        rewriter.rewriteManifest(path, path2);
        if (this.params.getResources() != null) {
            Path path3 = this.params.getResources().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"params.resources.toPath()");
            File file3 = this.params.getOutputResourcesDirectory();
            if (file3 == null) {
                Intrinsics.throwNpe();
            }
            Path path4 = file3.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"params.outputResourcesDirectory!!.toPath()");
            rewriter.rewriteAarResources(path3, path4);
            File file4 = this.params.getPublicTxt();
            Path path5 = this.params.getOutputResourcesDirectory().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"params.outputResourcesDirectory.toPath()");
            rewriter.generatePublicFile(file4, path5);
        }
        logger.info("Finished rewriting " + this.params.getDependencyName());
        Path path6 = new File(this.params.getOutputRClassesDirectory(), "namespaced-" + this.params.getDependencySanitizedName() + "-R.jar").toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path6, (String)"File(\n                pa\u2026r\"\n            ).toPath()");
        rewriter.writeRClass(path6);
    }

    @NotNull
    public final NamespaceDependencyParams getParams() {
        return this.params;
    }

    @Inject
    public NamespaceDependencyRunnable(@NotNull NamespaceDependencyParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }
}

