/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020\u001dJ\b\u0010(\u001a\u00020)H\u0007R6\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/tasks/CompatibleScreensManifest;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lorg/gradle/api/provider/Provider;", "", "minSdkVersion", "getMinSdkVersion", "()Lorg/gradle/api/provider/Provider;", "setMinSdkVersion$gradle", "(Lorg/gradle/api/provider/Provider;)V", "Ljava/io/File;", "outputFolder", "getOutputFolder", "()Ljava/io/File;", "setOutputFolder$gradle", "(Ljava/io/File;)V", "Lcom/android/build/gradle/internal/scope/OutputScope;", "outputScope", "getOutputScope", "()Lcom/android/build/gradle/internal/scope/OutputScope;", "", "screenSizes", "getScreenSizes", "()Ljava/util/Set;", "setScreenSizes$gradle", "(Ljava/util/Set;)V", "splits", "", "Lcom/android/build/gradle/internal/scope/ApkData;", "getSplits", "()Ljava/util/List;", "convert", "density", "densitiesToConvert", "", "Lcom/android/resources/Density;", "(Ljava/lang/String;[Lcom/android/resources/Density;)Ljava/lang/String;", "generate", "apkData", "generateAll", "", "CreationAction", "gradle"})
public class CompatibleScreensManifest
extends AndroidVariantTask {
    @NotNull
    public Set<String> screenSizes;
    @NotNull
    public File outputFolder;
    @NotNull
    private OutputScope outputScope;
    @NotNull
    public Provider<String> minSdkVersion;

    @Input
    @NotNull
    public final Set<String> getScreenSizes() {
        Set<String> set = this.screenSizes;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screenSizes");
        }
        return set;
    }

    public final void setScreenSizes$gradle(@NotNull Set<String> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.screenSizes = set;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputFolder() {
        File file = this.outputFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFolder");
        }
        return file;
    }

    public final void setOutputFolder$gradle(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputFolder = file;
    }

    @NotNull
    public final OutputScope getOutputScope() {
        OutputScope outputScope = this.outputScope;
        if (outputScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputScope");
        }
        return outputScope;
    }

    @Input
    @NotNull
    public final List<ApkData> getSplits() {
        OutputScope outputScope = this.outputScope;
        if (outputScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputScope");
        }
        List<ApkData> list = outputScope.getApkDatas();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"outputScope.apkDatas");
        return list;
    }

    @Input
    @Optional
    @NotNull
    public final Provider<String> getMinSdkVersion() {
        Provider<String> provider = this.minSdkVersion;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSdkVersion");
        }
        return provider;
    }

    public final void setMinSdkVersion$gradle(@NotNull Provider<String> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.minSdkVersion = provider;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateAll() throws IOException {
        void $this$mapNotNullTo$iv$iv;
        OutputScope outputScope = this.outputScope;
        if (outputScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputScope");
        }
        List<ApkData> list = outputScope.getApkDatas();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"outputScope.apkDatas");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BuildOutput buildOutput;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ApkData apkInfo = (ApkData)element$iv$iv;
            boolean bl2 = false;
            ApkData apkData = apkInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)apkData, (String)"apkInfo");
            File generatedManifest = this.generate(apkData);
            if ((generatedManifest != null ? new BuildOutput(InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST, apkInfo, generatedManifest) : null) == null) continue;
            buildOutput = buildOutput;
            boolean bl3 = false;
            boolean bl4 = false;
            BuildOutput it$iv$iv = buildOutput;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection collection = CollectionsKt.toList((Iterable)list2);
        BuildElements buildElements = new BuildElements(collection);
        File file = this.outputFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFolder");
        }
        buildElements.save(file);
    }

    @Nullable
    public final File generate(@NotNull ApkData apkData) {
        Intrinsics.checkParameterIsNotNull((Object)apkData, (String)"apkData");
        FilterData filterData = apkData.getFilter(VariantOutput.FilterType.DENSITY);
        if (filterData == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)filterData, (String)"apkData.getFilter(Varian\u2026           ?: return null");
        FilterData densityFilter = filterData;
        StringBuilder content2 = new StringBuilder();
        content2.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("    package=\"${packageName}\">\n").append("\n");
        Provider<String> provider = this.minSdkVersion;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSdkVersion");
        }
        if (provider.isPresent()) {
            StringBuilder stringBuilder = content2.append("    <uses-sdk android:minSdkVersion=\"");
            Provider<String> provider2 = this.minSdkVersion;
            if (provider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"minSdkVersion");
            }
            stringBuilder.append((String)provider2.get()).append("\"/>\n");
        }
        content2.append("    <compatible-screens>\n");
        String string = densityFilter.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"densityFilter.identifier");
        String density = this.convert(string, Density.XXHIGH, Density.XXXHIGH);
        Set<String> set = this.screenSizes;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screenSizes");
        }
        for (String size : set) {
            content2.append("        <screen android:screenSize=\"").append(size).append("\" android:screenDensity=\"").append(density).append("\" />\n");
        }
        content2.append("    </compatible-screens>\n</manifest>");
        File file = this.outputFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFolder");
        }
        File splitFolder = new File(file, apkData.getDirName());
        FileUtils.mkdirs((File)splitFolder);
        File manifestFile = new File(splitFolder, "AndroidManifest.xml");
        try {
            Files.asCharSink((File)manifestFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2.toString());
        }
        catch (IOException e) {
            throw (Throwable)new BuildException(e.getMessage(), (Throwable)e);
        }
        return manifestFile;
    }

    private final String convert(String density, Density ... densitiesToConvert) {
        for (Density densityToConvert : densitiesToConvert) {
            if (!Intrinsics.areEqual((Object)densityToConvert.getResourceValue(), (Object)density)) continue;
            String string = Integer.toString(densityToConvert.getDpiValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(densityToConvert.dpiValue)");
            return string;
        }
        return density;
    }

    public static final /* synthetic */ OutputScope access$getOutputScope$p(CompatibleScreensManifest $this) {
        OutputScope outputScope = $this.outputScope;
        if (outputScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputScope");
        }
        return outputScope;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/tasks/CompatibleScreensManifest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/CompatibleScreensManifest;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "screenSizes", "", "", "(Lcom/android/build/gradle/internal/scope/VariantScope;Ljava/util/Set;)V", "name", "getName", "()Ljava/lang/String;", "outputFolder", "Ljava/io/File;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CompatibleScreensManifest> {
        private File outputFolder;
        private final Set<String> screenSizes;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("create", "CompatibleScreenManifests");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026mpatibleScreenManifests\")");
            return string;
        }

        @Override
        @NotNull
        public Class<CompatibleScreensManifest> getType() {
            return CompatibleScreensManifest.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputFolder = BuildArtifactsHolder.appendArtifact$default(this.getVariantScope().getArtifacts(), (ArtifactType)InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull CompatibleScreensManifest task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            OutputScope outputScope = this.getVariantScope().getOutputScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)outputScope, (String)"variantScope.outputScope");
            task.outputScope = outputScope;
            task.setScreenSizes$gradle(this.screenSizes);
            File file = this.outputFolder;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputFolder");
            }
            task.setOutputFolder$gradle(file);
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            GradleVariantConfiguration config2 = gradleVariantConfiguration;
            Provider provider = TaskInputHelper.memoizeToProvider(task.getProject(), new Supplier<T>(config2){
                final /* synthetic */ GradleVariantConfiguration $config;

                @Nullable
                public final String get() {
                    ApiVersion minSdk;
                    ProductFlavor productFlavor = this.$config.getMergedFlavor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"config.mergedFlavor");
                    ApiVersion apiVersion = minSdk = productFlavor.getMinSdkVersion();
                    return apiVersion != null ? apiVersion.getApiString() : null;
                }
                {
                    this.$config = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(provider, (String)"TaskInputHelper.memoizeT\u2026?.apiString\n            }");
            task.setMinSdkVersion$gradle(provider);
        }

        public CreationAction(@NotNull VariantScope variantScope, @NotNull Set<String> screenSizes) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull(screenSizes, (String)"screenSizes");
            super(variantScope);
            this.screenSizes = screenSizes;
        }
    }
}

