/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.Supplier;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateTestConfig
extends AndroidVariantTask {
    BuildableArtifact resourcesDirectory;
    BuildableArtifact assets;
    Path sdkHome;
    File generatedJavaResourcesDirectory;
    ApkData mainApkInfo;
    Provider<Directory> manifests;
    BuildableArtifact compiledResourcesZip;
    Supplier<String> packageForR;

    @Input
    public ApkData getMainApkInfo() {
        return this.mainApkInfo;
    }

    @InputFiles
    public Provider<Directory> getManifests() {
        return this.manifests;
    }

    @TaskAction
    public void generateTestConfig() throws IOException {
        Preconditions.checkNotNull((Object)this.assets);
        Preconditions.checkNotNull((Object)this.sdkHome);
        BuildOutput output2 = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.manifests).element(this.mainApkInfo);
        GenerateTestConfig.generateTestConfigForOutput(((File)Iterables.getOnlyElement((Iterable)this.assets)).toPath().toAbsolutePath(), this.resourcesDirectory == null ? null : BuildableArtifactUtil.singleFile(this.resourcesDirectory).toPath().toAbsolutePath(), this.sdkHome, this.getPackageForR(), ((BuildOutput)Preconditions.checkNotNull((Object)output2, (Object)"Unable to find manifest output")).getOutputFile().toPath(), this.compiledResourcesZip, this.generatedJavaResourcesDirectory.toPath().toAbsolutePath());
    }

    @VisibleForTesting
    static void generateTestConfigForOutput(Path assetsDir, Path resDir, Path sdkHome, String packageForR, Path manifest, BuildableArtifact compiledResourcesZip, Path outputDir) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("android_sdk_home", sdkHome.toAbsolutePath().toString());
        if (resDir != null) {
            properties.setProperty("android_merged_resources", resDir.toAbsolutePath().toString());
        }
        properties.setProperty("android_merged_manifest", manifest.toAbsolutePath().toString());
        properties.setProperty("android_merged_assets", assetsDir.toAbsolutePath().toString());
        if (compiledResourcesZip != null) {
            properties.setProperty("android_resource_apk", GenerateTestConfig.apkFrom(compiledResourcesZip).getPath());
        }
        properties.setProperty("android_custom_package", packageForR);
        Path output2 = outputDir.resolve("com").resolve("android").resolve("tools").resolve("test_config.properties");
        Files.createDirectories(output2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output2, new OpenOption[0]);){
            properties.store(writer, "# Generated by the Android Gradle Plugin");
        }
    }

    @Input
    @Optional
    public String getResourcesDirectory() {
        if (this.resourcesDirectory == null) {
            return null;
        }
        return BuildableArtifactUtil.singleFile(this.resourcesDirectory).getPath();
    }

    @Input
    public String getAssets() {
        return ((File)Iterables.getOnlyElement((Iterable)this.assets)).getPath();
    }

    @Input
    public String getSdkHome() {
        return this.sdkHome.toString();
    }

    @Optional
    @Input
    public String getCompiledResourcesZip() {
        if (this.compiledResourcesZip == null) {
            return null;
        }
        return GenerateTestConfig.apkFrom(this.compiledResourcesZip).getPath();
    }

    private static File apkFrom(BuildableArtifact compiledResourcesZip) {
        return (File)Iterables.getOnlyElement((Iterable)compiledResourcesZip.getFiles());
    }

    @OutputDirectory
    public File getOutputFile() {
        return this.generatedJavaResourcesDirectory;
    }

    @Input
    public String getPackageForR() {
        return this.packageForR.get();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<GenerateTestConfig> {
        private final VariantScope testedScope;
        private File generatedJavaResourcesDirectory;

        public CreationAction(VariantScope scope) {
            super(scope);
            this.testedScope = ((BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData(), (Object)"Not a unit test variant.")).getScope();
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("generate", "Config");
        }

        @Override
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.generatedJavaResourcesDirectory = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY, taskName, "out");
        }

        @Override
        public void configure(GenerateTestConfig task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.manifests = this.testedScope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
            boolean enableBinaryResources = scope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
            if (enableBinaryResources) {
                task.compiledResourcesZip = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_FOR_LOCAL_TEST);
                task.dependsOn(new Object[]{task.compiledResourcesZip});
            } else {
                task.resourcesDirectory = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_RES);
                task.dependsOn(new Object[]{task.resourcesDirectory});
            }
            task.assets = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            task.dependsOn(new Object[]{task.assets});
            task.mainApkInfo = this.testedScope.getOutputScope().getMainSplit();
            task.sdkHome = Paths.get(scope.getGlobalScope().getAndroidBuilder().getTarget().getLocation(), new String[0]);
            task.generatedJavaResourcesDirectory = this.generatedJavaResourcesDirectory;
            task.packageForR = this.testedScope.getVariantConfiguration()::getOriginalApplicationId;
        }
    }
}

