/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.api.transform.Transform;
import com.android.build.api.variant.VariantFilter;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.SourceSetSourceProviderWrapper;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AdbOptions;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuild;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.SourceProvider;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.repository.Revision;
import com.android.resources.Density;
import com.android.sdklib.BuildToolInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;

public abstract class BaseExtension
implements AndroidConfig {
    private final List<List<Object>> transformDependencies = Lists.newArrayList();
    protected final GlobalScope globalScope;
    private final SdkHandler sdkHandler;
    private final DefaultConfig defaultConfig;
    private final AaptOptions aaptOptions;
    private final LintOptions lintOptions;
    private final ExternalNativeBuild externalNativeBuild;
    private final DexOptions dexOptions;
    private final TestOptions testOptions;
    private final CompileOptions compileOptions;
    private final PackagingOptions packagingOptions;
    private final JacocoOptions jacoco;
    private final Splits splits;
    private final AdbOptions adbOptions;
    private final NamedDomainObjectContainer<ProductFlavor> productFlavors;
    private final NamedDomainObjectContainer<BuildType> buildTypes;
    private final NamedDomainObjectContainer<SigningConfig> signingConfigs;
    private final NamedDomainObjectContainer<BaseVariantOutput> buildOutputs;
    private final List<DeviceProvider> deviceProviderList = Lists.newArrayList();
    private final List<TestServer> testServerList = Lists.newArrayList();
    private final List<Transform> transforms = Lists.newArrayList();
    private final DataBindingOptions dataBinding;
    private final SourceSetManager sourceSetManager;
    private String target;
    private Revision buildToolsRevision;
    private List<LibraryRequest> libraryRequests = Lists.newArrayList();
    private List<String> flavorDimensionList;
    private String resourcePrefix;
    private ExtraModelInfo extraModelInfo;
    private String defaultPublishConfig = "release";
    private Action<VariantFilter> variantFilter;
    protected Logger logger;
    private boolean isWritable = true;
    protected Project project;
    private final ProjectOptions projectOptions;
    private final boolean isBaseModule;
    private String ndkVersion;
    boolean generatePureSplits = false;

    BaseExtension(Project project, ProjectOptions projectOptions, GlobalScope globalScope, SdkHandler sdkHandler, NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs, NamedDomainObjectContainer<BaseVariantOutput> buildOutputs, SourceSetManager sourceSetManager, ExtraModelInfo extraModelInfo, boolean isBaseModule) {
        this.globalScope = globalScope;
        this.sdkHandler = sdkHandler;
        this.buildTypes = buildTypes;
        this.productFlavors = productFlavors;
        this.signingConfigs = signingConfigs;
        this.extraModelInfo = extraModelInfo;
        this.buildOutputs = buildOutputs;
        this.project = project;
        this.projectOptions = projectOptions;
        this.sourceSetManager = sourceSetManager;
        this.isBaseModule = isBaseModule;
        this.logger = Logging.getLogger(this.getClass());
        ObjectFactory objectFactory = project.getObjects();
        this.defaultConfig = (DefaultConfig)objectFactory.newInstance(DefaultConfig.class, new Object[]{"main", project, objectFactory, extraModelInfo.getDeprecationReporter(), project.getLogger()});
        this.aaptOptions = (AaptOptions)objectFactory.newInstance(AaptOptions.class, new Object[]{projectOptions.get(BooleanOption.ENABLE_RESOURCE_NAMESPACING_DEFAULT)});
        this.dexOptions = (DexOptions)((Object)objectFactory.newInstance(DexOptions.class, new Object[]{extraModelInfo.getDeprecationReporter()}));
        this.lintOptions = (LintOptions)objectFactory.newInstance(LintOptions.class, new Object[0]);
        this.externalNativeBuild = (ExternalNativeBuild)objectFactory.newInstance(ExternalNativeBuild.class, new Object[]{objectFactory, project});
        this.testOptions = (TestOptions)objectFactory.newInstance(TestOptions.class, new Object[]{objectFactory});
        this.compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.packagingOptions = (PackagingOptions)objectFactory.newInstance(PackagingOptions.class, new Object[0]);
        this.jacoco = (JacocoOptions)objectFactory.newInstance(JacocoOptions.class, new Object[0]);
        this.adbOptions = (AdbOptions)objectFactory.newInstance(AdbOptions.class, new Object[0]);
        this.splits = (Splits)objectFactory.newInstance(Splits.class, new Object[]{objectFactory});
        this.dataBinding = (DataBindingOptions)objectFactory.newInstance(DataBindingOptions.class, new Object[0]);
        this.createAndroidTestUtilConfiguration();
        sourceSetManager.setUpSourceSet(this.defaultConfig.getName());
        this.buildToolsRevision = AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION;
        this.setDefaultConfigValues();
    }

    private void setDefaultConfigValues() {
        Set densities = Density.getRecommendedValuesForDevice();
        HashSet strings = Sets.newHashSetWithExpectedSize((int)densities.size());
        for (Density density : densities) {
            strings.add(density.getResourceValue());
        }
        this.defaultConfig.getVectorDrawables().setGeneratedDensities(strings);
        this.defaultConfig.getVectorDrawables().setUseSupportLibrary(false);
    }

    public void disableWrite() {
        this.isWritable = false;
    }

    protected void checkWritability() {
        if (!this.isWritable) {
            throw new GradleException("Android tasks have already been created.\nThis happens when calling android.applicationVariants,\nandroid.libraryVariants or android.testVariants.\nOnce these methods are called, it is not possible to\ncontinue configuring the model.");
        }
    }

    private void createAndroidTestUtilConfiguration() {
        String name = "androidTestUtil";
        this.logger.info("Creating configuration {}", (Object)name);
        Configuration configuration = (Configuration)this.project.getConfigurations().maybeCreate(name);
        configuration.setVisible(false);
        configuration.setDescription("Additional APKs used during instrumentation testing.");
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(true);
    }

    public void compileSdkVersion(String version) {
        this.checkWritability();
        this.target = version;
    }

    public void compileSdkVersion(int apiLevel) {
        this.compileSdkVersion("android-" + apiLevel);
    }

    public void setCompileSdkVersion(int apiLevel) {
        this.compileSdkVersion(apiLevel);
    }

    public void setCompileSdkVersion(String target) {
        this.compileSdkVersion(target);
    }

    public void useLibrary(String name) {
        this.useLibrary(name, true);
    }

    public void useLibrary(String name, boolean required) {
        this.libraryRequests.add(new LibraryRequest(name, required));
    }

    public void buildToolsVersion(String version) {
        this.checkWritability();
        this.buildToolsRevision = Revision.parseRevision((String)version, (Revision.Precision)Revision.Precision.MICRO);
    }

    @Override
    public String getNdkVersion() {
        return this.ndkVersion;
    }

    public void setNdkVersion(String version) {
        this.ndkVersion = version;
    }

    @Override
    public String getBuildToolsVersion() {
        return this.buildToolsRevision.toString();
    }

    public void setBuildToolsVersion(String version) {
        this.buildToolsVersion(version);
    }

    public void buildTypes(Action<? super NamedDomainObjectContainer<BuildType>> action) {
        this.checkWritability();
        action.execute(this.buildTypes);
    }

    public void productFlavors(Action<? super NamedDomainObjectContainer<ProductFlavor>> action) {
        this.checkWritability();
        action.execute(this.productFlavors);
    }

    public void signingConfigs(Action<? super NamedDomainObjectContainer<SigningConfig>> action) {
        this.checkWritability();
        action.execute(this.signingConfigs);
    }

    public void flavorDimensions(String ... dimensions) {
        this.checkWritability();
        this.flavorDimensionList = Arrays.asList(dimensions);
    }

    public void sourceSets(Action<NamedDomainObjectContainer<AndroidSourceSet>> action) {
        this.checkWritability();
        this.sourceSetManager.executeAction(action);
    }

    @Override
    public NamedDomainObjectContainer<AndroidSourceSet> getSourceSets() {
        return this.sourceSetManager.getSourceSetsContainer();
    }

    public NamedDomainObjectContainer<BaseVariantOutput> getBuildOutputs() {
        return this.buildOutputs;
    }

    public void defaultConfig(Action<DefaultConfig> action) {
        this.checkWritability();
        action.execute((Object)this.defaultConfig);
    }

    public void aaptOptions(Action<AaptOptions> action) {
        this.checkWritability();
        action.execute((Object)this.aaptOptions);
    }

    public void dexOptions(Action<DexOptions> action) {
        this.checkWritability();
        action.execute((Object)this.dexOptions);
    }

    public void lintOptions(Action<LintOptions> action) {
        this.checkWritability();
        action.execute((Object)this.lintOptions);
    }

    public void externalNativeBuild(Action<ExternalNativeBuild> action) {
        this.checkWritability();
        action.execute((Object)this.externalNativeBuild);
    }

    public void testOptions(Action<TestOptions> action) {
        this.checkWritability();
        action.execute((Object)this.testOptions);
    }

    public void compileOptions(Action<CompileOptions> action) {
        this.checkWritability();
        action.execute((Object)this.compileOptions);
    }

    public void packagingOptions(Action<PackagingOptions> action) {
        this.checkWritability();
        action.execute((Object)this.packagingOptions);
    }

    @Deprecated
    public void jacoco(Action<JacocoOptions> action) {
        this.checkWritability();
        action.execute((Object)this.jacoco);
    }

    public void adbOptions(Action<AdbOptions> action) {
        this.checkWritability();
        action.execute((Object)this.adbOptions);
    }

    public void splits(Action<Splits> action) {
        this.checkWritability();
        action.execute((Object)this.splits);
    }

    public void dataBinding(Action<DataBindingOptions> action) {
        this.checkWritability();
        action.execute((Object)this.dataBinding);
    }

    @Override
    public DataBindingOptions getDataBinding() {
        return this.dataBinding;
    }

    public void deviceProvider(DeviceProvider deviceProvider) {
        this.checkWritability();
        this.deviceProviderList.add(deviceProvider);
    }

    @Override
    public List<DeviceProvider> getDeviceProviders() {
        return this.deviceProviderList;
    }

    public void testServer(TestServer testServer) {
        this.checkWritability();
        this.testServerList.add(testServer);
    }

    @Override
    public List<TestServer> getTestServers() {
        return this.testServerList;
    }

    public void registerTransform(Transform transform2, Object ... dependencies) {
        this.transforms.add(transform2);
        this.transformDependencies.add(Arrays.asList(dependencies));
    }

    @Override
    public List<Transform> getTransforms() {
        return ImmutableList.copyOf(this.transforms);
    }

    @Override
    public List<List<Object>> getTransformsDependencies() {
        return ImmutableList.copyOf(this.transformDependencies);
    }

    public NamedDomainObjectContainer<ProductFlavor> getProductFlavors() {
        return this.productFlavors;
    }

    public NamedDomainObjectContainer<BuildType> getBuildTypes() {
        return this.buildTypes;
    }

    public NamedDomainObjectContainer<SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void defaultPublishConfig(String value) {
        this.setDefaultPublishConfig(value);
    }

    @Override
    public String getDefaultPublishConfig() {
        return this.defaultPublishConfig;
    }

    public void setDefaultPublishConfig(String value) {
        this.defaultPublishConfig = value;
    }

    public void setPublishNonDefault(boolean publishNonDefault) {
        this.logger.warn("publishNonDefault is deprecated and has no effect anymore. All variants are now published.");
    }

    public void variantFilter(Action<VariantFilter> filter) {
        this.setVariantFilter(filter);
    }

    public void setVariantFilter(Action<VariantFilter> filter) {
        this.variantFilter = filter;
    }

    @Override
    public Action<VariantFilter> getVariantFilter() {
        return this.variantFilter;
    }

    @Override
    public AdbOptions getAdbOptions() {
        return this.adbOptions;
    }

    @Override
    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    @Override
    public List<String> getFlavorDimensionList() {
        return this.flavorDimensionList;
    }

    @Override
    @Incubating
    public boolean getGeneratePureSplits() {
        return this.generatePureSplits;
    }

    public void resourcePrefix(String prefix) {
        this.resourcePrefix = prefix;
    }

    public abstract void addVariant(BaseVariant var1);

    public void registerArtifactType(String name, boolean isTest, int artifactType) {
        this.extraModelInfo.registerArtifactType(name, isTest, artifactType);
    }

    public void registerBuildTypeSourceProvider(String name, BuildType buildType, SourceProvider sourceProvider) {
        this.extraModelInfo.registerBuildTypeSourceProvider(name, buildType, sourceProvider);
    }

    public void registerProductFlavorSourceProvider(String name, ProductFlavor productFlavor, SourceProvider sourceProvider) {
        this.extraModelInfo.registerProductFlavorSourceProvider(name, productFlavor, sourceProvider);
    }

    public void registerJavaArtifact(String name, BaseVariant variant, String assembleTaskName, String javaCompileTaskName, Collection<File> generatedSourceFolders, Iterable<String> ideSetupTaskNames, Configuration configuration, File classesFolder, File javaResourceFolder, SourceProvider sourceProvider) {
        this.extraModelInfo.registerJavaArtifact(name, variant, assembleTaskName, javaCompileTaskName, generatedSourceFolders, ideSetupTaskNames, configuration, classesFolder, javaResourceFolder, sourceProvider);
    }

    public void registerMultiFlavorSourceProvider(String name, String flavorName, SourceProvider sourceProvider) {
        this.extraModelInfo.registerMultiFlavorSourceProvider(name, flavorName, sourceProvider);
    }

    public static SourceProvider wrapJavaSourceSet(SourceSet sourceSet) {
        return new SourceSetSourceProviderWrapper(sourceSet);
    }

    @Override
    public String getCompileSdkVersion() {
        return this.target;
    }

    @Override
    @Internal
    public Revision getBuildToolsRevision() {
        return this.buildToolsRevision;
    }

    @Override
    public Collection<LibraryRequest> getLibraryRequests() {
        return this.libraryRequests;
    }

    public File getSdkDirectory() {
        return this.sdkHandler.getSdkFolder();
    }

    public File getNdkDirectory() {
        return this.sdkHandler.getNdkFolder();
    }

    @Override
    public List<File> getBootClasspath() {
        if (!this.ensureTargetSetup()) {
            return ImmutableList.of();
        }
        boolean usingJava8 = this.compileOptions.getTargetCompatibility().isJava8Compatible();
        ArrayList bootClasspath = Lists.newArrayListWithExpectedSize((int)(usingJava8 ? 2 : 1));
        bootClasspath.addAll(this.globalScope.getAndroidBuilder().computeFilteredBootClasspath(this.globalScope.getExtension().getLibraryRequests()));
        if (usingJava8) {
            bootClasspath.add(new File(this.globalScope.getAndroidBuilder().getBuildToolInfo().getPath(BuildToolInfo.PathId.CORE_LAMBDA_STUBS)));
        }
        return bootClasspath;
    }

    public File getAdbExecutable() {
        return this.sdkHandler.getSdkInfo().getAdb();
    }

    @Deprecated
    public File getAdbExe() {
        return this.getAdbExecutable();
    }

    public File getDefaultProguardFile(String name) {
        if (!ProguardFiles.KNOWN_FILE_NAMES.contains(name)) {
            this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(ProguardFiles.UNKNOWN_FILENAME_MESSAGE));
        }
        return ProguardFiles.getDefaultProguardFile(name, this.project);
    }

    public void generatePureSplits(boolean flag) {
        this.setGeneratePureSplits(flag);
    }

    public void setGeneratePureSplits(boolean flag) {
        this.generatePureSplits = flag;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    @Override
    public CompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    @Override
    public DexOptions getDexOptions() {
        return this.dexOptions;
    }

    @Override
    public JacocoOptions getJacoco() {
        return this.jacoco;
    }

    @Override
    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    @Override
    public ExternalNativeBuild getExternalNativeBuild() {
        return this.externalNativeBuild;
    }

    @Override
    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    @Override
    public Splits getSplits() {
        return this.splits;
    }

    @Override
    public TestOptions getTestOptions() {
        return this.testOptions;
    }

    private boolean ensureTargetSetup() {
        TargetInfo targetInfo = this.globalScope.getAndroidBuilder().getTargetInfo();
        if (targetInfo == null) {
            return this.sdkHandler.initTarget(this.getCompileSdkVersion(), this.buildToolsRevision, this.globalScope.getErrorHandler(), this.globalScope.getAndroidBuilder());
        }
        return true;
    }

    @Override
    public Boolean getPackageBuildConfig() {
        throw new GradleException("packageBuildConfig is not supported.");
    }

    @Override
    public Collection<String> getAidlPackageWhiteList() {
        throw new GradleException("aidlPackageWhiteList is not supported.");
    }

    @Override
    public Boolean getBaseFeature() {
        return this.isBaseModule;
    }
}

