/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.ProguardFilesProvider;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.utils.HelpfulEnumConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;

@Incubating
public class PostProcessingBlock
implements ProguardFilesProvider {
    private static final String AUTO = "auto";
    private static final HelpfulEnumConverter<CodeShrinker> SHRINKER_CONVERTER = new HelpfulEnumConverter(CodeShrinker.class);
    private final Project project;
    private boolean removeUnusedCode = true;
    private boolean removeUnusedResources;
    private boolean obfuscate;
    private boolean optimizeCode;
    private List<File> proguardFiles;
    private List<File> testProguardFiles;
    private List<File> consumerProguardFiles;
    private CodeShrinker codeShrinker;

    @Inject
    public PostProcessingBlock(Project project) {
        this(project, (List<File>)ImmutableList.of((Object)ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.NO_ACTIONS.fileName, project)));
    }

    @VisibleForTesting
    PostProcessingBlock(Project project, List<File> proguardFiles) {
        this.project = project;
        this.proguardFiles = Lists.newArrayList(proguardFiles);
        this.testProguardFiles = new ArrayList<File>();
        this.consumerProguardFiles = new ArrayList<File>();
    }

    public void initWith(PostProcessingBlock that) {
        this.removeUnusedCode = that.isRemoveUnusedCode();
        this.removeUnusedResources = that.isRemoveUnusedResources();
        this.obfuscate = that.isObfuscate();
        this.optimizeCode = that.isOptimizeCode();
        this.proguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.EXPLICIT));
        this.testProguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.TEST));
        this.consumerProguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.CONSUMER));
        this.codeShrinker = that.getCodeShrinkerEnum();
    }

    public boolean isRemoveUnusedCode() {
        return this.removeUnusedCode;
    }

    public void setRemoveUnusedCode(boolean removeUnusedCode) {
        this.removeUnusedCode = removeUnusedCode;
    }

    public boolean isRemoveUnusedResources() {
        return this.removeUnusedResources;
    }

    public void setRemoveUnusedResources(boolean removeUnusedResources) {
        this.removeUnusedResources = removeUnusedResources;
    }

    public boolean isObfuscate() {
        return this.obfuscate;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean isOptimizeCode() {
        return this.optimizeCode;
    }

    public void setOptimizeCode(boolean optimizeCode) {
        this.optimizeCode = optimizeCode;
    }

    public void setProguardFiles(List<Object> proguardFiles) {
        this.proguardFiles = new ArrayList<File>();
        for (Object file : proguardFiles) {
            this.proguardFiles.add(this.project.file(file));
        }
    }

    public void proguardFile(Object file) {
        this.proguardFiles.add(this.project.file(file));
    }

    public void proguardFiles(Object ... files2) {
        for (Object file : files2) {
            this.proguardFile(file);
        }
    }

    public void setTestProguardFiles(List<Object> testProguardFiles) {
        this.testProguardFiles = new ArrayList<File>();
        for (Object file : testProguardFiles) {
            this.testProguardFiles.add(this.project.file(file));
        }
    }

    public void testProguardFile(Object file) {
        this.testProguardFiles.add(this.project.file(file));
    }

    public void testProguardFiles(Object ... files2) {
        for (Object file : files2) {
            this.testProguardFile(file);
        }
    }

    public void setConsumerProguardFiles(List<Object> consumerProguardFiles) {
        this.consumerProguardFiles = new ArrayList<File>();
        for (Object file : consumerProguardFiles) {
            this.consumerProguardFiles.add(this.project.file(file));
        }
    }

    public void consumerProguardFile(Object file) {
        this.consumerProguardFiles.add(this.project.file(file));
    }

    public void consumerProguardFiles(Object ... files2) {
        for (Object file : files2) {
            this.consumerProguardFile(file);
        }
    }

    public String getCodeShrinker() {
        if (this.codeShrinker == null) {
            return AUTO;
        }
        return (String)Verify.verifyNotNull((Object)SHRINKER_CONVERTER.reverse().convert((Object)this.codeShrinker));
    }

    public void setCodeShrinker(String name) {
        this.codeShrinker = name.equals(AUTO) ? null : (CodeShrinker)((Object)SHRINKER_CONVERTER.convert((Object)name));
    }

    public CodeShrinker getCodeShrinkerEnum() {
        return this.codeShrinker;
    }

    @Override
    public Collection<File> getProguardFiles(ProguardFileType type) {
        switch (type) {
            case EXPLICIT: {
                return this.proguardFiles;
            }
            case TEST: {
                return this.testProguardFiles;
            }
            case CONSUMER: {
                return this.consumerProguardFiles;
            }
        }
        throw new AssertionError((Object)("Invalid ProguardFileType: " + (Object)((Object)type)));
    }
}

