/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.WorkLimiter;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import proguard.ClassPath;
import proguard.ParseException;

public class ProGuardTransform
extends BaseProguardAction {
    private static final int PROGUARD_CONCURRENCY_LIMIT = 4;
    @GuardedBy(value="ProGuardTransform.class")
    private static WorkLimiter proguardWorkLimiter;
    private static final Logger LOG;
    private final VariantScope variantScope;
    private final File proguardOut;
    private final File printMapping;
    private final File printSeeds;
    private final File printUsage;
    private final ImmutableList<File> secondaryFileOutputs;
    private File testedMappingFile = null;
    private FileCollection testMappingConfiguration = null;

    public ProGuardTransform(VariantScope variantScope) {
        super(variantScope);
        this.variantScope = variantScope;
        this.printMapping = variantScope.getOutputProguardMappingFile();
        this.proguardOut = this.printMapping.getParentFile();
        this.printSeeds = new File(this.proguardOut, "seeds.txt");
        this.printUsage = new File(this.proguardOut, "usage.txt");
        this.secondaryFileOutputs = ImmutableList.of((Object)this.printMapping, (Object)this.printSeeds, (Object)this.printUsage);
    }

    private static synchronized WorkLimiter getWorkLimiter() {
        if (proguardWorkLimiter == null) {
            proguardWorkLimiter = new WorkLimiter(4);
        }
        return proguardWorkLimiter;
    }

    public File getMappingFile() {
        return this.printMapping;
    }

    public void applyTestedMapping(File testedMappingFile) {
        this.testedMappingFile = testedMappingFile;
    }

    public void applyTestedMapping(FileCollection testMappingConfiguration) {
        this.testMappingConfiguration = testMappingConfiguration;
    }

    public String getName() {
        return "proguard";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ArrayList files2 = Lists.newArrayList();
        if (this.testedMappingFile != null && this.testedMappingFile.isFile()) {
            files2.add(SecondaryFile.nonIncremental((File)this.testedMappingFile));
        } else if (this.testMappingConfiguration != null) {
            files2.add(SecondaryFile.nonIncremental((FileCollection)this.testMappingConfiguration));
        }
        files2.add(SecondaryFile.nonIncremental((FileCollection)this.getAllConfigurationFiles()));
        return files2;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return this.secondaryFileOutputs;
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"shrink", (Object)this.configuration.shrink, (Object)"obfuscate", (Object)this.configuration.obfuscate, (Object)"optimize", (Object)this.configuration.optimize);
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws TransformException {
        try {
            ProGuardTransform.getWorkLimiter().limit(() -> {
                this.doMinification(invocation.getInputs(), invocation.getReferencedInputs(), invocation.getOutputProvider());
                if (!this.printMapping.isFile()) {
                    Files.asCharSink((File)this.printMapping, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
                }
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void applyRuleFile(String jarName, String ruleFileName, String rules) {
        try {
            this.applyConfigurationText(rules, jarName + File.separator + ruleFileName);
        }
        catch (IOException | ParseException ex) {
            throw new UncheckedIOException("Failed to apply proguard rules for '" + ruleFileName + "' in '" + jarName, ex);
        }
    }

    private void doMinification(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output2) throws IOException {
        try {
            Preconditions.checkNotNull((Object)output2, (Object)("Missing output object for transform " + this.getName()));
            Set outputTypes = this.getOutputTypes();
            Set<? super QualifiedContent.Scope> scopes = this.getScopes();
            File outFile = output2.getContentLocation("combined_res_and_classes", outputTypes, scopes, Format.JAR);
            FileUtils.mkdirs((File)outFile.getParentFile());
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            File testedMappingFile = this.computeMappingFile();
            if (testedMappingFile != null) {
                this.applyMapping(testedMappingFile);
            }
            this.addInputsToConfiguration(inputs, false);
            this.addInputsToConfiguration(referencedInputs, true);
            this.variantScope.getBootClasspath().forEach(this::libraryJar);
            globalScope.getAndroidBuilder().computeFullBootClasspath().forEach(this::libraryJar);
            this.outJar(outFile);
            FileUtils.cleanOutputDir((File)this.proguardOut);
            for (File configFile : this.getAllConfigurationFiles()) {
                LOG.info("Applying ProGuard configuration file {}", (Object)configFile);
                this.applyConfigurationFile(configFile);
            }
            this.configuration.printMapping = this.printMapping;
            this.configuration.printSeeds = this.printSeeds;
            this.configuration.printUsage = this.printUsage;
            this.forceprocessing();
            this.runProguard();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private void addInputsToConfiguration(Collection<TransformInput> inputs, boolean referencedOnly) {
        List baseFilter;
        ClassPath classPath;
        if (referencedOnly) {
            classPath = this.configuration.libraryJars;
            baseFilter = JAR_FILTER;
        } else {
            classPath = this.configuration.programJars;
            baseFilter = null;
        }
        for (TransformInput transformInput : inputs) {
            for (JarInput jarInput : transformInput.getJarInputs()) {
                this.handleQualifiedContent(classPath, (QualifiedContent)jarInput, baseFilter);
            }
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                this.handleQualifiedContent(classPath, (QualifiedContent)directoryInput, baseFilter);
            }
        }
    }

    private void handleQualifiedContent(ClassPath classPath, QualifiedContent content2, List<String> baseFilter) {
        ImmutableList filter = baseFilter;
        if (!content2.getContentTypes().contains(QualifiedContent.DefaultContentType.CLASSES)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (filter != null) {
                builder.addAll(filter);
            }
            builder.add((Object)"!**.class");
            filter = builder.build();
        } else if (!content2.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES)) {
            filter = ImmutableList.of((Object)"**.class");
        }
        this.inputJar(classPath, content2.getFile(), (List<String>)filter);
    }

    private File computeMappingFile() {
        if (this.testedMappingFile != null && this.testedMappingFile.isFile()) {
            return this.testedMappingFile;
        }
        if (this.testMappingConfiguration != null && this.testMappingConfiguration.getSingleFile().isFile()) {
            return this.testMappingConfiguration.getSingleFile();
        }
        return null;
    }

    static {
        LOG = Logging.getLogger(ProGuardTransform.class);
    }
}

