/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProfileRecordWriter;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTaskExecution;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;

public class RecordingBuildListener
implements TaskExecutionListener {
    private final ProfileRecordWriter recordWriter;
    private final Map<String, TaskProfilingRecord> taskRecords = new ConcurrentHashMap<String, TaskProfilingRecord>();

    RecordingBuildListener(ProfileRecordWriter recorder) {
        this.recordWriter = recorder;
    }

    public void beforeExecute(Task task) {
        GradleBuildProfileSpan.Builder builder = GradleBuildProfileSpan.newBuilder();
        builder.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        builder.setId(this.recordWriter.allocateRecordId());
        builder.setThreadId(Thread.currentThread().getId());
        TaskProfilingRecord taskRecord2 = new TaskProfilingRecord(this.recordWriter, builder, task.getPath(), task.getProject().getPath(), RecordingBuildListener.getVariantName(task));
        this.taskRecords.put(task.getPath(), taskRecord2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecute(Task task, TaskState taskState) {
        try {
            TaskProfilingRecord taskRecord2 = this.taskRecords.get(task.getPath());
            GradleBuildProfileSpan.Builder record = taskRecord2.getSpanBuilder();
            record.setTask(GradleTaskExecution.newBuilder().setType(AnalyticsUtil.getTaskExecutionType(task.getClass()).getNumber()).setDidWork(taskState.getDidWork()).setSkipped(taskState.getSkipped()).setUpToDate(taskState.getUpToDate()).setFailed(taskState.getFailure() != null));
            taskRecord2.setTaskFinished();
            if (taskRecord2.allWorkersFinished()) {
                taskRecord2.writeTaskSpan();
                this.closeTaskRecord(task.getPath());
            }
        }
        finally {
            ProcessProfileWriter.recordMemorySample();
        }
    }

    public TaskProfilingRecord getTaskRecord(String taskPath) {
        return this.taskRecords.get(taskPath);
    }

    private static String getVariantName(Task task) {
        if (!(task instanceof VariantAwareTask)) {
            return null;
        }
        String variantName = ((VariantAwareTask)task).getVariantName();
        if (variantName.isEmpty()) {
            return null;
        }
        return variantName;
    }

    public void closeTaskRecord(String taskPath) {
        this.taskRecords.remove(taskPath);
    }
}

