/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0006\u0010\u0019\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "Ljava/io/Serializable;", "taskName", "", "submissionTime", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/time/Instant;)V", "endTime", "getEndTime$gradle", "()Ljava/time/Instant;", "setEndTime$gradle", "(Ljava/time/Instant;)V", "startTime", "duration", "Ljava/time/Duration;", "executionFinished", "", "executionStarted", "fillSpanRecord", "span", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "isFinished", "", "isStarted", "toString", "waitTime", "gradle"})
public final class WorkerProfilingRecord
implements Serializable {
    private Instant startTime;
    @NotNull
    private Instant endTime;
    private final String taskName;
    private final Instant submissionTime;

    @NotNull
    public final Instant getEndTime$gradle() {
        return this.endTime;
    }

    public final void setEndTime$gradle(@NotNull Instant instant) {
        Intrinsics.checkParameterIsNotNull((Object)instant, (String)"<set-?>");
        this.endTime = instant;
    }

    public final boolean isStarted() {
        return Intrinsics.areEqual((Object)this.startTime, (Object)Instant.MIN) ^ true;
    }

    public final boolean isFinished() {
        return Intrinsics.areEqual((Object)this.endTime, (Object)Instant.MIN) ^ true;
    }

    @NotNull
    public final Duration waitTime() {
        Duration duration;
        if (this.isStarted()) {
            Duration duration2 = Duration.between(this.submissionTime, this.startTime);
            duration = duration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.between(submissionTime, startTime)");
        } else {
            Duration duration3 = Duration.ZERO;
            duration = duration3;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ZERO");
        }
        return duration;
    }

    @NotNull
    public final Duration duration() {
        Duration duration;
        if (this.isFinished()) {
            Duration duration2 = Duration.between(this.startTime, this.endTime);
            duration = duration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.between(startTime, endTime)");
        } else {
            Duration duration3 = Duration.ZERO;
            duration = duration3;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ZERO");
        }
        return duration;
    }

    public final void executionStarted() {
        Instant instant = TaskProfilingRecord.Companion.getClock().instant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"TaskProfilingRecord.clock.instant()");
        this.startTime = instant;
    }

    public final void executionFinished() {
        if (!this.isStarted()) {
            throw (Throwable)new IllegalStateException("Worker finished without being first started");
        }
        Instant instant = TaskProfilingRecord.Companion.getClock().instant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"TaskProfilingRecord.clock.instant()");
        this.endTime = instant;
    }

    public final void fillSpanRecord(@NotNull GradleBuildProfileSpan.Builder span) {
        Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        span.setThreadId(thread.getId()).setStartTimeInMs(this.startTime.toEpochMilli()).setDurationInMs(this.duration().toMillis()).setType(GradleBuildProfileSpan.ExecutionType.WORKER_EXECUTION);
    }

    @NotNull
    public String toString() {
        return "Worker for " + this.taskName;
    }

    public WorkerProfilingRecord(@NotNull String taskName, @NotNull Instant submissionTime) {
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Intrinsics.checkParameterIsNotNull((Object)submissionTime, (String)"submissionTime");
        this.taskName = taskName;
        this.submissionTime = submissionTime;
        Instant instant = Instant.MIN;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.MIN");
        this.startTime = instant;
        Instant instant2 = Instant.MIN;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.MIN");
        this.endTime = instant2;
    }
}

