/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.symbols.SymbolExportUtils;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0003,-.B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0014J\n\u0010)\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010*\u001a\u00020\u0013H\u0007J\b\u0010+\u001a\u00020\u0013H\u0007R,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR$\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR \u0010!\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR \u0010#\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask;", "Lcom/android/build/gradle/tasks/ProcessAndroidResources;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lorg/gradle/api/provider/Provider;", "", "applicationId", "getApplicationId", "()Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileCollection;", "dependencies", "getDependencies", "()Lorg/gradle/api/file/FileCollection;", "Lcom/android/build/api/artifact/BuildableArtifact;", "localResourcesFile", "getLocalResourcesFile", "()Lcom/android/build/api/artifact/BuildableArtifact;", "", "namespacedRClass", "getNamespacedRClass", "()Z", "packageForR", "getPackageForR", "platformAttrRTxt", "getPlatformAttrRTxt", "Ljava/io/File;", "rClassOutputJar", "getRClassOutputJar", "()Ljava/io/File;", "sourceOutputDirectory", "getSourceOutputDirectory", "symbolsWithPackageNameOutputFile", "getSymbolsWithPackageNameOutputFile", "textSymbolOutputFile", "getTextSymbolOutputFile", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doFullTaskAction", "", "getSourceOutputDir", "outputRClassJar", "outputSources", "CreationAction", "GenerateLibRFileParams", "GenerateLibRFileRunnable", "gradle"})
public class GenerateLibraryRFileTask
extends ProcessAndroidResources {
    private final WorkerExecutorFacade workers;
    @Nullable
    private File sourceOutputDirectory;
    @Nullable
    private File rClassOutputJar;
    @NotNull
    private File textSymbolOutputFile;
    @NotNull
    private File symbolsWithPackageNameOutputFile;
    @NotNull
    private FileCollection dependencies;
    @NotNull
    private Provider<String> packageForR;
    @NotNull
    private FileCollection platformAttrRTxt;
    @NotNull
    private Provider<String> applicationId;
    @NotNull
    private BuildableArtifact localResourcesFile;
    private boolean namespacedRClass;

    @OutputDirectory
    @Optional
    @Nullable
    public final File getSourceOutputDirectory() {
        return this.sourceOutputDirectory;
    }

    @Input
    public final boolean outputSources() {
        return this.sourceOutputDirectory != null;
    }

    @OutputFile
    @Optional
    @Nullable
    public final File getRClassOutputJar() {
        return this.rClassOutputJar;
    }

    @Input
    public final boolean outputRClassJar() {
        return this.rClassOutputJar != null;
    }

    @Override
    @Nullable
    public File getSourceOutputDir() {
        File file = this.sourceOutputDirectory;
        if (file == null) {
            file = this.rClassOutputJar;
        }
        return file;
    }

    @OutputFile
    @NotNull
    public final File getTextSymbolOutputFile() {
        File file = this.textSymbolOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textSymbolOutputFile");
        }
        return file;
    }

    @OutputFile
    @NotNull
    public final File getSymbolsWithPackageNameOutputFile() {
        File file = this.symbolsWithPackageNameOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"symbolsWithPackageNameOutputFile");
        }
        return file;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getDependencies() {
        FileCollection fileCollection = this.dependencies;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return fileCollection;
    }

    @Input
    @NotNull
    public final Provider<String> getPackageForR() {
        Provider<String> provider = this.packageForR;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageForR");
        }
        return provider;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getPlatformAttrRTxt() {
        FileCollection fileCollection = this.platformAttrRTxt;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
        }
        return fileCollection;
    }

    @Input
    @NotNull
    public final Provider<String> getApplicationId() {
        Provider<String> provider = this.applicationId;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
        }
        return provider;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getLocalResourcesFile() {
        BuildableArtifact buildableArtifact = this.localResourcesFile;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localResourcesFile");
        }
        return buildableArtifact;
    }

    @Input
    public final boolean getNamespacedRClass() {
        return this.namespacedRClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFullTaskAction() throws IOException {
        ArtifactType artifactType = InternalArtifactType.MERGED_MANIFESTS;
        Provider provider = this.manifestFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"manifestFiles");
        Object object = Iterables.getOnlyElement((Iterable)ExistingBuildElements.Companion.from(artifactType, (Provider<Directory>)provider));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Iterables.getOnlyElement\u2026ANIFESTS, manifestFiles))");
        File file = ((BuildOutput)object).getOutputFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Iterables.getOnlyElement\u2026              .outputFile");
        File manifest = file;
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl = false;
            BuildableArtifact buildableArtifact = this.localResourcesFile;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localResourcesFile");
            }
            File file2 = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.platformAttrRTxt;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
            }
            File file3 = fileCollection.getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"platformAttrRTxt.singleFile");
            FileCollection fileCollection2 = this.dependencies;
            if (fileCollection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
            }
            Set set = fileCollection2.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"dependencies.files");
            Provider<String> provider2 = this.packageForR;
            if (provider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"packageForR");
            }
            Object object2 = provider2.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"packageForR.get()");
            String string = (String)object2;
            File file4 = this.textSymbolOutputFile;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textSymbolOutputFile");
            }
            File file5 = this.symbolsWithPackageNameOutputFile;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"symbolsWithPackageNameOutputFile");
            }
            it.submit(GenerateLibRFileRunnable.class, (Serializable)new GenerateLibRFileParams(file2, manifest, file3, set, string, this.sourceOutputDirectory, this.rClassOutputJar, file4, this.namespacedRClass, file5));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public GenerateLibraryRFileTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    public static final /* synthetic */ FileCollection access$getPlatformAttrRTxt$p(GenerateLibraryRFileTask $this) {
        FileCollection fileCollection = $this.platformAttrRTxt;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
        }
        return fileCollection;
    }

    public static final /* synthetic */ Provider access$getApplicationId$p(GenerateLibraryRFileTask $this) {
        Provider<String> provider = $this.applicationId;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
        }
        return provider;
    }

    public static final /* synthetic */ FileCollection access$getDependencies$p(GenerateLibraryRFileTask $this) {
        FileCollection fileCollection = $this.dependencies;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return fileCollection;
    }

    public static final /* synthetic */ File access$getRClassOutputJar$p(GenerateLibraryRFileTask $this) {
        return $this.rClassOutputJar;
    }

    public static final /* synthetic */ File access$getSourceOutputDirectory$p(GenerateLibraryRFileTask $this) {
        return $this.sourceOutputDirectory;
    }

    public static final /* synthetic */ File access$getTextSymbolOutputFile$p(GenerateLibraryRFileTask $this) {
        File file = $this.textSymbolOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textSymbolOutputFile");
        }
        return file;
    }

    public static final /* synthetic */ File access$getSymbolsWithPackageNameOutputFile$p(GenerateLibraryRFileTask $this) {
        File file = $this.symbolsWithPackageNameOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"symbolsWithPackageNameOutputFile");
        }
        return file;
    }

    public static final /* synthetic */ Provider access$getPackageForR$p(GenerateLibraryRFileTask $this) {
        Provider<String> provider = $this.packageForR;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageForR");
        }
        return provider;
    }

    public static final /* synthetic */ Provider access$getManifestFiles$p(GenerateLibraryRFileTask $this) {
        return $this.manifestFiles;
    }

    public static final /* synthetic */ boolean access$getNamespacedRClass$p(GenerateLibraryRFileTask $this) {
        return $this.namespacedRClass;
    }

    public static final /* synthetic */ OutputScope access$getOutputScope$p(GenerateLibraryRFileTask $this) {
        return $this.outputScope;
    }

    public static final /* synthetic */ BuildableArtifact access$getLocalResourcesFile$p(GenerateLibraryRFileTask $this) {
        BuildableArtifact buildableArtifact = $this.localResourcesFile;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localResourcesFile");
        }
        return buildableArtifact;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u000eH\u00c6\u0003Jw\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\u00a8\u00060"}, d2={"Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask$GenerateLibRFileParams;", "Ljava/io/Serializable;", "localResourcesFile", "Ljava/io/File;", "manifest", "androidJar", "dependencies", "", "packageForR", "", "sourceOutputDirectory", "rClassOutputJar", "textSymbolOutputFile", "namespacedRClass", "", "symbolsWithPackageNameOutputFile", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/Set;Ljava/lang/String;Ljava/io/File;Ljava/io/File;Ljava/io/File;ZLjava/io/File;)V", "getAndroidJar", "()Ljava/io/File;", "getDependencies", "()Ljava/util/Set;", "getLocalResourcesFile", "getManifest", "getNamespacedRClass", "()Z", "getPackageForR", "()Ljava/lang/String;", "getRClassOutputJar", "getSourceOutputDirectory", "getSymbolsWithPackageNameOutputFile", "getTextSymbolOutputFile", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "gradle"})
    public static final class GenerateLibRFileParams
    implements Serializable {
        @NotNull
        private final File localResourcesFile;
        @NotNull
        private final File manifest;
        @NotNull
        private final File androidJar;
        @NotNull
        private final Set<File> dependencies;
        @NotNull
        private final String packageForR;
        @Nullable
        private final File sourceOutputDirectory;
        @Nullable
        private final File rClassOutputJar;
        @NotNull
        private final File textSymbolOutputFile;
        private final boolean namespacedRClass;
        @NotNull
        private final File symbolsWithPackageNameOutputFile;

        @NotNull
        public final File getLocalResourcesFile() {
            return this.localResourcesFile;
        }

        @NotNull
        public final File getManifest() {
            return this.manifest;
        }

        @NotNull
        public final File getAndroidJar() {
            return this.androidJar;
        }

        @NotNull
        public final Set<File> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final String getPackageForR() {
            return this.packageForR;
        }

        @Nullable
        public final File getSourceOutputDirectory() {
            return this.sourceOutputDirectory;
        }

        @Nullable
        public final File getRClassOutputJar() {
            return this.rClassOutputJar;
        }

        @NotNull
        public final File getTextSymbolOutputFile() {
            return this.textSymbolOutputFile;
        }

        public final boolean getNamespacedRClass() {
            return this.namespacedRClass;
        }

        @NotNull
        public final File getSymbolsWithPackageNameOutputFile() {
            return this.symbolsWithPackageNameOutputFile;
        }

        public GenerateLibRFileParams(@NotNull File localResourcesFile, @NotNull File manifest, @NotNull File androidJar, @NotNull Set<? extends File> dependencies, @NotNull String packageForR, @Nullable File sourceOutputDirectory, @Nullable File rClassOutputJar, @NotNull File textSymbolOutputFile, boolean namespacedRClass, @NotNull File symbolsWithPackageNameOutputFile) {
            Intrinsics.checkParameterIsNotNull((Object)localResourcesFile, (String)"localResourcesFile");
            Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
            Intrinsics.checkParameterIsNotNull((Object)androidJar, (String)"androidJar");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)packageForR, (String)"packageForR");
            Intrinsics.checkParameterIsNotNull((Object)textSymbolOutputFile, (String)"textSymbolOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)symbolsWithPackageNameOutputFile, (String)"symbolsWithPackageNameOutputFile");
            this.localResourcesFile = localResourcesFile;
            this.manifest = manifest;
            this.androidJar = androidJar;
            this.dependencies = dependencies;
            this.packageForR = packageForR;
            this.sourceOutputDirectory = sourceOutputDirectory;
            this.rClassOutputJar = rClassOutputJar;
            this.textSymbolOutputFile = textSymbolOutputFile;
            this.namespacedRClass = namespacedRClass;
            this.symbolsWithPackageNameOutputFile = symbolsWithPackageNameOutputFile;
        }

        @NotNull
        public final File component1() {
            return this.localResourcesFile;
        }

        @NotNull
        public final File component2() {
            return this.manifest;
        }

        @NotNull
        public final File component3() {
            return this.androidJar;
        }

        @NotNull
        public final Set<File> component4() {
            return this.dependencies;
        }

        @NotNull
        public final String component5() {
            return this.packageForR;
        }

        @Nullable
        public final File component6() {
            return this.sourceOutputDirectory;
        }

        @Nullable
        public final File component7() {
            return this.rClassOutputJar;
        }

        @NotNull
        public final File component8() {
            return this.textSymbolOutputFile;
        }

        public final boolean component9() {
            return this.namespacedRClass;
        }

        @NotNull
        public final File component10() {
            return this.symbolsWithPackageNameOutputFile;
        }

        @NotNull
        public final GenerateLibRFileParams copy(@NotNull File localResourcesFile, @NotNull File manifest, @NotNull File androidJar, @NotNull Set<? extends File> dependencies, @NotNull String packageForR, @Nullable File sourceOutputDirectory, @Nullable File rClassOutputJar, @NotNull File textSymbolOutputFile, boolean namespacedRClass, @NotNull File symbolsWithPackageNameOutputFile) {
            Intrinsics.checkParameterIsNotNull((Object)localResourcesFile, (String)"localResourcesFile");
            Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
            Intrinsics.checkParameterIsNotNull((Object)androidJar, (String)"androidJar");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)packageForR, (String)"packageForR");
            Intrinsics.checkParameterIsNotNull((Object)textSymbolOutputFile, (String)"textSymbolOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)symbolsWithPackageNameOutputFile, (String)"symbolsWithPackageNameOutputFile");
            return new GenerateLibRFileParams(localResourcesFile, manifest, androidJar, dependencies, packageForR, sourceOutputDirectory, rClassOutputJar, textSymbolOutputFile, namespacedRClass, symbolsWithPackageNameOutputFile);
        }

        @NotNull
        public static /* synthetic */ GenerateLibRFileParams copy$default(GenerateLibRFileParams generateLibRFileParams, File file, File file2, File file3, Set set, String string, File file4, File file5, File file6, boolean bl, File file7, int n, Object object) {
            if ((n & 1) != 0) {
                file = generateLibRFileParams.localResourcesFile;
            }
            if ((n & 2) != 0) {
                file2 = generateLibRFileParams.manifest;
            }
            if ((n & 4) != 0) {
                file3 = generateLibRFileParams.androidJar;
            }
            if ((n & 8) != 0) {
                set = generateLibRFileParams.dependencies;
            }
            if ((n & 0x10) != 0) {
                string = generateLibRFileParams.packageForR;
            }
            if ((n & 0x20) != 0) {
                file4 = generateLibRFileParams.sourceOutputDirectory;
            }
            if ((n & 0x40) != 0) {
                file5 = generateLibRFileParams.rClassOutputJar;
            }
            if ((n & 0x80) != 0) {
                file6 = generateLibRFileParams.textSymbolOutputFile;
            }
            if ((n & 0x100) != 0) {
                bl = generateLibRFileParams.namespacedRClass;
            }
            if ((n & 0x200) != 0) {
                file7 = generateLibRFileParams.symbolsWithPackageNameOutputFile;
            }
            return generateLibRFileParams.copy(file, file2, file3, set, string, file4, file5, file6, bl, file7);
        }

        @NotNull
        public String toString() {
            return "GenerateLibRFileParams(localResourcesFile=" + this.localResourcesFile + ", manifest=" + this.manifest + ", androidJar=" + this.androidJar + ", dependencies=" + this.dependencies + ", packageForR=" + this.packageForR + ", sourceOutputDirectory=" + this.sourceOutputDirectory + ", rClassOutputJar=" + this.rClassOutputJar + ", textSymbolOutputFile=" + this.textSymbolOutputFile + ", namespacedRClass=" + this.namespacedRClass + ", symbolsWithPackageNameOutputFile=" + this.symbolsWithPackageNameOutputFile + ")";
        }

        public int hashCode() {
            File file = this.localResourcesFile;
            File file2 = this.manifest;
            File file3 = this.androidJar;
            Set<File> set = this.dependencies;
            String string = this.packageForR;
            File file4 = this.sourceOutputDirectory;
            File file5 = this.rClassOutputJar;
            File file6 = this.textSymbolOutputFile;
            int n = ((((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (file5 != null ? ((Object)file5).hashCode() : 0)) * 31 + (file6 != null ? ((Object)file6).hashCode() : 0)) * 31;
            int n2 = this.namespacedRClass ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            File file7 = this.symbolsWithPackageNameOutputFile;
            return (n + n2) * 31 + (file7 != null ? ((Object)file7).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GenerateLibRFileParams)) break block3;
                    GenerateLibRFileParams generateLibRFileParams = (GenerateLibRFileParams)object;
                    if (!Intrinsics.areEqual((Object)this.localResourcesFile, (Object)generateLibRFileParams.localResourcesFile) || !Intrinsics.areEqual((Object)this.manifest, (Object)generateLibRFileParams.manifest) || !Intrinsics.areEqual((Object)this.androidJar, (Object)generateLibRFileParams.androidJar) || !Intrinsics.areEqual(this.dependencies, generateLibRFileParams.dependencies) || !Intrinsics.areEqual((Object)this.packageForR, (Object)generateLibRFileParams.packageForR) || !Intrinsics.areEqual((Object)this.sourceOutputDirectory, (Object)generateLibRFileParams.sourceOutputDirectory) || !Intrinsics.areEqual((Object)this.rClassOutputJar, (Object)generateLibRFileParams.rClassOutputJar) || !Intrinsics.areEqual((Object)this.textSymbolOutputFile, (Object)generateLibRFileParams.textSymbolOutputFile) || !(this.namespacedRClass == generateLibRFileParams.namespacedRClass) || !Intrinsics.areEqual((Object)this.symbolsWithPackageNameOutputFile, (Object)generateLibRFileParams.symbolsWithPackageNameOutputFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask$GenerateLibRFileRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask$GenerateLibRFileParams;", "(Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask$GenerateLibRFileParams;)V", "getAndroidAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "kotlin.jvm.PlatformType", "run", "", "gradle"})
    public static final class GenerateLibRFileRunnable
    implements Runnable {
        private final GenerateLibRFileParams params;

        @Override
        public void run() {
            SymbolTable symbolTable;
            SymbolTable androidAttrSymbol = this.getAndroidAttrSymbols();
            SymbolTable symbolTable2 = symbolTable = SymbolIo.readRDef((Path)this.params.getLocalResourcesFile().toPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable2, (String)"symbolTable");
            Set<File> set = this.params.getDependencies();
            String string = this.params.getPackageForR();
            File file = this.params.getManifest();
            File file2 = this.params.getSourceOutputDirectory();
            File file3 = this.params.getRClassOutputJar();
            File file4 = this.params.getTextSymbolOutputFile();
            SymbolTable symbolTable3 = androidAttrSymbol;
            Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable3, (String)"androidAttrSymbol");
            SymbolExportUtils.processLibraryMainSymbolTable((SymbolTable)symbolTable2, set, (String)string, (File)file, (File)file2, (File)file3, (File)file4, (SymbolTable)symbolTable3, (boolean)this.params.getNamespacedRClass());
            SymbolIo.writeSymbolListWithPackageName((Path)this.params.getTextSymbolOutputFile().toPath(), (Path)this.params.getManifest().toPath(), (Path)this.params.getSymbolsWithPackageNameOutputFile().toPath());
        }

        private final SymbolTable getAndroidAttrSymbols() {
            return this.params.getAndroidJar().exists() ? SymbolIo.readFromAapt((File)this.params.getAndroidJar(), (String)"android") : SymbolTable.Companion.builder().tablePackage("android").build();
        }

        @Inject
        public GenerateLibRFileRunnable(@NotNull GenerateLibRFileParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/res/GenerateLibraryRFileTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "symbolFile", "Ljava/io/File;", "symbolsWithPackageNameOutputFile", "(Lcom/android/build/gradle/internal/scope/VariantScope;Ljava/io/File;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "rClassOutputJar", "sourceOutputDirectory", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateLibraryRFileTask> {
        private File rClassOutputJar;
        private File sourceOutputDirectory;
        private final File symbolFile;
        private final File symbolsWithPackageNameOutputFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("generate", "RFile");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"generate\", \"RFile\")");
            return string;
        }

        @Override
        @NotNull
        public Class<GenerateLibraryRFileTask> getType() {
            return GenerateLibraryRFileTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            if (globalScope.getProjectOptions().get(BooleanOption.ENABLE_SEPARATE_R_CLASS_COMPILATION)) {
                this.rClassOutputJar = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR, taskName, "R.jar");
            } else {
                this.sourceOutputDirectory = BuildArtifactsHolder.appendArtifact$default(this.getVariantScope().getArtifacts(), (ArtifactType)InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES, taskName, null, 4, null);
            }
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends GenerateLibraryRFileTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setProcessAndroidResTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateLibraryRFileTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            FileCollection fileCollection = globalScope.getPlatformAttrs();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.globalScope.platformAttrs");
            task.platformAttrRTxt = fileCollection;
            Provider provider = TaskInputHelper.memoizeToProvider(task.getProject(), new Supplier<T>(this){
                final /* synthetic */ CreationAction this$0;

                @NotNull
                public final String get() {
                    BaseVariantData baseVariantData = CreationAction.access$getVariantScope$p(this.this$0).getVariantData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
                    GradleVariantConfiguration gradleVariantConfiguration = baseVariantData.getVariantConfiguration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantData.variantConfiguration");
                    return gradleVariantConfiguration.getApplicationId();
                }
                {
                    this.this$0 = creationAction;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(provider, (String)"TaskInputHelper.memoizeT\u2026plicationId\n            }");
            task.applicationId = provider;
            FileCollection fileCollection2 = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getArtifact\u2026L_LIST_WITH_PACKAGE_NAME)");
            task.dependencies = fileCollection2;
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            if (globalScope2.getProjectOptions().get(BooleanOption.ENABLE_SEPARATE_R_CLASS_COMPILATION)) {
                File file = this.rClassOutputJar;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rClassOutputJar");
                }
                task.rClassOutputJar = file;
            } else {
                File file = this.sourceOutputDirectory;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDirectory");
                }
                task.sourceOutputDirectory = file;
            }
            task.textSymbolOutputFile = this.symbolFile;
            task.symbolsWithPackageNameOutputFile = this.symbolsWithPackageNameOutputFile;
            Provider provider2 = TaskInputHelper.memoizeToProvider(task.getProject(), new Supplier<T>(this){
                final /* synthetic */ CreationAction this$0;

                public final String get() {
                    GradleVariantConfiguration gradleVariantConfiguration = CreationAction.access$getVariantScope$p(this.this$0).getVariantConfiguration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
                    return Strings.nullToEmpty((String)gradleVariantConfiguration.getOriginalApplicationId());
                }
                {
                    this.this$0 = creationAction;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(provider2, (String)"TaskInputHelper.memoizeT\u2026licationId)\n            }");
            task.packageForR = provider2;
            task.manifestFiles = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
            GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
            task.namespacedRClass = globalScope3.getProjectOptions().get(BooleanOption.NAMESPACED_R_CLASS);
            task.outputScope = this.getVariantScope().getOutputScope();
            task.localResourcesFile = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.LOCAL_ONLY_SYMBOL_LIST);
        }

        public CreationAction(@NotNull VariantScope variantScope, @NotNull File symbolFile, @NotNull File symbolsWithPackageNameOutputFile) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull((Object)symbolFile, (String)"symbolFile");
            Intrinsics.checkParameterIsNotNull((Object)symbolsWithPackageNameOutputFile, (String)"symbolsWithPackageNameOutputFile");
            super(variantScope);
            this.symbolFile = symbolFile;
            this.symbolsWithPackageNameOutputFile = symbolsWithPackageNameOutputFile;
        }

        public static final /* synthetic */ VariantScope access$getVariantScope$p(CreationAction $this) {
            return $this.getVariantScope();
        }
    }
}

