/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ClasspathComparisionTask;
import java.io.File;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class TestPreBuildTask
extends ClasspathComparisionTask {
    @Override
    void onDifferentVersionsFound(String group, String module, String runtimeVersion, String compileVersion) {
        throw new GradleException(String.format("Conflict with dependency '%s:%s' in project '%s'. Resolved versions for app (%s) and test app (%s) differ. See https://d.android.com/r/tools/test-apk-dependency-conflicts.html for details.", group, module, this.getProject().getPath(), compileVersion, runtimeVersion));
    }

    @TaskAction
    void run() {
        this.compareClasspaths();
    }

    public static class CreationAction
    extends TaskManager.AbstractPreBuildCreationAction<TestPreBuildTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public Class<TestPreBuildTask> getType() {
            return TestPreBuildTask.class;
        }

        @Override
        public void configure(TestPreBuildTask task) {
            super.configure(task);
            task.setVariantName(this.variantScope.getFullVariantName());
            task.runtimeClasspath = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.compileClasspath = Objects.requireNonNull(this.variantScope.getTestedVariantData()).getScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.fakeOutputDirectory = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "prebuild/" + this.variantScope.getVariantConfiguration().getDirName());
        }
    }
}

