/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitUtils;
import com.android.build.gradle.options.IntegerOption;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\u001f !B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0007R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00158G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "inputFiles", "getInputFiles", "()Lorg/gradle/api/file/FileCollection;", "setInputFiles$gradle", "(Lorg/gradle/api/file/FileCollection;)V", "", "maxNumberOfFeaturesBeforeOreo", "getMaxNumberOfFeaturesBeforeOreo", "()I", "setMaxNumberOfFeaturesBeforeOreo$gradle", "(I)V", "minSdkVersion", "getMinSdkVersion", "setMinSdkVersion$gradle", "Ljava/io/File;", "outputFile", "getOutputFile", "()Ljava/io/File;", "setOutputFile$gradle", "(Ljava/io/File;)V", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "fullTaskAction", "", "CreationAction", "FeatureSetRunnable", "Params", "gradle"})
public class FeatureSetMetadataWriterTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    public FileCollection inputFiles;
    @NotNull
    public File outputFile;
    private int minSdkVersion;
    private int maxNumberOfFeaturesBeforeOreo;

    @InputFiles
    @NotNull
    public final FileCollection getInputFiles() {
        FileCollection fileCollection = this.inputFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFiles");
        }
        return fileCollection;
    }

    public final void setInputFiles$gradle(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.inputFiles = fileCollection;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    public final void setOutputFile$gradle(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputFile = file;
    }

    @Input
    public final int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public final void setMinSdkVersion$gradle(int n) {
        this.minSdkVersion = n;
    }

    @Input
    public final int getMaxNumberOfFeaturesBeforeOreo() {
        return this.maxNumberOfFeaturesBeforeOreo;
    }

    public final void setMaxNumberOfFeaturesBeforeOreo$gradle(int n) {
        this.maxNumberOfFeaturesBeforeOreo = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void fullTaskAction() throws IOException {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl = false;
            FileCollection fileCollection = this.inputFiles;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputFiles");
            }
            FileTree fileTree = fileCollection.getAsFileTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"inputFiles.asFileTree");
            Set set = fileTree.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"inputFiles.asFileTree.files");
            File file = this.outputFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
            }
            it.submit(FeatureSetRunnable.class, (Serializable)new Params(set, this.minSdkVersion, this.maxNumberOfFeaturesBeforeOreo, file));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public FeatureSetMetadataWriterTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
        this.minSdkVersion = 1;
        Integer n = FeatureSetMetadata.MAX_NUMBER_OF_SPLITS_BEFORE_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"FeatureSetMetadata.MAX_NUMBER_OF_SPLITS_BEFORE_O");
        this.maxNumberOfFeaturesBeforeOreo = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$Params;", "Ljava/io/Serializable;", "featureFiles", "", "Ljava/io/File;", "minSdkVersion", "", "maxNumberOfFeaturesBeforeOreo", "outputFile", "(Ljava/util/Set;IILjava/io/File;)V", "getFeatureFiles", "()Ljava/util/Set;", "getMaxNumberOfFeaturesBeforeOreo", "()I", "getMinSdkVersion", "getOutputFile", "()Ljava/io/File;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final Set<File> featureFiles;
        private final int minSdkVersion;
        private final int maxNumberOfFeaturesBeforeOreo;
        @NotNull
        private final File outputFile;

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        public final int getMinSdkVersion() {
            return this.minSdkVersion;
        }

        public final int getMaxNumberOfFeaturesBeforeOreo() {
            return this.maxNumberOfFeaturesBeforeOreo;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        public Params(@NotNull Set<? extends File> featureFiles, int minSdkVersion, int maxNumberOfFeaturesBeforeOreo, @NotNull File outputFile) {
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            this.featureFiles = featureFiles;
            this.minSdkVersion = minSdkVersion;
            this.maxNumberOfFeaturesBeforeOreo = maxNumberOfFeaturesBeforeOreo;
            this.outputFile = outputFile;
        }

        @NotNull
        public final Set<File> component1() {
            return this.featureFiles;
        }

        public final int component2() {
            return this.minSdkVersion;
        }

        public final int component3() {
            return this.maxNumberOfFeaturesBeforeOreo;
        }

        @NotNull
        public final File component4() {
            return this.outputFile;
        }

        @NotNull
        public final Params copy(@NotNull Set<? extends File> featureFiles, int minSdkVersion, int maxNumberOfFeaturesBeforeOreo, @NotNull File outputFile) {
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            return new Params(featureFiles, minSdkVersion, maxNumberOfFeaturesBeforeOreo, outputFile);
        }

        @NotNull
        public static /* synthetic */ Params copy$default(Params params, Set set, int n, int n2, File file, int n3, Object object) {
            if ((n3 & 1) != 0) {
                set = params.featureFiles;
            }
            if ((n3 & 2) != 0) {
                n = params.minSdkVersion;
            }
            if ((n3 & 4) != 0) {
                n2 = params.maxNumberOfFeaturesBeforeOreo;
            }
            if ((n3 & 8) != 0) {
                file = params.outputFile;
            }
            return params.copy(set, n, n2, file);
        }

        @NotNull
        public String toString() {
            return "Params(featureFiles=" + this.featureFiles + ", minSdkVersion=" + this.minSdkVersion + ", maxNumberOfFeaturesBeforeOreo=" + this.maxNumberOfFeaturesBeforeOreo + ", outputFile=" + this.outputFile + ")";
        }

        public int hashCode() {
            Set<File> set = this.featureFiles;
            File file = this.outputFile;
            return (((set != null ? ((Object)set).hashCode() : 0) * 31 + Integer.hashCode(this.minSdkVersion)) * 31 + Integer.hashCode(this.maxNumberOfFeaturesBeforeOreo)) * 31 + (file != null ? ((Object)file).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !(this.minSdkVersion == params.minSdkVersion) || !(this.maxNumberOfFeaturesBeforeOreo == params.maxNumberOfFeaturesBeforeOreo) || !Intrinsics.areEqual((Object)this.outputFile, (Object)params.outputFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$FeatureSetRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$Params;", "(Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$Params;)V", "run", "", "gradle"})
    private static final class FeatureSetRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            List features = new ArrayList();
            FeatureSetMetadata featureMetadata = new FeatureSetMetadata(this.params.getMaxNumberOfFeaturesBeforeOreo());
            for (File file : this.params.getFeatureFiles()) {
                try {
                    FeatureSplitDeclaration featureSplitDeclaration = FeatureSplitDeclaration.load(file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)featureSplitDeclaration, (String)"FeatureSplitDeclaration.load(file)");
                    features.add(featureSplitDeclaration);
                }
                catch (FileNotFoundException e) {
                    throw (Throwable)new BuildException("Cannot read features split declaration file", (Throwable)e);
                }
            }
            Map<String, String> featureNameMap = FeatureSplitUtils.computeFeatureNames(features);
            for (FeatureSplitDeclaration feature : features) {
                int n = this.params.getMinSdkVersion();
                String string = feature.getModulePath();
                String string2 = featureNameMap.get(feature.getModulePath());
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                featureMetadata.addFeatureSplit(n, string, string2);
            }
            featureMetadata.save(this.params.getOutputFile());
        }

        @Inject
        public FeatureSetRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "outputFile", "Ljava/io/File;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FeatureSetMetadataWriterTask> {
        private File outputFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("generate", "FeatureMetadata");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026rate\", \"FeatureMetadata\")");
            return string;
        }

        @Override
        @NotNull
        public Class<FeatureSetMetadataWriterTask> getType() {
            return FeatureSetMetadataWriterTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputFile = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FEATURE_SET_METADATA, taskName, "feature-metadata.json");
        }

        @Override
        public void configure(@NotNull FeatureSetMetadataWriterTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            AndroidVersion androidVersion = this.getVariantScope().getMinSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"variantScope.minSdkVersion");
            task.setMinSdkVersion$gradle(androidVersion.getApiLevel());
            File file = this.outputFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
            }
            task.setOutputFile$gradle(file);
            FileCollection fileCollection = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.METADATA_FEATURE_DECLARATION);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getArtifact\u2026DECLARATION\n            )");
            task.setInputFiles$gradle(fileCollection);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Integer maxNumberOfFeaturesBeforeOreo = globalScope.getProjectOptions().get(IntegerOption.PRE_O_MAX_NUMBER_OF_FEATURES);
            if (maxNumberOfFeaturesBeforeOreo != null) {
                task.setMaxNumberOfFeaturesBeforeOreo$gradle(Integer.min(100, maxNumberOfFeaturesBeforeOreo));
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

