/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.tasks.ResourceUsageAnalyzer;
import com.android.builder.core.VariantType;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.xml.sax.SAXException;

public class ShrinkResourcesTransform
extends Transform {
    private static boolean ourWarned = true;
    private final BaseVariantData variantData;
    private final Logger logger;
    private final BuildableArtifact sourceDir;
    private final BuildableArtifact resourceDir;
    private final BuildableArtifact mappingFileSrc;
    private final Provider<Directory> mergedManifests;
    private final BuildableArtifact uncompressedResources;
    private final AaptOptions aaptOptions;
    private final VariantType variantType;
    private final boolean isDebuggableBuildType;
    private final MultiOutputPolicy multiOutputPolicy;
    private final File compressedResources;

    public ShrinkResourcesTransform(BaseVariantData variantData, BuildableArtifact uncompressedResources, File compressedResources, Logger logger) {
        VariantScope variantScope = variantData.getScope();
        GlobalScope globalScope = variantScope.getGlobalScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        this.variantData = variantData;
        this.logger = logger;
        BuildArtifactsHolder artifacts = variantScope.getArtifacts();
        this.sourceDir = artifacts.getFinalArtifactFiles(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES);
        this.resourceDir = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_NOT_COMPILED_RES);
        this.mappingFileSrc = variantScope.getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING) ? variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING) : null;
        this.mergedManifests = artifacts.getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
        this.uncompressedResources = uncompressedResources;
        this.aaptOptions = globalScope.getExtension().getAaptOptions();
        this.variantType = variantData.getType();
        this.isDebuggableBuildType = ((CoreBuildType)variantConfig.getBuildType()).isDebuggable();
        this.multiOutputPolicy = variantData.getMultiOutputPolicy();
        this.compressedResources = compressedResources;
    }

    public String getName() {
        return "shrinkRes";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX), (Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        LinkedList secondaryFiles = Lists.newLinkedList();
        secondaryFiles.add(SecondaryFile.nonIncremental((Supplier)this.sourceDir));
        secondaryFiles.add(SecondaryFile.nonIncremental((Supplier)this.resourceDir));
        if (this.mappingFileSrc != null) {
            secondaryFiles.add(SecondaryFile.nonIncremental((Supplier)this.mappingFileSrc));
        }
        secondaryFiles.add(SecondaryFile.nonIncremental((File)((Directory)this.mergedManifests.get()).getAsFile()));
        secondaryFiles.add(SecondaryFile.nonIncremental((Supplier)this.uncompressedResources));
        return secondaryFiles;
    }

    public Map<String, Object> getParameterInputs() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)7);
        params.put("aaptOptions", Joiner.on((String)";").join((Object)(this.aaptOptions.getIgnoreAssetsPattern() != null ? this.aaptOptions.getIgnoreAssetsPattern() : ""), (Object)(this.aaptOptions.getNoCompress() != null ? Joiner.on((String)":").join(this.aaptOptions.getNoCompress()) : ""), new Object[]{this.aaptOptions.getFailOnMissingConfigEntry(), this.aaptOptions.getAdditionalParameters() != null ? Joiner.on((String)":").join(this.aaptOptions.getAdditionalParameters()) : "", this.aaptOptions.getCruncherProcesses()}));
        params.put("variantType", this.variantType.getName());
        params.put("isDebuggableBuildType", this.isDebuggableBuildType);
        params.put("splitHandlingPolicy", this.multiOutputPolicy);
        return params;
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.compressedResources);
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) {
        Collection referencedInputs = invocation.getReferencedInputs();
        ArrayList<File> classes = new ArrayList<File>();
        for (TransformInput transformInput : referencedInputs) {
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                classes.add(directoryInput.getFile());
            }
            for (JarInput jarInput : transformInput.getJarInputs()) {
                classes.add(jarInput.getFile());
            }
        }
        BuildElements mergedManifestsOutputs = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.mergedManifests);
        WorkerExecutorFacade workers = Workers.INSTANCE.preferWorkers(invocation.getContext().getProjectName(), invocation.getContext().getPath(), invocation.getContext().getWorkerExecutor());
        Object object = null;
        try {
            ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, this.uncompressedResources).transform(workers, SplitterRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, buildInput) -> new SplitterParams((ApkData)apkInfo, (File)buildInput, mergedManifestsOutputs, (List<File>)classes, this))).into(InternalArtifactType.SHRUNK_PROCESSED_RES, this.compressedResources);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (workers != null) {
                if (object != null) {
                    try {
                        workers.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    workers.close();
                }
            }
        }
    }

    private static String toKbString(long size) {
        return Integer.toString((int)size / 1024);
    }

    private static class SplitterParams
    extends BuildElementsTransformParams {
        private final File uncompressedResourceFile;
        private final File compressedResourceFile;
        private final BuildOutput mergedManifest;
        private final List<File> classes;
        private final File mappingFile;
        private final String buildTypeName;
        private final File sourceDir;
        private final File resourceDir;
        private final boolean isInfoLoggingEnabled;
        private final boolean isDebugLoggingEnabled;

        SplitterParams(ApkData apkInfo, File uncompressedResourceFile, BuildElements mergedManifests, List<File> classes, ShrinkResourcesTransform transform2) {
            this.uncompressedResourceFile = uncompressedResourceFile;
            this.mergedManifest = mergedManifests.element(apkInfo);
            this.classes = classes;
            this.compressedResourceFile = new File(transform2.compressedResources, "resources-" + apkInfo.getBaseName() + "-stripped.ap_");
            this.mappingFile = transform2.mappingFileSrc != null ? BuildableArtifactUtil.singleFile(transform2.mappingFileSrc) : null;
            this.buildTypeName = ((CoreBuildType)transform2.variantData.getVariantConfiguration().getBuildType()).getName();
            this.sourceDir = (File)Iterables.getOnlyElement((Iterable)transform2.sourceDir.getFiles());
            this.resourceDir = BuildableArtifactUtil.singleFile(transform2.resourceDir);
            this.isInfoLoggingEnabled = transform2.logger.isEnabled(LogLevel.INFO);
            this.isDebugLoggingEnabled = transform2.logger.isEnabled(LogLevel.DEBUG);
        }

        @Override
        public File getOutput() {
            return this.compressedResourceFile;
        }
    }

    private static class SplitterRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public SplitterRunnable(SplitterParams params) {
            super(params);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File logDir;
            SplitterParams params = (SplitterParams)this.getParams();
            File reportFile = null;
            if (params.mappingFile != null && (logDir = params.mappingFile.getParentFile()) != null) {
                reportFile = new File(logDir, "resources.txt");
            }
            FileUtils.mkdirs((File)params.compressedResourceFile.getParentFile());
            if (params.mergedManifest == null) {
                try {
                    FileUtils.copyFile((File)params.uncompressedResourceFile, (File)params.compressedResourceFile);
                }
                catch (IOException e) {
                    Logging.getLogger(ShrinkResourcesTransform.class).error("Failed to copy uncompressed resource file :", (Throwable)e);
                    throw new RuntimeException("Failed to copy uncompressed resource file", e);
                }
                return;
            }
            ResourceUsageAnalyzer analyzer = new ResourceUsageAnalyzer(params.sourceDir, (Iterable<File>)params.classes, params.mergedManifest.getOutputFile(), params.mappingFile, params.resourceDir, reportFile, ResourceUsageAnalyzer.ApkFormat.BINARY);
            try {
                analyzer.setVerbose(params.isInfoLoggingEnabled);
                analyzer.setDebug(params.isDebugLoggingEnabled);
                try {
                    analyzer.analyze();
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new RuntimeException(e);
                }
                try {
                    analyzer.rewriteResourceZip(params.uncompressedResourceFile, params.compressedResourceFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                int unused = analyzer.getUnusedResourceCount();
                if (unused > 0) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("Removed unused resources");
                    long before = params.uncompressedResourceFile.length();
                    long after = params.compressedResourceFile.length();
                    long percent = (int)((before - after) * 100L / before);
                    sb.append(": Binary resource data reduced from ").append(ShrinkResourcesTransform.toKbString(before)).append("KB to ").append(ShrinkResourcesTransform.toKbString(after)).append("KB: Removed ").append(percent).append("%");
                    if (!ourWarned) {
                        ourWarned = true;
                        sb.append("\n").append("Note: If necessary, you can disable resource shrinking by adding\n").append("android {\n").append("    buildTypes {\n").append("        ").append(params.buildTypeName).append(" {\n").append("            shrinkResources false\n").append("        }\n").append("    }\n").append("}");
                    }
                    System.out.println(sb.toString());
                }
            }
            finally {
                analyzer.dispose();
            }
        }
    }
}

