/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DependenciesImpl
implements Dependencies,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final Dependencies EMPTY = new DependenciesImpl((List<AndroidLibrary>)ImmutableList.of(), (List<JavaLibrary>)ImmutableList.of(), (List<Dependencies.ProjectIdentifier>)ImmutableList.of(), (List<File>)ImmutableList.of());
    private final List<AndroidLibrary> libraries;
    private final List<JavaLibrary> javaLibraries;
    private final Set<String> projects;
    private final List<Dependencies.ProjectIdentifier> javaModules;
    private final List<File> runtimeOnlyClasses;

    public DependenciesImpl(List<AndroidLibrary> libraries, List<JavaLibrary> javaLibraries, List<Dependencies.ProjectIdentifier> javaModules, List<File> runtimeOnlyClasses) {
        this.libraries = libraries;
        this.javaLibraries = javaLibraries;
        this.javaModules = javaModules;
        this.runtimeOnlyClasses = runtimeOnlyClasses;
        this.projects = (Set)javaModules.stream().map(Dependencies.ProjectIdentifier::getProjectPath).collect(ImmutableSet.toImmutableSet());
    }

    public Collection<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    public Collection<JavaLibrary> getJavaLibraries() {
        return this.javaLibraries;
    }

    public Collection<String> getProjects() {
        return this.projects;
    }

    public List<Dependencies.ProjectIdentifier> getJavaModules() {
        return this.javaModules;
    }

    public Collection<File> getRuntimeOnlyClasses() {
        return this.runtimeOnlyClasses;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("libraries", this.libraries).add("javaLibraries", this.javaLibraries).add("javaModules", this.javaModules).add("projects", this.projects).add("runtimeOnlyClasses", this.runtimeOnlyClasses).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependenciesImpl that = (DependenciesImpl)o;
        return Objects.equals(this.libraries, that.libraries) && Objects.equals(this.javaLibraries, that.javaLibraries) && Objects.equals(this.projects, that.projects) && Objects.equals(this.javaModules, that.javaModules) && Objects.equals(this.runtimeOnlyClasses, that.runtimeOnlyClasses);
    }

    public int hashCode() {
        return Objects.hash(this.libraries, this.javaLibraries, this.projects, this.javaModules, this.runtimeOnlyClasses);
    }

    public static class ProjectIdentifierImpl
    implements Dependencies.ProjectIdentifier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String buildId;
        private final String projectPath;

        public ProjectIdentifierImpl(String buildId, String projectPath2) {
            this.buildId = buildId;
            this.projectPath = projectPath2;
        }

        public String getBuildId() {
            return this.buildId;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectIdentifierImpl that = (ProjectIdentifierImpl)o;
            return Objects.equals(this.buildId, that.buildId) && Objects.equals(this.projectPath, that.projectPath);
        }

        public int hashCode() {
            return Objects.hash(this.buildId, this.projectPath);
        }
    }
}

