/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.DependencyInfo;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a<\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS", "", "pluginList", "", "Lcom/android/build/gradle/internal/utils/DependencyInfo;", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "pluginInfo", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "enforceMinimumVersionsOfPlugins", "visitDependency", "dependencyResult", "Lorg/gradle/api/artifacts/result/DependencyResult;", "parentPath", "dependencyInfo", "pathsToViolatingDeps", "", "visitedDependencies", "", "gradle"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final String INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS = "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS";
    private static final List<DependencyInfo> pluginList;

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull EvalIssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        boolean alreadyChecked = extensionContainer.getExtraProperties().has(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS);
        if (alreadyChecked) {
            return;
        }
        Project project3 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
        ExtensionContainer extensionContainer2 = project3.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer2, (String)"project.rootProject.extensions");
        extensionContainer2.getExtraProperties().set(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS, (Object)true);
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(issueReporter){
            final /* synthetic */ EvalIssueReporter $issueReporter;

            public final void execute(Gradle gradle) {
                gradle.allprojects((Action)new Action<Project>(this){
                    final /* synthetic */ enforceMinimumVersionsOfPlugins.1 this$0;

                    public final void execute(Project it) {
                        for (DependencyInfo plugin : GradlePluginUtils.access$getPluginList$p()) {
                            Project project = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                            GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project, plugin, this.this$0.$issueReporter);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$issueReporter = evalIssueReporter;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, EvalIssueReporter issueReporter) {
        ScriptHandler scriptHandler = project.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration buildScriptClasspath = scriptHandler.getConfigurations().getByName("classpath");
        List pathsToViolatingPlugins = new ArrayList();
        Configuration configuration = buildScriptClasspath;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"buildScriptClasspath");
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"buildScriptClasspath.incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"buildScriptClasspath.incoming.resolutionResult");
        ResolvedComponentResult resolvedComponentResult = resolutionResult.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"buildScriptClasspath.inc\u2026ing.resolutionResult.root");
        for (DependencyResult dependency : resolvedComponentResult.getDependencies()) {
            String string;
            DependencyResult dependencyResult;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"dependency");
            Intrinsics.checkExpressionValueIsNotNull((Object)project.getDisplayName(), (String)"project.displayName");
            List list = pathsToViolatingPlugins;
            DependencyInfo dependencyInfo = pluginInfo;
            Set set = new LinkedHashSet();
            GradlePluginUtils.visitDependency(dependencyResult, string, dependencyInfo, list, set);
        }
        Collection collection = pathsToViolatingPlugins;
        if (!collection.isEmpty()) {
            issueReporter.reportError(EvalIssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, new EvalIssueException("The Android Gradle plugin supports only " + pluginInfo.getDisplayName() + " Gradle plugin" + " version " + pluginInfo.getMinimumVersion() + " and higher.\n" + "The following dependencies do not satisfy the required version:\n" + CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new Object[]{pluginInfo.getDisplayName(), pluginInfo.getDependencyGroup(), pluginInfo.getDependencyName(), pluginInfo.getMinimumVersion(), CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null)}), (CharSequence)";", null, null, (int)0, null, null, (int)62, null), null));
        }
    }

    @VisibleForTesting
    public static final void visitDependency(@NotNull DependencyResult dependencyResult, @NotNull String parentPath, @NotNull DependencyInfo dependencyInfo, @NotNull List<String> pathsToViolatingDeps, @NotNull Set<String> visitedDependencies) {
        String dependencyFullName;
        GradleVersion parsedVersion;
        ResolvedComponentResult dependency;
        Intrinsics.checkParameterIsNotNull((Object)dependencyResult, (String)"dependencyResult");
        Intrinsics.checkParameterIsNotNull((Object)parentPath, (String)"parentPath");
        Intrinsics.checkParameterIsNotNull((Object)dependencyInfo, (String)"dependencyInfo");
        Intrinsics.checkParameterIsNotNull(pathsToViolatingDeps, (String)"pathsToViolatingDeps");
        Intrinsics.checkParameterIsNotNull(visitedDependencies, (String)"visitedDependencies");
        boolean bl = dependencyResult instanceof ResolvedDependencyResult;
        if (!bl) {
            boolean bl2 = false;
            String string = "Expected " + ResolvedDependencyResult.class.getName() + " but found " + dependencyResult.getClass().getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ResolvedComponentResult resolvedComponentResult = dependency = ((ResolvedDependencyResult)dependencyResult).getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"dependency");
        ModuleVersionIdentifier moduleVersionIdentifier = resolvedComponentResult.getModuleVersion();
        if (moduleVersionIdentifier == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"dependency.moduleVersion!!");
        ModuleVersionIdentifier moduleVersion = moduleVersionIdentifier;
        String group = moduleVersion.getGroup();
        String name = moduleVersion.getName();
        String version = moduleVersion.getVersion();
        String currentPath = parentPath + " -> " + group + ':' + name + ':' + version;
        if (Intrinsics.areEqual((Object)group, (Object)dependencyInfo.getDependencyGroup()) && Intrinsics.areEqual((Object)name, (Object)dependencyInfo.getDependencyName()) && (parsedVersion = GradleVersion.tryParse((String)version)) != null && parsedVersion.compareTo(dependencyInfo.getMinimumVersion()) < 0) {
            pathsToViolatingDeps.add(currentPath);
        }
        if (visitedDependencies.contains(dependencyFullName = group + ':' + name + ':' + version)) {
            return;
        }
        visitedDependencies.add(dependencyFullName);
        Iterator iterator = dependency.getDependencies().iterator();
        while (iterator.hasNext()) {
            DependencyResult childDependency;
            DependencyResult dependencyResult2 = childDependency = (DependencyResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyResult2, (String)"childDependency");
            GradlePluginUtils.visitDependency(dependencyResult2, currentPath, dependencyInfo, pathsToViolatingDeps, visitedDependencies);
        }
    }

    static {
        Object[] objectArray = new DependencyInfo[4];
        GradleVersion gradleVersion = GradleVersion.parse((String)"9.0.0-rc2");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.parse(\"9.0.0-rc2\")");
        objectArray[0] = new DependencyInfo("Butterknife", "com.jakewharton", "butterknife-gradle-plugin", gradleVersion);
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"1.25.4");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"GradleVersion.parse(\"1.25.4\")");
        objectArray[1] = new DependencyInfo("Crashlytics", "io.fabric.tools", "gradle", gradleVersion2);
        GradleVersion gradleVersion3 = GradleVersion.parse((String)"0.8.6");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion3, (String)"GradleVersion.parse(\"0.8.6\")");
        objectArray[2] = new DependencyInfo("Protobuf", "com.google.protobuf", "protobuf-gradle-plugin", gradleVersion3);
        GradleVersion gradleVersion4 = GradleVersion.parse((String)"1.3.10");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion4, (String)"GradleVersion.parse(\"1.3.10\")");
        objectArray[3] = new DependencyInfo("Kotlin", "org.jetbrains.kotlin", "kotlin-gradle-plugin", gradleVersion4);
        pluginList = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ List access$getPluginList$p() {
        return pluginList;
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, EvalIssueReporter issueReporter) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, pluginInfo, issueReporter);
    }
}

