/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationVariantConfiguration;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    private final File projectDir;

    NdkBuildExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, Set<String> configurationFailures, AndroidBuilder androidBuilder, File projectDir2, GradleBuildVariant.Builder stats) {
        super(config2, configurationFailures, androidBuilder, stats);
        this.projectDir = projectDir2;
        this.stats.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        if (this.getMakefile().isDirectory()) {
            LoggingEnvironmentKt.error("Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", this.getMakefile());
        } else if (!this.getMakefile().exists()) {
            LoggingEnvironmentKt.error("Gradle project ndkBuild.path is %s but that file doesn't exist", this.getMakefile());
        }
    }

    @Override
    void processBuildOutput(String buildOutput, JsonGenerationAbiConfiguration abiConfig) throws IOException {
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        LoggingEnvironmentKt.info("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        NativeBuildConfigValue buildConfig = new NativeBuildConfigValueBuilder(this.getMakeFile(), this.projectDir).setCommands(this.getBuildCommand(abiConfig, applicationMk, false), this.getBuildCommand(abiConfig, applicationMk, true) + " clean", this.config.variantName, buildOutput).build();
        if (applicationMk.exists()) {
            LoggingEnvironmentKt.info("found application make file %s", applicationMk.getAbsolutePath());
            Preconditions.checkNotNull(buildConfig.buildFiles);
            buildConfig.buildFiles.add(applicationMk);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Files.write(abiConfig.getJsonFile().toPath(), actualResult.getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(JsonGenerationAbiConfiguration abiConfig) {
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getNdkBuild()).addArgs(this.getBaseArgs(abiConfig, applicationMk, false)).addArgs("APP_SHORT_COMMANDS=false").addArgs("LOCAL_SHORT_COMMANDS=false").addArgs("-B").addArgs("-n");
        return builder;
    }

    @Override
    String executeProcess(JsonGenerationAbiConfiguration abiConfig) throws ProcessException, IOException {
        return ProcessOutputJunctionKt.createProcessOutputJunction(abiConfig.getObjFolder(), "android_gradle_generate_ndk_build_json_" + abiConfig.getAbiName(), this.getProcessBuilder(abiConfig), this.androidBuilder, "").logStderrToInfo().executeAndReturnStdoutString();
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.NDK_BUILD;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        return Maps.newHashMap();
    }

    private String getNdkBuild() {
        String tool = "ndk-build";
        if (NdkBuildExternalNativeJsonGenerator.isWindows()) {
            tool = tool + ".cmd";
        }
        File toolFile = new File(this.getNdkFolder(), tool);
        try {
            return toolFile.getCanonicalPath();
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warn("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", e);
            return toolFile.getAbsolutePath();
        }
    }

    private File getMakeFile() {
        if (this.getMakefile().isDirectory()) {
            return new File(this.getMakefile(), "Android.mk");
        }
        return this.getMakefile();
    }

    private List<String> getBaseArgs(JsonGenerationAbiConfiguration abiConfig, File applicationMk, boolean removeJobsFlag) {
        ArrayList result = Lists.newArrayList();
        result.add("NDK_PROJECT_PATH=null");
        result.add("APP_BUILD_SCRIPT=" + this.getMakeFile());
        if (applicationMk.exists()) {
            result.add("NDK_APPLICATION_MK=" + applicationMk.getAbsolutePath());
        }
        result.add("APP_ABI=" + abiConfig.getAbiName());
        result.add("NDK_ALL_ABIS=" + abiConfig.getAbiName());
        if (this.isDebuggable()) {
            result.add("NDK_DEBUG=1");
        } else {
            result.add("NDK_DEBUG=0");
        }
        result.add("APP_PLATFORM=android-" + abiConfig.getAbiPlatformVersion());
        String ndkOut = this.getObjFolder().getParent();
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            ndkOut = ndkOut.replace('\\', '/');
        }
        result.add("NDK_OUT=" + ndkOut);
        result.add("NDK_LIBS_OUT=" + this.getSoFolder().getAbsolutePath());
        for (String flag : this.getcFlags()) {
            result.add(String.format("APP_CFLAGS+=%s", flag));
        }
        for (String flag : this.getCppFlags()) {
            result.add(String.format("APP_CPPFLAGS+=%s", flag));
        }
        boolean skipNextArgument = false;
        for (String argument : this.getBuildArguments()) {
            if (removeJobsFlag && argument.equals("-j")) {
                skipNextArgument = true;
                continue;
            }
            if (removeJobsFlag && argument.equals("--jobs")) {
                skipNextArgument = true;
                continue;
            }
            if (skipNextArgument) {
                skipNextArgument = false;
                continue;
            }
            if (removeJobsFlag && (argument.startsWith("-j") || argument.startsWith("--jobs="))) continue;
            result.add(argument);
        }
        return result;
    }

    private String getBuildCommand(JsonGenerationAbiConfiguration abiConfig, File applicationMk, boolean removeJobsFlag) {
        return this.getNdkBuild() + " " + Joiner.on((String)" ").join(this.getBaseArgs(abiConfig, applicationMk, removeJobsFlag));
    }
}

