/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkHandlerKt;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler;", "", "enableSideBySideNdk", "", "ndkVersionFromDsl", "", "compileSdkVersion", "projectDir", "Ljava/io/File;", "(ZLjava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "currentNdkPlatform", "Lcom/android/build/gradle/internal/ndk/NdkPlatform;", "ndkPlatform", "getNdkPlatform", "()Lcom/android/build/gradle/internal/ndk/NdkPlatform;", "sideBySideLocatorRecord", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "installFromSdk", "", "sdkLoader", "Lcom/android/builder/sdk/SdkLoader;", "sdkLibData", "Lcom/android/builder/sdk/SdkLibData;", "invalidateNdk", "writeNdkLocatorRecord", "file", "Companion", "gradle"})
public final class NdkHandler {
    private NdkPlatform currentNdkPlatform;
    private NdkLocatorRecord sideBySideLocatorRecord;
    private final boolean enableSideBySideNdk;
    private final String ndkVersionFromDsl;
    private final String compileSdkVersion;
    private final File projectDir;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final NdkPlatform getNdkPlatform() {
        NdkPlatform ndkPlatform;
        if (this.currentNdkPlatform != null) {
            ndkPlatform = this.currentNdkPlatform;
            if (ndkPlatform == null) {
                Intrinsics.throwNpe();
            }
        } else {
            File file;
            if (this.enableSideBySideNdk) {
                NdkLocatorRecord ndkLocatorRecord = this.sideBySideLocatorRecord = NdkLocatorKt.findNdkPath(this.ndkVersionFromDsl, this.projectDir);
                if (ndkLocatorRecord == null) {
                    Intrinsics.throwNpe();
                }
                file = ndkLocatorRecord.getNdkFolder();
            } else {
                file = NdkHandler.Companion.findNdkDirectory(this.projectDir);
            }
            File ndkDirectory2 = file;
            NdkInfo ndkInfo2 = null;
            Revision revision2 = null;
            if (ndkDirectory2 == null || !ndkDirectory2.exists()) {
                ndkInfo2 = null;
                revision2 = null;
            } else {
                revision2 = Companion.findRevision(ndkDirectory2);
                ndkInfo2 = revision2 == null ? (NdkInfo)new DefaultNdkInfo(ndkDirectory2) : (NdkInfo)new NdkR14Info(ndkDirectory2);
            }
            if ((ndkPlatform = (this.currentNdkPlatform = new NdkPlatform(ndkDirectory2, ndkInfo2, revision2, this.compileSdkVersion))) == null) {
                Intrinsics.throwNpe();
            }
        }
        return ndkPlatform;
    }

    private final void invalidateNdk() {
        this.currentNdkPlatform = null;
    }

    public final void installFromSdk(@NotNull SdkLoader sdkLoader, @NotNull SdkLibData sdkLibData) {
        Intrinsics.checkParameterIsNotNull((Object)sdkLoader, (String)"sdkLoader");
        Intrinsics.checkParameterIsNotNull((Object)sdkLibData, (String)"sdkLibData");
        try {
            if (this.enableSideBySideNdk) {
                sdkLoader.installSdkTool(sdkLibData, "ndk");
            } else {
                sdkLoader.installSdkTool(sdkLibData, "ndk-bundle");
            }
        }
        catch (LicenceNotAcceptedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (InstallFailedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        this.invalidateNdk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeNdkLocatorRecord(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.sideBySideLocatorRecord != null) {
            file.getParentFile().mkdirs();
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                NdkHandlerKt.getGSON().toJson((Object)this.sideBySideLocatorRecord, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public NdkHandler(boolean enableSideBySideNdk, @Nullable String ndkVersionFromDsl, @NotNull String compileSdkVersion, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)compileSdkVersion, (String)"compileSdkVersion");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        this.enableSideBySideNdk = enableSideBySideNdk;
        this.ndkVersionFromDsl = ndkVersionFromDsl;
        this.compileSdkVersion = compileSdkVersion;
        this.projectDir = projectDir;
    }

    @VisibleForTesting
    @JvmStatic
    @Nullable
    public static final Revision findRevision(@Nullable File ndkDirectory2) {
        return Companion.findRevision(ndkDirectory2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$Companion;", "", "()V", "checkNdkDir", "", "ndkDir", "Ljava/io/File;", "findNdkDirectory", "projectDir", "properties", "Ljava/util/Properties;", "findRevision", "Lcom/android/repository/Revision;", "ndkDirectory", "invalidNdkWarning", "", "message", "", "readProperties", "file", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Properties readProperties(File file) {
            Properties properties = new Properties();
            try {
                Closeable closeable = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                    Throwable throwable2 = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        boolean bl2 = false;
                        properties.load(reader);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Unable to read %1$s.";
                Object[] objectArray = new Object[]{file};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                Throwable throwable = e;
                String string4 = string3;
                throw (Throwable)new RuntimeException(string4, throwable);
            }
            return properties;
        }

        @VisibleForTesting
        @JvmStatic
        @Nullable
        public final Revision findRevision(@Nullable File ndkDirectory2) {
            if (ndkDirectory2 == null) {
                return null;
            }
            File sourceProperties = new File(ndkDirectory2, "source.properties");
            if (!sourceProperties.exists()) {
                return null;
            }
            Properties properties = this.readProperties(sourceProperties);
            String version = properties.getProperty("Pkg.Revision");
            return version != null ? Revision.parseRevision((String)version) : null;
        }

        private final File findNdkDirectory(File projectDir) {
            File localProperties2 = new File(projectDir, "local.properties");
            Properties properties = new Properties();
            if (localProperties2.isFile()) {
                properties = this.readProperties(localProperties2);
            }
            File file = this.findNdkDirectory(properties, projectDir);
            if (file == null) {
                return null;
            }
            File ndkDir = file;
            return this.checkNdkDir(ndkDir) ? ndkDir : null;
        }

        private final boolean checkNdkDir(File ndkDir) {
            if (!new File(ndkDir, "platforms").isDirectory()) {
                this.invalidNdkWarning("NDK is missing a \"platforms\" directory.", ndkDir);
                return false;
            }
            if (!new File(ndkDir, "toolchains").isDirectory()) {
                this.invalidNdkWarning("NDK is missing a \"toolchains\" directory.", ndkDir);
                return false;
            }
            return true;
        }

        private final void invalidNdkWarning(String message, File ndkDir) {
            Logging.getLogger(NdkHandler.class).warn("{}\nIf you are using NDK, verify the ndk.dir is set to a valid NDK directory.  It is currently set to {}.\nIf you are not using NDK, unset the NDK variable from ANDROID_NDK_HOME or local.properties to remove this warning.\n", (Object)message, (Object)ndkDir.getAbsolutePath());
        }

        private final File findNdkDirectory(Properties properties, File projectDir) {
            File ndkBundle;
            String ndkDirProp = properties.getProperty("ndk.dir");
            if (ndkDirProp != null) {
                return new File(ndkDirProp);
            }
            String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
            if (ndkEnvVar != null) {
                return new File(ndkEnvVar);
            }
            Pair<File, Boolean> pair = SdkHandler.findSdkLocation(properties, projectDir);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"SdkHandler.findSdkLocation(properties, projectDir)");
            Pair<File, Boolean> sdkLocation = pair;
            File sdkFolder2 = (File)sdkLocation.getFirst();
            if (sdkFolder2 != null && (ndkBundle = new File(sdkFolder2, "ndk-bundle")).isDirectory()) {
                return ndkBundle;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

