/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.KnownFilesSaveData;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.utils.FileCache;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.apkzlib.utils.IOExceptionWrapper;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Project;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

public abstract class PackageAndroidArtifact
extends IncrementalTask {
    protected InternalArtifactType manifestType;
    protected BuildableArtifact resourceFiles;
    protected FileCollection dexFolders;
    protected final ConfigurableFileCollection featureDexFolder;
    protected ListProperty<Directory> assets;
    protected FileCollection javaResourceFiles;
    protected FileCollection jniFolders;
    private Set<String> abiFilters;
    private boolean debugBuild;
    private boolean jniDebugBuild;
    private FileCollection signingConfig;
    protected Supplier<AndroidVersion> minSdkVersion;
    protected Provider<Directory> manifests;
    protected Collection<String> aaptOptionsNoCompress;
    protected OutputScope outputScope;
    protected String projectBaseName;
    protected String buildTargetAbi;
    protected String buildTargetDensity;
    protected File outputDirectory;
    protected OutputFileProvider outputFileProvider;
    private final WorkerExecutorFacade workers;
    protected FileCache fileCache;
    protected BuildableArtifact apkList;
    protected boolean keepTimestampsInApk;
    protected Integer targetApi;
    protected IncrementalPackagerBuilder.ApkFormat apkFormat;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    InternalArtifactType taskInputType;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public Provider<Directory> getManifests() {
        return this.manifests;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public BuildableArtifact getResourceFiles() {
        return this.resourceFiles;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters != null ? abiFilters : ImmutableSet.of();
    }

    @Input
    public InternalArtifactType getManifestType() {
        return this.manifestType;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getJavaResourceFiles() {
        return this.javaResourceFiles;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getDexFolders() {
        return this.dexFolders;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getFeatureDexFolder() {
        return this.featureDexFolder;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public ListProperty<Directory> getAssets() {
        return this.assets;
    }

    @Inject
    public PackageAndroidArtifact(ObjectFactory objectFactory, WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workerExecutor);
        this.featureDexFolder = objectFactory.fileCollection();
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    @Optional
    public Integer getTargetApi() {
        return this.targetApi;
    }

    @Input
    public boolean getKeepTimestampsInApk() {
        return this.keepTimestampsInApk;
    }

    @Input
    public String getApkFormat() {
        return this.apkFormat.name();
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public boolean getDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @InputFiles
    @Optional
    public FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(FileCollection signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.get().getApiLevel();
    }

    @Input
    public List<String> getNativeLibrariesAndDexPackagingModeName() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((Directory)this.manifests.get()).getAsFileTree().getFiles().forEach(manifest -> {
            if (manifest.isFile() && manifest.getName().equals("AndroidManifest.xml")) {
                String extractNativeLibs = PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifest, () -> true, (EvalIssueReporter)this.getBuilder().getIssueReporter()).toString();
                listBuilder.add((Object)extractNativeLibs);
                String useEmbeddedDex = PackagingUtils.getUseEmbeddedDex((File)manifest, () -> true, (EvalIssueReporter)this.getBuilder().getIssueReporter()).toString();
                listBuilder.add((Object)useEmbeddedDex);
            }
        });
        return listBuilder.build();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public InternalArtifactType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Collection<String> getApkNames() {
        return this.outputScope.getApkDatas().stream().filter(apkData -> apkData.getType() != VariantOutput.OutputType.SPLIT).map(ApkData::getOutputFileName).collect(Collectors.toList());
    }

    @InputFiles
    public BuildableArtifact getApkList() {
        return this.apkList;
    }

    private static BuildOutput computeBuildOutputFile(ApkData apkInfo, OutputFileProvider outputFileProvider, File outputDirectory, InternalArtifactType expectedOutputType) {
        File outputFile = outputFileProvider != null ? outputFileProvider.getOutputFile(apkInfo) : new File(outputDirectory, apkInfo.getOutputFileName());
        return new BuildOutput(expectedOutputType, apkInfo, outputFile);
    }

    protected abstract InternalArtifactType getInternalArtifactType();

    @Override
    protected void doFullTaskAction() {
        this.checkFileNameUniqueness();
        ArrayList inputList = new ArrayList();
        ArrayList outputList = new ArrayList();
        ExistingBuildElements.from((ArtifactType)this.getTaskInputType(), this.resourceFiles).transform(this.workers, FullActionSplitterRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, inputFile) -> {
            SplitterParams params = new SplitterParams((ApkData)apkInfo, (File)inputFile, this);
            inputList.add(inputFile);
            outputList.add(params.getOutput());
            return params;
        })).into(this.getInternalArtifactType(), this.outputDirectory);
        for (int i = 0; i < inputList.size(); ++i) {
            this.recordMetrics((File)outputList.get(i), (File)inputList.get(i));
        }
    }

    private void checkFileNameUniqueness() {
        BuildElements buildElements = ExistingBuildElements.from((ArtifactType)this.getTaskInputType(), this.resourceFiles);
        PackageAndroidArtifact.checkFileNameUniqueness(buildElements);
    }

    @VisibleForTesting
    static void checkFileNameUniqueness(BuildElements buildElements) {
        Collection fileOutputs = buildElements.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        java.util.Optional<String> repeatingFileNameOptional = fileOutputs.stream().filter(fileOutput -> Collections.frequency(fileOutputs, fileOutput) > 1).map(File::getName).findFirst();
        if (repeatingFileNameOptional.isPresent()) {
            String repeatingFileName = repeatingFileNameOptional.get();
            List conflictingApks = buildElements.stream().filter(buildOutput -> buildOutput.getOutputFile().getName().equals(repeatingFileName)).map(buildOutput -> {
                ApkData apkInfo = buildOutput.getApkData();
                if (apkInfo.getFilters().isEmpty()) {
                    return apkInfo.getType().toString();
                }
                return Joiner.on((String)"-").join(apkInfo.getFilters());
            }).collect(Collectors.toList());
            throw new RuntimeException(String.format("Several variant outputs are configured to use the same file name \"%1$s\", filters : %2$s", repeatingFileName, Joiner.on((String)":").join(conflictingApks)));
        }
    }

    abstract void recordMetrics(File var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries = inFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().endsWith(".class") || !ZipEntryUtils.isValidZipEntryName((ZipEntry)zipEntry)) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    private static ImmutableMap<RelativeFile, FileStatus> getJavaResourcesChanges(Iterable<File> javaResourceFiles, File incrementalFolder) throws IOException {
        ImmutableMap.Builder updatedJavaResourcesBuilder = ImmutableMap.builder();
        for (File javaResourceFile : javaResourceFiles) {
            try {
                updatedJavaResourcesBuilder.putAll((Map)(javaResourceFile.isFile() ? IncrementalRelativeFileSets.fromZip((File)javaResourceFile) : IncrementalRelativeFileSets.fromDirectory((File)javaResourceFile)));
            }
            catch (Zip64NotSupportedException e) {
                updatedJavaResourcesBuilder.putAll((Map)IncrementalRelativeFileSets.fromZip((File)PackageAndroidArtifact.copyJavaResourcesOnly(incrementalFolder, javaResourceFile)));
            }
        }
        return updatedJavaResourcesBuilder.build();
    }

    private static void doTask(File incrementalDirForSplit, File outputFile, FileCacheByPath cacheByPath, BuildElements manifestOutputs, ImmutableMap<RelativeFile, FileStatus> changedDex, ImmutableMap<RelativeFile, FileStatus> changedJavaResources, ImmutableMap<RelativeFile, FileStatus> changedAssets, ImmutableMap<RelativeFile, FileStatus> changedAndroidResources, ImmutableMap<RelativeFile, FileStatus> changedNLibs, SplitterParams params, boolean isIncremental) throws IOException {
        BuildOutput manifestForSplit;
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        ImmutableMap<RelativeFile, FileStatus> dexFilesToPackage = changedDex;
        String filter = null;
        FilterData abiFilter = params.apkInfo.getFilter(VariantOutput.FilterType.ABI);
        if (abiFilter != null) {
            filter = abiFilter.getIdentifier();
        }
        if ((manifestForSplit = manifestOutputs.element(params.apkInfo)) == null) {
            throw new RuntimeException("Found a .ap_ for split " + params.apkInfo + " but no " + (Object)((Object)params.manifestType) + " associated manifest file");
        }
        FileUtils.mkdirs((File)outputFile.getParentFile());
        BooleanSupplier isInExecutionPhase = () -> true;
        IncrementalPackagerBuilder.BuildType buildType = isIncremental ? IncrementalPackagerBuilder.BuildType.INCREMENTAL : IncrementalPackagerBuilder.BuildType.CLEAN;
        try (IncrementalPackager packager = new IncrementalPackagerBuilder(params.apkFormat, buildType).withOutputFile(outputFile).withSigning(SigningConfigMetadata.Companion.load(params.signingConfig), params.minSdkVersion, params.targetApi).withCreatedBy(params.createdBy).withNativeLibraryPackagingMode(PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifestForSplit.getOutputFile(), (BooleanSupplier)isInExecutionPhase, null)).withNoCompressPredicate(PackagingUtils.getNoCompressPredicate(params.aaptOptionsNoCompress, (File)manifestForSplit.getOutputFile(), (BooleanSupplier)isInExecutionPhase, null)).withIntermediateDir(incrementalDirForSplit).withKeepTimestampsInApk(params.keepTimestampsInApk).withDebuggableBuild(params.isDebuggableBuild).withAcceptedAbis((Set<String>)(filter == null ? params.abiFilters : ImmutableSet.of((Object)filter))).withJniDebuggableBuild(params.isJniDebuggableBuild).build();){
            packager.updateDex(dexFilesToPackage);
            packager.updateJavaResources(changedJavaResources);
            packager.updateAssets(changedAssets);
            packager.updateAndroidResources(changedAndroidResources);
            packager.updateNativeLibraries(changedNLibs);
        }
        Stream.concat(dexFilesToPackage.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).map(RelativeFile::getBase).filter(File::isFile).distinct().forEach(f -> {
            try {
                cacheByPath.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) {
        Preconditions.checkNotNull(changedInputs, (Object)"changedInputs == null");
        ExistingBuildElements.from((ArtifactType)this.getTaskInputType(), this.resourceFiles).transform(this.workers, IncrementalSplitterRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, inputFile) -> new IncrementalSplitterParams((ApkData)apkInfo, (File)inputFile, changedInputs, this))).into(this.getInternalArtifactType(), this.outputDirectory);
    }

    public static abstract class CreationAction<T extends PackageAndroidArtifact>
    extends VariantTaskCreationAction<T> {
        protected final Project project;
        protected final Provider<Directory> manifests;
        protected final InternalArtifactType inputResourceFilesType;
        protected final File outputDirectory;
        protected final OutputScope outputScope;
        private final FileCache fileCache;
        private final InternalArtifactType manifestType;

        public CreationAction(VariantScope variantScope, File outputDirectory, InternalArtifactType inputResourceFilesType, Provider<Directory> manifests, InternalArtifactType manifestType, FileCache fileCache, OutputScope outputScope) {
            super(variantScope);
            this.project = variantScope.getGlobalScope().getProject();
            this.inputResourceFilesType = inputResourceFilesType;
            this.manifests = manifests;
            this.outputDirectory = outputDirectory;
            this.outputScope = outputScope;
            this.manifestType = manifestType;
            this.fileCache = fileCache;
        }

        @Override
        public void configure(T packageAndroidArtifact) {
            super.configure(packageAndroidArtifact);
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
            ((PackageAndroidArtifact)packageAndroidArtifact).taskInputType = this.inputResourceFilesType;
            ((PackageAndroidArtifact)packageAndroidArtifact).minSdkVersion = TaskInputHelper.memoize(variantScope::getMinSdkVersion);
            ((PackageAndroidArtifact)packageAndroidArtifact).resourceFiles = variantScope.getArtifacts().getFinalArtifactFiles(this.inputResourceFilesType);
            ((PackageAndroidArtifact)packageAndroidArtifact).outputDirectory = this.outputDirectory;
            ((IncrementalTask)packageAndroidArtifact).setIncrementalFolder(new File(variantScope.getIncrementalDir(packageAndroidArtifact.getName()), "tmp"));
            ((PackageAndroidArtifact)packageAndroidArtifact).outputScope = this.outputScope;
            ((PackageAndroidArtifact)packageAndroidArtifact).fileCache = this.fileCache;
            ((PackageAndroidArtifact)packageAndroidArtifact).aaptOptionsNoCompress = DslAdaptersKt.convert(globalScope.getExtension().getAaptOptions()).getNoCompress();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifests = this.manifests;
            ((PackageAndroidArtifact)packageAndroidArtifact).dexFolders = this.getDexFolders();
            FileCollection featureDexFolder = this.getFeatureDexFolder();
            if (featureDexFolder != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).featureDexFolder.from(new Object[]{featureDexFolder});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).javaResourceFiles = this.getJavaResources();
            ((PackageAndroidArtifact)packageAndroidArtifact).assets = variantScope.getArtifacts().getFinalProducts(InternalArtifactType.MERGED_ASSETS);
            ((PackageAndroidArtifact)packageAndroidArtifact).setJniDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isJniDebuggable());
            ((PackageAndroidArtifact)packageAndroidArtifact).setDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            ProjectOptions projectOptions = variantScope.getGlobalScope().getProjectOptions();
            ((PackageAndroidArtifact)packageAndroidArtifact).projectBaseName = globalScope.getProjectBaseName();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifestType = this.manifestType;
            String string = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetAbi = globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            if (variantConfiguration.getSupportedAbis() != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).setAbiFilters(variantConfiguration.getSupportedAbis());
            } else {
                ((PackageAndroidArtifact)packageAndroidArtifact).setAbiFilters(projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? this.firstValidInjectedAbi(projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) : null);
            }
            String string2 = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetDensity = globalScope.getExtension().getSplits().getDensity().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY) : null;
            ((PackageAndroidArtifact)packageAndroidArtifact).apkFormat = projectOptions.get(BooleanOption.DEPLOYMENT_USES_DIRECTORY) ? IncrementalPackagerBuilder.ApkFormat.DIRECTORY : (projectOptions.get(BooleanOption.DEPLOYMENT_PROVIDES_LIST_OF_CHANGES) ? IncrementalPackagerBuilder.ApkFormat.FILE_WITH_LIST_OF_CHANGES : IncrementalPackagerBuilder.ApkFormat.FILE);
            ((PackageAndroidArtifact)packageAndroidArtifact).keepTimestampsInApk = variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.KEEP_TIMESTAMPS_IN_APK);
            ((PackageAndroidArtifact)packageAndroidArtifact).targetApi = projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API);
            this.finalConfigure(packageAndroidArtifact);
        }

        protected void finalConfigure(T task) {
            ImmutableSet<String> filters;
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            ((PackageAndroidArtifact)task).dexFolders = this.getDexFolders();
            ((PackageAndroidArtifact)task).jniFolders = variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.MULTI_APK ? this.getJniFolders() : ((filters = AbiSplitOptions.getAbiFilters(globalScope.getExtension().getSplits().getAbiFilters())).isEmpty() ? this.getJniFolders() : this.project.files(new Object[0]));
            ((PackageAndroidArtifact)task).apkList = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            ((PackageAndroidArtifact)task).setSigningConfig(variantScope.getSigningConfigFileCollection());
        }

        public FileCollection getDexFolders() {
            return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
        }

        public FileCollection getJavaResources() {
            if (this.getVariantScope().getNeedsMergedJavaResStream()) {
                return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            }
            Provider mergedJavaResProvider = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.MERGED_JAVA_RES);
            return this.project.getLayout().files(new Object[]{mergedJavaResProvider});
        }

        public FileCollection getJniFolders() {
            return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
        }

        public FileCollection getFeatureDexFolder() {
            if (!this.getVariantScope().getType().isFeatureSplit()) {
                return null;
            }
            return this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)this.project.getPath()));
        }

        private Set<String> firstValidInjectedAbi(String abis) {
            if (abis == null) {
                return null;
            }
            Set allowedAbis = Abi.getDefaultValues().stream().map(Abi::getTag).collect(Collectors.toSet());
            java.util.Optional<String> firstValidAbi = Arrays.asList(abis.split(",")).stream().map(abi -> abi.trim()).filter(abi -> allowedAbis.contains(abi)).findFirst();
            return firstValidAbi.isPresent() ? ImmutableSet.of((Object)firstValidAbi.get()) : null;
        }
    }

    private static class IncrementalSplitterParams
    extends SplitterParams {
        private final Map<File, FileStatus> changedInputs;

        IncrementalSplitterParams(ApkData apkInfo, File processedResources, Map<File, FileStatus> changedInputs, PackageAndroidArtifact task) {
            super(apkInfo, processedResources, task);
            this.changedInputs = changedInputs;
        }
    }

    private static class IncrementalSplitterRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public IncrementalSplitterRunnable(IncrementalSplitterParams params) {
            super(params);
        }

        @Override
        public void run() {
            IncrementalSplitterParams params = (IncrementalSplitterParams)this.getParams();
            try {
                ImmutableMap<RelativeFile, FileStatus> changedJavaResources;
                Object javaResourceFiles;
                Set dexFiles;
                File incrementalDirForSplit = new File(params.incrementalFolder, params.apkInfo.getFullName());
                File cacheByPathDir = new File(incrementalDirForSplit, PackageAndroidArtifact.ZIP_DIFF_CACHE_DIR);
                if (!cacheByPathDir.exists()) {
                    FileUtils.mkdirs((File)cacheByPathDir);
                }
                FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
                KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
                HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
                if (params.featureDexFiles.isEmpty()) {
                    dexFiles = params.dexFiles;
                    javaResourceFiles = params.javaResourceFiles;
                } else {
                    dexFiles = params.featureDexFiles;
                    javaResourceFiles = ImmutableSet.of();
                }
                ImmutableMap<RelativeFile, FileStatus> changedDexFiles = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)params.changedInputs, saveData, KnownFilesSaveData.InputSet.DEX, dexFiles, cacheByPath, cacheUpdates);
                try {
                    changedJavaResources = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)params.changedInputs, saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, (Collection<File>)javaResourceFiles, cacheByPath, cacheUpdates);
                }
                catch (Zip64NotSupportedException e) {
                    ImmutableMap.Builder copiedInputs = ImmutableMap.builder();
                    for (Map.Entry fileFileStatusEntry : params.changedInputs.entrySet()) {
                        copiedInputs.put((Object)PackageAndroidArtifact.copyJavaResourcesOnly(params.incrementalFolder, (File)fileFileStatusEntry.getKey()), fileFileStatusEntry.getValue());
                    }
                    changedJavaResources = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)copiedInputs.build(), saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, params.javaResourceFiles, cacheByPath, cacheUpdates);
                }
                ImmutableMap<RelativeFile, FileStatus> changedAssets = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)params.changedInputs, saveData, KnownFilesSaveData.InputSet.ASSET, params.assetsFiles, cacheByPath, cacheUpdates);
                ZipCentralDirectory androidResCentralDirectory = new ZipCentralDirectory(params.processedResources);
                ImmutableMap<RelativeFile, FileStatus> changedAndroidResources = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)params.changedInputs, saveData, KnownFilesSaveData.InputSet.ANDROID_RESOURCE, androidResCentralDirectory, cacheByPath, cacheUpdates);
                ImmutableMap<RelativeFile, FileStatus> changedNLibs = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)params.changedInputs, saveData, KnownFilesSaveData.InputSet.NATIVE_RESOURCE, params.jniFiles, cacheByPath, cacheUpdates);
                BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)params.manifestType, params.manifestDirectory);
                PackageAndroidArtifact.doTask(incrementalDirForSplit, params.getOutput(), cacheByPath, manifestOutputs, (ImmutableMap<RelativeFile, FileStatus>)changedDexFiles, (ImmutableMap<RelativeFile, FileStatus>)changedJavaResources, (ImmutableMap<RelativeFile, FileStatus>)changedAssets, (ImmutableMap<RelativeFile, FileStatus>)changedAndroidResources, (ImmutableMap<RelativeFile, FileStatus>)changedNLibs, params, true);
                cacheUpdates.forEach(Runnable::run);
                ImmutableMap allDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.dexFiles);
                ImmutableMap allJavaResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.javaResourceFiles);
                ImmutableMap allAssets = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.assetsFiles);
                ImmutableMap allAndroidResources = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)androidResCentralDirectory);
                ImmutableMap allJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.jniFiles);
                saveData.setInputSet((Collection<RelativeFile>)allDex.keySet(), KnownFilesSaveData.InputSet.DEX);
                saveData.setInputSet((Collection<RelativeFile>)allJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
                saveData.setInputSet((Collection<RelativeFile>)allAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
                saveData.setInputSet((Collection<RelativeFile>)allAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
                saveData.setInputSet((Collection<RelativeFile>)allJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
                saveData.saveCurrentData();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class SplitterParams
    extends BuildElementsTransformParams {
        ApkData apkInfo;
        File processedResources;
        protected final File outputFile;
        protected final File incrementalFolder;
        protected final Set<File> dexFiles;
        protected final Set<File> featureDexFiles;
        protected final Set<File> assetsFiles;
        protected final Set<File> jniFiles;
        protected final Set<File> javaResourceFiles;
        protected final InternalArtifactType manifestType;
        protected final IncrementalPackagerBuilder.ApkFormat apkFormat;
        protected final File signingConfig;
        protected final Set<String> abiFilters;
        protected final File manifestDirectory;
        protected final Collection<String> aaptOptionsNoCompress;
        protected final String createdBy;
        protected final int minSdkVersion;
        protected final boolean isDebuggableBuild;
        protected final boolean isJniDebuggableBuild;
        protected final boolean keepTimestampsInApk;
        protected final Integer targetApi;

        SplitterParams(ApkData apkInfo, File processedResources, PackageAndroidArtifact task) {
            this.apkInfo = apkInfo;
            this.processedResources = processedResources;
            this.outputFile = PackageAndroidArtifact.computeBuildOutputFile(apkInfo, task.outputFileProvider, task.outputDirectory, task.getInternalArtifactType()).getOutputFile();
            this.incrementalFolder = task.getIncrementalFolder();
            this.dexFiles = task.getDexFolders().getFiles();
            this.featureDexFiles = task.getFeatureDexFolder().getFiles();
            this.assetsFiles = ((List)task.getAssets().get()).stream().map(it -> it.getAsFile()).collect(Collectors.toCollection(LinkedHashSet::new));
            this.jniFiles = task.getJniFolders().getFiles();
            this.javaResourceFiles = task.getJavaResourceFiles().getFiles();
            this.manifestType = task.getManifestType();
            this.apkFormat = task.apkFormat;
            this.signingConfig = SigningConfigMetadata.Companion.getOutputFile(task.signingConfig);
            this.abiFilters = task.abiFilters;
            this.manifestDirectory = ((Directory)task.getManifests().get()).getAsFile();
            this.aaptOptionsNoCompress = task.aaptOptionsNoCompress;
            this.createdBy = task.getBuilder().getCreatedBy();
            this.minSdkVersion = task.getMinSdkVersion();
            this.isDebuggableBuild = task.getDebugBuild();
            this.isJniDebuggableBuild = task.getJniDebugBuild();
            this.keepTimestampsInApk = task.getKeepTimestampsInApk();
            this.targetApi = task.getTargetApi();
        }

        @Override
        public File getOutput() {
            return this.outputFile;
        }
    }

    private static class FullActionSplitterRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public FullActionSplitterRunnable(SplitterParams params) {
            super(params);
        }

        @Override
        public void run() {
            try {
                ImmutableMap updatedJavaResources;
                ImmutableMap updatedDex;
                SplitterParams params = (SplitterParams)this.getParams();
                FileUtils.mkdirs((File)params.getOutput().getParentFile());
                File incrementalDirForSplit = new File(params.incrementalFolder, params.apkInfo.getFullName());
                if (incrementalDirForSplit.exists()) {
                    FileUtils.deleteDirectoryContents((File)incrementalDirForSplit);
                } else {
                    FileUtils.mkdirs((File)incrementalDirForSplit);
                }
                File cacheByPathDir = new File(incrementalDirForSplit, PackageAndroidArtifact.ZIP_DIFF_CACHE_DIR);
                FileUtils.mkdirs((File)cacheByPathDir);
                FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
                cacheByPath.clear();
                FileUtils.deleteRecursivelyIfExists((File)params.getOutput());
                if (params.featureDexFiles.isEmpty()) {
                    updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories(params.dexFiles);
                    updatedJavaResources = PackageAndroidArtifact.getJavaResourcesChanges(params.javaResourceFiles, params.incrementalFolder);
                } else {
                    updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories(params.featureDexFiles);
                    updatedJavaResources = ImmutableMap.of();
                }
                ImmutableMap updatedAssets = IncrementalRelativeFileSets.fromZipsAndDirectories(params.assetsFiles);
                ImmutableMap updatedJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories(params.jniFiles);
                ImmutableMap updatedAndroidResources = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)new ZipCentralDirectory(params.processedResources));
                BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)params.manifestType, params.manifestDirectory);
                PackageAndroidArtifact.doTask(incrementalDirForSplit, params.getOutput(), cacheByPath, manifestOutputs, (ImmutableMap<RelativeFile, FileStatus>)updatedDex, (ImmutableMap<RelativeFile, FileStatus>)updatedJavaResources, (ImmutableMap<RelativeFile, FileStatus>)updatedAssets, (ImmutableMap<RelativeFile, FileStatus>)updatedAndroidResources, (ImmutableMap<RelativeFile, FileStatus>)updatedJniResources, params, false);
                KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
                saveData.setInputSet((Collection<RelativeFile>)updatedDex.keySet(), KnownFilesSaveData.InputSet.DEX);
                saveData.setInputSet((Collection<RelativeFile>)updatedJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
                saveData.setInputSet((Collection<RelativeFile>)updatedAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
                saveData.setInputSet((Collection<RelativeFile>)updatedAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
                saveData.setInputSet((Collection<RelativeFile>)updatedJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
                saveData.saveCurrentData();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static interface OutputFileProvider {
        public File getOutputFile(ApkData var1);
    }
}

