/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.GradleBuildLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.utils.ILogger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Ljava/lang/AutoCloseable;", "()V", "close", "", "error", "message", "", "info", "warn", "Companion", "gradle"})
public abstract class ThreadLoggingEnvironment
implements AutoCloseable {
    private static final ThreadLocal<List<ThreadLoggingEnvironment>> loggerStack;
    private static final GradleBuildLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;
    public static final Companion Companion;

    public abstract void error(@NotNull String var1);

    public abstract void warn(@NotNull String var1);

    public abstract void info(@NotNull String var1);

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    static {
        Companion = new Companion(null);
        loggerStack = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        Logger logger = Logging.getLogger(GradleBuildLoggingEnvironment.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Gradle\u2026gEnvironment::class.java)");
        BOTTOM_LOGGING_ENVIRONMENT = new GradleBuildLoggingEnvironment(logger, null, 2, null);
    }

    @JvmStatic
    @NotNull
    protected static final ThreadLoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0005J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bRJ\u0010\t\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b \f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "()V", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/GradleBuildLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "getILogger", "Lcom/android/utils/ILogger;", "parentLogger", "pop", "push", "", "reportFormattedErrorToCurrentLogger", "message", "", "reportFormattedInfoToCurrentLogger", "reportFormattedWarningToCurrentLogger", "gradle"})
    public static final class Companion {
        private final ThreadLoggingEnvironment getLogger() {
            Object t = loggerStack.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"loggerStack.get()");
            ThreadLoggingEnvironment threadLoggingEnvironment = (ThreadLoggingEnvironment)CollectionsKt.firstOrNull((List)((List)t));
            if (threadLoggingEnvironment == null) {
                threadLoggingEnvironment = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return threadLoggingEnvironment;
        }

        private final void push(ThreadLoggingEnvironment logger) {
            ((List)loggerStack.get()).add(0, logger);
        }

        private final ThreadLoggingEnvironment pop() {
            return (ThreadLoggingEnvironment)((List)loggerStack.get()).remove(0);
        }

        @JvmStatic
        @NotNull
        protected final ThreadLoggingEnvironment parentLogger() {
            return (ThreadLoggingEnvironment)((List)loggerStack.get()).get(1);
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().error(message);
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().warn(message);
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().info(message);
        }

        @NotNull
        public final ILogger getILogger() {
            return new ILogger(){

                public void error(@Nullable Throwable t, @Nullable String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    if (t != null) {
                        throw t;
                    }
                    ThreadLoggingEnvironment threadLoggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion);
                    String string = format;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    threadLoggingEnvironment.error(LoggingEnvironmentKt.access$checkedFormat(string, args2));
                }

                public void warning(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).warn(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }

                public void info(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).info(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }

                public void verbose(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).info(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ ThreadLoggingEnvironment access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

