/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.EvalIssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u001e\u001a\u00020\f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl;", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "projectPath", "", "(Lcom/android/builder/errors/EvalIssueReporter;Lcom/android/build/gradle/options/ProjectOptions;Ljava/lang/String;)V", "suppressedOptionWarnings", "", "reportDeprecatedApi", "", "newApiElement", "oldApiElement", "url", "deprecationTarget", "Lcom/android/build/gradle/internal/errors/DeprecationReporter$DeprecationTarget;", "reportDeprecatedConfiguration", "newDslElement", "oldConfiguration", "reportDeprecatedOption", "option", "value", "reportDeprecatedUsage", "oldDslElement", "reportDeprecatedValue", "dslElement", "oldValue", "newValue", "reportExperimentalOption", "Lcom/android/build/gradle/options/Option;", "reportObsoleteUsage", "reportRenamedConfiguration", "newConfiguration", "Companion", "gradle"})
public final class DeprecationReporterImpl
implements DeprecationReporter {
    private final Set<String> suppressedOptionWarnings;
    private final EvalIssueReporter issueReporter;
    private final ProjectOptions projectOptions;
    private final String projectPath;
    private static final Set<String> obsoleteApis;
    public static final Companion Companion;

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.', oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.', oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportDeprecatedApi(@NotNull String newApiElement, @NotNull String oldApiElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newApiElement, (String)"newApiElement");
        Intrinsics.checkParameterIsNotNull((Object)oldApiElement, (String)"oldApiElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (!Companion.checkAndSet(oldApiElement)) {
            boolean debugApi = this.projectOptions.get(BooleanOption.DEBUG_OBSOLETE_API);
            String messageStart = "API '" + oldApiElement + "' is obsolete and has been replaced with '" + newApiElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.';
            String messageEnd = "";
            if (debugApi) {
                String string;
                Object[] $this$filterTo$iv$iv;
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                Object[] traces = thread.getStackTrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)traces, (String)"traces");
                Object $this$filter$iv = traces;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                void var15_17 = $this$filterTo$iv$iv;
                int n = ((void)var15_17).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var15_17[i];
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string2 = v1.getClassName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.className");
                    if (!StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin.gradle.plugin.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List kotlin = (List)destination$iv$iv;
                $this$filter$iv = kotlin;
                StringBuilder stringBuilder = new StringBuilder();
                $i$f$filter = false;
                boolean bl = !$this$filter$iv.isEmpty();
                StringBuilder stringBuilder2 = stringBuilder;
                if (bl) {
                    string = "REASON: The Kotlin plugin is currently calling this API. We are working to solve this.";
                } else {
                    String gradleFile2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])traces), (Function1)reportDeprecatedApi.gradleFile.1.INSTANCE), (Function1)reportDeprecatedApi.gradleFile.2.INSTANCE));
                    if (gradleFile2 != null) {
                        string = "REASON: Called from: " + gradleFile2;
                    } else {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        $this$filterTo$iv$iv = traces;
                        stringBuilder = stringBuilder2;
                        boolean $i$f$map = false;
                        void $i$f$filterTo2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        void var17_20 = $this$mapTo$iv$iv;
                        int n2 = ((void)var17_20).length;
                        for (int i = 0; i < n2; ++i) {
                            void it;
                            void item$iv$iv;
                            void var21_32 = item$iv$iv = var17_20[i];
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            StringBuilder stringBuilder3 = new StringBuilder();
                            void v6 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                            String string3 = stringBuilder3.append(v6.getClassName()).append('.').append(it.getMethodName()).append('(').append(it.getFileName()).append(':').append(it.getLineNumber()).append(")\n").toString();
                            collection.add(string3);
                        }
                        List list = (List)destination$iv$iv2;
                        stringBuilder2 = stringBuilder;
                        List formattedTraces = list;
                        string = "REASON: It is currently called from the following trace:\n" + CollectionsKt.joinToString$default((Iterable)formattedTraces, (CharSequence)"", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
                    }
                }
                messageEnd = stringBuilder2.append(string).append("\nWARNING: Debugging obsolete API calls can take time during configuration. It's recommended to not keep it on at all times.").toString();
            } else {
                messageEnd = "To determine what is calling " + oldApiElement + ", use -P" + BooleanOption.DEBUG_OBSOLETE_API.getPropertyName() + "=true on the command line to display more information.";
            }
            this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, messageStart + '\n' + messageEnd);
        }
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime() + '.', oldDslElement + "::::" + deprecationTarget.name());
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime() + ".\n" + "For more information, see " + url + '.', oldDslElement + "::::" + deprecationTarget.name());
    }

    @Override
    public void reportRenamedConfiguration(@NotNull String newConfiguration, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget, @Nullable String url) {
        Intrinsics.checkParameterIsNotNull((Object)newConfiguration, (String)"newConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        String msg = "Configuration '" + oldConfiguration + "' is obsolete and has been replaced with '" + newConfiguration + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.';
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_CONFIGURATION, EvalIssueReporter.Severity.WARNING, url != null ? msg + " For more information see: " + url : msg, oldConfiguration + "::" + newConfiguration + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedConfiguration(@NotNull String newDslElement, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_CONFIGURATION, EvalIssueReporter.Severity.WARNING, "Configuration '" + oldConfiguration + "' is obsolete and has been replaced with DSL element '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '.', oldConfiguration + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedValue(@NotNull String dslElement, @NotNull String oldValue, @Nullable String newValue, @Nullable String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)dslElement, (String)"dslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL_VALUE, EvalIssueReporter.Severity.WARNING, "DSL element '" + dslElement + "' has a value '" + oldValue + "' which is obsolete " + (newValue != null ? "and has been replaced with '" + newValue + "'.\n" : "and has not been replaced.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + ".\n"), url);
    }

    @Override
    public void reportDeprecatedOption(@NotNull String option, @Nullable String value, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (this.suppressedOptionWarnings.contains(option)) {
            return;
        }
        this.issueReporter.reportIssue(EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, EvalIssueReporter.Severity.WARNING, "The option '" + option + "' is deprecated and should not be used anymore.\n" + (value != null ? "Use '" + option + '=' + value + "' to remove this warning.\n" : "") + "It will be removed " + deprecationTarget.getRemovalTime() + '.');
    }

    @Override
    public void reportExperimentalOption(@NotNull Option<?> option, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.suppressedOptionWarnings.contains(option.getPropertyName())) {
            return;
        }
        this.issueReporter.reportIssue(EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, EvalIssueReporter.Severity.WARNING, "The option setting '" + option.getPropertyName() + '=' + value + "' is experimental and unsupported.\n" + (option.getDefaultValue() != null ? "The current default is '" + String.valueOf(option.getDefaultValue()) + "'.\n" : "") + option.getAdditionalInfo(), option.getPropertyName());
    }

    public DeprecationReporterImpl(@NotNull EvalIssueReporter issueReporter, @NotNull ProjectOptions projectOptions, @NotNull String projectPath2) {
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)projectPath2, (String)"projectPath");
        this.issueReporter = issueReporter;
        this.projectOptions = projectOptions;
        this.projectPath = projectPath2;
        DeprecationReporterImpl deprecationReporterImpl = this;
        Object object = this.projectOptions.get(StringOption.SUPPRESS_UNSUPPORTED_OPTION_WARNINGS);
        if (object == null || (object = StringsKt.splitToSequence$default((CharSequence)((CharSequence)object), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)) == null || (object = SequencesKt.toSet((Sequence)object)) == null) {
            DeprecationReporterImpl deprecationReporterImpl2 = deprecationReporterImpl;
            boolean bl = false;
            Set set = SetsKt.emptySet();
            deprecationReporterImpl = deprecationReporterImpl2;
            object = set;
        }
        deprecationReporterImpl.suppressedOptionWarnings = object;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        obsoleteApis = new LinkedHashSet();
    }

    @Override
    public void reportDeprecatedOptions(@NotNull Set<? extends Option<?>> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        DeprecationReporter.DefaultImpls.reportDeprecatedOptions(this, options);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl$Companion;", "", "()V", "obsoleteApis", "", "", "checkAndSet", "", "api", "clean", "", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkAndSet(@NotNull String api) {
            Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
            Set set = obsoleteApis;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3;
                boolean bl4 = false;
                if (obsoleteApis.contains(api)) {
                    bl3 = true;
                } else {
                    obsoleteApis.add(api);
                    bl3 = false;
                }
                boolean bl5 = bl3;
                return bl5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clean() {
            Set set = obsoleteApis;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                obsoleteApis.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

