/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.internal.FeatureModelBuilder;
import com.android.build.gradle.internal.SdkComponents;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.api.sourcesets.FilesProvider;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalBuildArtifactsHolder;
import com.android.build.gradle.internal.scope.TransformGlobalScope;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.process.ProcessExecutor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope
implements TransformGlobalScope {
    private final Project project;
    private final FilesProvider filesProvider;
    private final AndroidBuilder androidBuilder;
    private AndroidConfig extension;
    private final SdkComponents sdkComponents;
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final ProjectOptions projectOptions;
    private final FileCache buildCache;
    private final DslScope dslScope;
    private Configuration lintChecks;
    private Configuration lintPublish;
    private Configuration androidJarConfig;
    private final BuildArtifactsHolder globalArtifacts;
    private ConfigurableFileCollection bootClasspath = null;

    public GlobalScope(Project project, FilesProvider filesProvider, ProjectOptions projectOptions, DslScope dslScope, AndroidBuilder androidBuilder, SdkComponents sdkComponents, ToolingModelBuilderRegistry toolingRegistry, FileCache buildCache) {
        this.project = (Project)Preconditions.checkNotNull((Object)project);
        this.dslScope = (DslScope)Preconditions.checkNotNull((Object)dslScope);
        this.filesProvider = filesProvider;
        this.androidBuilder = (AndroidBuilder)Preconditions.checkNotNull((Object)androidBuilder);
        this.sdkComponents = (SdkComponents)Preconditions.checkNotNull((Object)sdkComponents);
        this.toolingRegistry = (ToolingModelBuilderRegistry)Preconditions.checkNotNull((Object)toolingRegistry);
        this.optionalCompilationSteps = (Set)Preconditions.checkNotNull(projectOptions.getOptionalCompilationSteps());
        this.projectOptions = (ProjectOptions)Preconditions.checkNotNull((Object)projectOptions);
        this.buildCache = buildCache;
        this.globalArtifacts = new GlobalBuildArtifactsHolder(project, (Function0<? extends File>)((Function0)this::getBuildDir), dslScope);
        this.lintChecks = project.getConfigurations().detachedConfiguration(new Dependency[0]);
    }

    public void setExtension(AndroidConfig extension) {
        this.extension = (AndroidConfig)Preconditions.checkNotNull((Object)extension);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public FilesProvider getFilesProvider() {
        return this.filesProvider;
    }

    public AndroidConfig getExtension() {
        return this.extension;
    }

    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.androidBuilder.getProcessExecutor();
    }

    public String getProjectBaseName() {
        return (String)this.project.property("archivesBaseName");
    }

    public SdkComponents getSdkComponents() {
        return this.sdkComponents;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    @Override
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    public File getGeneratedDir() {
        return new File(this.getBuildDir(), "generated");
    }

    public File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    public File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    @Override
    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public String getArchivesBaseName() {
        return (String)this.getProject().getProperties().get("archivesBaseName");
    }

    public File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    public File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    @Override
    public ProjectOptions getProjectOptions() {
        return this.projectOptions;
    }

    @Override
    public FileCache getBuildCache() {
        return this.buildCache;
    }

    public void setLintChecks(Configuration lintChecks) {
        this.lintChecks = lintChecks;
    }

    public void setLintPublish(Configuration lintPublish) {
        this.lintPublish = lintPublish;
    }

    public void setAndroidJarConfig(Configuration androidJarConfig) {
        this.androidJarConfig = androidJarConfig;
    }

    public FileCollection getMockableJarArtifact() {
        return this.getMockableJarArtifact(this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues());
    }

    public FileCollection getMockableJarArtifact(boolean returnDefaultValues) {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-mockable-jar").attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)returnDefaultValues);
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPlatformAttrs() {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-platform-attr");
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public SyncIssueHandler getErrorHandler() {
        return (SyncIssueHandler)this.androidBuilder.getIssueReporter();
    }

    public DslScope getDslScope() {
        return this.dslScope;
    }

    public MessageReceiver getMessageReceiver() {
        return this.androidBuilder.getMessageReceiver();
    }

    public FileCollection getLocalCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintChecks.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPublishedCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintPublish.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public BuildArtifactsHolder getArtifacts() {
        return this.globalArtifacts;
    }

    public boolean hasDynamicFeatures() {
        AndroidConfig extension = this.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            return !((BaseAppModuleExtension)extension).getDynamicFeatures().isEmpty();
        }
        if (extension instanceof FeatureExtension) {
            return !FeatureModelBuilder.getDynamicFeatures(this).isEmpty();
        }
        return false;
    }

    public FileCollection getBootClasspath() {
        if (this.bootClasspath == null) {
            this.bootClasspath = this.project.files(new Object[]{this.getFilteredBootClasspath()});
            if (this.extension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                this.bootClasspath.from(new Object[]{this.getSdkComponents().getCoreLambdaStubsProvider()});
            }
        }
        return this.bootClasspath;
    }

    public FileCollection getFilteredBootClasspath() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslScope().getIssueReporter(), this.getSdkComponents().getTargetBootClasspathProvider(), this.getSdkComponents().getTargetAndroidVersionProvider(), this.getSdkComponents().getAdditionalLibrariesProvider(), this.getSdkComponents().getOptionalLibrariesProvider(), this.getSdkComponents().getAnnotationsJarProvider(), false, (List<? extends LibraryRequest>)ImmutableList.copyOf(this.getExtension().getLibraryRequests()));
    }

    public FileCollection getFullBootClasspath() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslScope().getIssueReporter(), this.getSdkComponents().getTargetBootClasspathProvider(), this.getSdkComponents().getTargetAndroidVersionProvider(), this.getSdkComponents().getAdditionalLibrariesProvider(), this.getSdkComponents().getOptionalLibrariesProvider(), this.getSdkComponents().getAnnotationsJarProvider(), true, (List<? extends LibraryRequest>)ImmutableList.of());
    }
}

