/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import android.databinding.tool.util.Preconditions;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.ExternalLibsMergerTransform;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/transforms/ExternalLibsMergerTransform;", "Lcom/android/build/api/transform/Transform;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "dexMergerTool", "Lcom/android/builder/dexing/DexMergerTool;", "minSdkVersion", "", "isDebuggable", "", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "callableFactory", "Lcom/android/build/gradle/internal/transforms/DexMergerTransformCallable$Factory;", "(Lcom/android/builder/dexing/DexingType;Lcom/android/builder/dexing/DexMergerTool;IZLcom/android/ide/common/blame/MessageReceiver;Lcom/android/build/gradle/internal/transforms/DexMergerTransformCallable$Factory;)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getParameterInputs", "", "", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class ExternalLibsMergerTransform
extends Transform {
    private final LoggerWrapper logger;
    private final ForkJoinPool forkJoinPool;
    private final DexingType dexingType;
    private final DexMergerTool dexMergerTool;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final MessageReceiver messageReceiver;
    private final DexMergerTransformCallable.Factory callableFactory;

    @NotNull
    public String getName() {
        return "externalLibsDexMerger";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of(ExtendedContentType.DEX_ARCHIVE)");
        return (Set)immutableSet;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of(Qualifie\u2026Scope.EXTERNAL_LIBRARIES)");
        return (Set)immutableSet;
    }

    @NotNull
    public Map<String, Object> getParameterInputs() {
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"dexing-type", (Object)this.dexingType.name()).put((Object)"dex-merger-tool", (Object)this.dexMergerTool.name()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.builder<Str\u2026\n                .build()");
        return (Map)immutableMap;
    }

    public boolean isIncremental() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Iterator $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"transformInvocation.inputs");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Object object = $this$flatMapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            TransformInput it = (TransformInput)element$iv$iv;
            boolean bl = false;
            TransformInput transformInput = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Iterable list$iv$iv = transformInput.getJarInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List flattenInputs = (List)destination$iv$iv;
        if (transformInvocation.isIncremental()) {
            boolean bl;
            block13: {
                Iterable $this$none$iv = flattenInputs;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        JarInput it = (JarInput)element$iv;
                        boolean bl2 = false;
                        JarInput jarInput = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jarInput, (String)"it");
                        if (!(jarInput.getStatus() != Status.NOTCHANGED)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        Preconditions.check((transformInvocation.getOutputProvider() != null ? 1 : 0) != 0, (String)"No OutputProvider for ExternalLibsMergerTransform", (Object[])new Object[0]);
        Iterator<Path> jarInputList2 = flattenInputs.stream().filter(transform.jarInputList.1.INSTANCE).map(transform.jarInputList.2.INSTANCE).iterator();
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)this.logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)this.logger), new MessageReceiver[]{this.messageReceiver});
        TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        File outputDir = transformOutputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        FileUtils.cleanOutputDir((File)outputDir);
        if (!jarInputList2.hasNext()) {
            return;
        }
        Closeable closeable = (Closeable)outputHandler.createOutput();
        boolean bl = false;
        object = null;
        try {
            ProcessOutput processOutputHandler = (ProcessOutput)closeable;
            boolean bl3 = false;
            DexMergerTransformCallable callable = this.callableFactory.create(this.messageReceiver, this.dexingType, processOutputHandler, outputDir, jarInputList2, null, this.forkJoinPool, this.dexMergerTool, this.minSdkVersion, this.isDebuggable);
            callable.call();
            this.forkJoinPool.shutdown();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public ExternalLibsMergerTransform(@NotNull DexingType dexingType, @NotNull DexMergerTool dexMergerTool, int minSdkVersion, boolean isDebuggable2, @NotNull MessageReceiver messageReceiver, @NotNull DexMergerTransformCallable.Factory callableFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dexingType, (String)"dexingType");
        Intrinsics.checkParameterIsNotNull((Object)dexMergerTool, (String)"dexMergerTool");
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        Intrinsics.checkParameterIsNotNull((Object)callableFactory, (String)"callableFactory");
        this.dexingType = dexingType;
        this.dexMergerTool = dexMergerTool;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable2;
        this.messageReceiver = messageReceiver;
        this.callableFactory = callableFactory;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(ExternalLibsMergerTransform.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026gerTransform::class.java)");
        this.logger = loggerWrapper;
        this.forkJoinPool = new ForkJoinPool();
    }
}

