/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.GradleBuildLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskAction;

public class ExternalNativeCleanTask
extends AndroidBuilderTask {
    private Provider<ExternalNativeJsonGenerator> generator;

    @TaskAction
    void clean() throws ProcessException, IOException {
        try (GradleBuildLoggingEnvironment ignore = new GradleBuildLoggingEnvironment(this.getLogger(), this.getVariantName());){
            LoggingEnvironmentKt.infoln("starting clean", new Object[0]);
            LoggingEnvironmentKt.infoln("finding existing JSONs", new Object[0]);
            ArrayList existingJsons = Lists.newArrayList();
            for (File json : this.getNativeBuildConfigurationsJsons()) {
                if (!json.isFile()) continue;
                existingJsons.add(json);
            }
            List<NativeBuildConfigValueMini> configValueList = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(existingJsons, null);
            ArrayList cleanCommands = Lists.newArrayList();
            ArrayList targetNames = Lists.newArrayList();
            for (NativeBuildConfigValueMini config2 : configValueList) {
                cleanCommands.addAll(config2.cleanCommands);
                HashSet targets = Sets.newHashSet();
                for (NativeLibraryValueMini library : config2.libraries.values()) {
                    targets.add(String.format("%s %s", library.artifactName, library.abi));
                }
                targetNames.add(Joiner.on((String)",").join((Iterable)targets));
            }
            LoggingEnvironmentKt.infoln("about to execute %s clean commands", cleanCommands.size());
            this.executeProcessBatch(cleanCommands, targetNames);
            if (!this.getStlSharedObjectFiles().isEmpty()) {
                LoggingEnvironmentKt.infoln("remove STL shared object files", new Object[0]);
                for (Abi abi : this.getStlSharedObjectFiles().keySet()) {
                    File stlSharedObjectFile = (File)Preconditions.checkNotNull((Object)this.getStlSharedObjectFiles().get((Object)abi));
                    File objAbi = FileUtils.join((File)this.getObjFolder(), (String[])new String[]{abi.getTag(), stlSharedObjectFile.getName()});
                    if (objAbi.delete()) {
                        LoggingEnvironmentKt.infoln("removed file %s", objAbi);
                        continue;
                    }
                    LoggingEnvironmentKt.infoln("failed to remove file %s", objAbi);
                }
            }
            LoggingEnvironmentKt.infoln("clean complete", new Object[0]);
        }
    }

    private void executeProcessBatch(List<String> commands, List<String> targetNames) throws ProcessException, IOException {
        for (int commandIndex = 0; commandIndex < commands.size(); ++commandIndex) {
            String command = commands.get(commandIndex);
            String target = targetNames.get(commandIndex);
            this.getLogger().lifecycle(String.format("Clean %s", target));
            List tokens = StringHelper.tokenizeCommandLineToEscaped((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                processBuilder.addArgs((String)tokens.get(i));
            }
            LoggingEnvironmentKt.infoln("%s", processBuilder);
            ProcessOutputJunctionKt.createProcessOutputJunction(this.getObjFolder(), "android_gradle_clean_" + commandIndex, processBuilder, this.getBuilder(), "").logStderrToInfo().logStdoutToInfo().execute();
        }
    }

    private List<File> getNativeBuildConfigurationsJsons() {
        ArrayList abiNames = Lists.newArrayList();
        for (Abi abi : Abi.values()) {
            abiNames.add(abi.getTag());
        }
        ExternalNativeJsonGenerator jsonGenerator = (ExternalNativeJsonGenerator)this.generator.get();
        return ExternalNativeBuildTaskUtils.getOutputJsons(jsonGenerator.getJsonFolder(), abiNames);
    }

    private Map<Abi, File> getStlSharedObjectFiles() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).getStlSharedObjectFiles();
    }

    private File getObjFolder() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).getObjFolder();
    }

    public static class CreationAction
    extends TaskCreationAction<ExternalNativeCleanTask> {
        private final Provider<ExternalNativeJsonGenerator> generator;
        private final VariantScope variantScope;

        public CreationAction(Provider<ExternalNativeJsonGenerator> generator, VariantScope scope) {
            this.generator = generator;
            this.variantScope = scope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("externalNativeBuildClean");
        }

        @Override
        public Class<ExternalNativeCleanTask> getType() {
            return ExternalNativeCleanTask.class;
        }

        @Override
        public void configure(ExternalNativeCleanTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.generator = this.generator;
            task.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
        }
    }
}

