/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.compiler.ShaderProcessor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@CacheableTask
public class ShaderCompile
extends AndroidVariantTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.vert"}).include(new String[]{"**/*.tesc"}).include(new String[]{"**/*.tese"}).include(new String[]{"**/*.geom"}).include(new String[]{"**/*.frag"}).include(new String[]{"**/*.comp"});
    private File outputDir;
    private final WorkerExecutorFacade workers;
    private Provider<Revision> buildToolInfoRevisionProvider;
    private Provider<File> ndkLocation;
    private Provider<Directory> sourceDir;
    private List<String> defaultArgs = ImmutableList.of();
    private Map<String, List<String>> scopedArgs = ImmutableMap.of();

    public ShaderCompile() {
        this.workers = Workers.INSTANCE.withThreads(this.getProject().getName(), this.getPath());
    }

    @Input
    public String getBuildToolsVersion() {
        return ((Revision)this.buildToolInfoRevisionProvider.get()).toString();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Provider<Directory> getSourceDir() {
        return this.sourceDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSourceFiles() {
        File sourceDirFile = ((Directory)this.sourceDir.get()).getAsFile();
        FileTree src = null;
        if (sourceDirFile.isDirectory()) {
            src = this.getProject().files(new Object[]{sourceDirFile}).getAsFileTree().matching((PatternFilterable)PATTERN_SET);
        }
        return src == null ? this.getProject().files(new Object[0]).getAsFileTree() : src;
    }

    @TaskAction
    protected void compileShaders() throws IOException {
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        try (WorkerExecutorFacade workers = this.workers;){
            this.compileAllShaderFiles(((Directory)this.sourceDir.get()).getAsFile(), this.getOutputDir(), this.defaultArgs, this.scopedArgs, () -> (File)this.ndkLocation.get(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())), workers);
        }
    }

    private void compileAllShaderFiles(File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, Supplier<File> ndkLocation, ProcessOutputHandler processOutputHandler, WorkerExecutorFacade workers) throws IOException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Supplier<ShaderProcessor> processor = () -> new ShaderProcessor(ndkLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, (ProcessExecutor)new GradleProcessExecutor(this.getProject()), processOutputHandler, workers);
        DirectoryWalker.builder().root(sourceFolder.toPath()).extensions(new String[]{"vert", "tesc", "tese", "geom", "frag", "comp"}).action(processor).build().walk();
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File sourceOutputDir) {
        this.outputDir = sourceOutputDir;
    }

    @Input
    public List<String> getDefaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = ImmutableList.copyOf(defaultArgs);
    }

    @Input
    public Map<String, List<String>> getScopedArgs() {
        return this.scopedArgs;
    }

    public void setScopedArgs(Map<String, List<String>> scopedArgs) {
        this.scopedArgs = ImmutableMap.copyOf(scopedArgs);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ShaderCompile> {
        private File outputDir;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("compile", "Shaders");
        }

        @Override
        public Class<ShaderCompile> getType() {
            return ShaderCompile.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.SHADER_ASSETS, taskName, "out");
        }

        @Override
        public void configure(ShaderCompile task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
            task.ndkLocation = scope.getGlobalScope().getSdkComponents().getNdkFolderProvider();
            task.sourceDir = scope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_SHADERS);
            task.setOutputDir(this.outputDir);
            task.setDefaultArgs(variantConfiguration.getDefautGlslcArgs());
            task.setScopedArgs(variantConfiguration.getScopedGlslcArgs());
            task.buildToolInfoRevisionProvider = scope.getGlobalScope().getSdkComponents().getBuildToolsRevisionProvider();
        }
    }
}

