/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.Version;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class SdkHandler {
    public static File sTestSdkFolder;
    private final ILogger logger;
    private final EvalIssueReporter evalIssueReporter;
    private SdkLoader sdkLoader;
    private File sdkFolder;
    private File cmakePathInLocalProp = null;
    private File ndkSymlinkDirInLocalProp = null;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private boolean isRegularSdk = true;
    private static final Pattern PATTERN_FIND_QUOTES;

    public static void setTestSdkFolder(File testSdkFolder) {
        sTestSdkFolder = testSdkFolder;
    }

    public SdkHandler(Project project, ILogger logger, EvalIssueReporter evalIssueReporter) {
        this.logger = logger;
        this.evalIssueReporter = evalIssueReporter;
        this.findLocation(project);
    }

    public Pair<SdkInfo, TargetInfo> initTarget(String targetHash, Revision buildToolRevision) {
        TargetInfo targetInfo;
        Preconditions.checkNotNull((Object)targetHash, (Object)"android.compileSdkVersion is missing!");
        Preconditions.checkNotNull((Object)buildToolRevision, (Object)"android.buildToolsVersion is missing!");
        SdkLoader sdkLoader = this.getSdkLoader();
        if (sdkLoader == null) {
            return null;
        }
        if (buildToolRevision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.BUILD_TOOLS_TOO_LOW, String.format("The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.", buildToolRevision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION), ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString());
            buildToolRevision = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SdkInfo sdkInfo = sdkLoader.getSdkInfo(this.logger);
        try {
            targetInfo = sdkLoader.getTargetInfo(targetHash, buildToolRevision, this.logger, this.sdkLibData);
        }
        catch (LicenceNotAcceptedException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, new EvalIssueException(e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" "))));
            return null;
        }
        catch (InstallFailedException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, new EvalIssueException(e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" "))));
            return null;
        }
        catch (IllegalStateException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, new EvalIssueException((Throwable)e, e.getMessage()));
            return null;
        }
        this.logger.verbose("SDK initialized in %1$d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return Pair.of((Object)sdkInfo, (Object)targetInfo);
    }

    public boolean ensurePlatformToolsIsInstalledWarnOnFailure() {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)this.getSdkFolder());
        LocalPackage platformToolsPackage = sdk.getLatestLocalPackageForPrefix("platform-tools", null, true, (ProgressIndicator)progress);
        if (platformToolsPackage == null && this.sdkLoader != null) {
            if (this.sdkLibData.useSdkDownload()) {
                try {
                    this.sdkLoader.installSdkTool(this.sdkLibData, "platform-tools");
                    return true;
                }
                catch (LicenceNotAcceptedException e) {
                    this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed. Please accept the installation licence to continue", "platform-tools");
                }
                catch (InstallFailedException e) {
                    this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed, and automatic installation failed.", "platform-tools");
                }
            } else {
                this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed.", "platform-tools");
            }
        }
        return false;
    }

    public File getSdkFolder() {
        return this.sdkFolder;
    }

    public File getCmakePathInLocalProp() {
        return this.cmakePathInLocalProp;
    }

    public File getNdkSymlinkDirInLocalProp() {
        return this.ndkSymlinkDirInLocalProp;
    }

    private synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            if (this.isRegularSdk) {
                if (this.sdkFolder == null) {
                    return null;
                }
                if (sTestSdkFolder == null && !this.sdkFolder.isDirectory()) {
                    throw new IllegalStateException(String.format("The SDK directory '%1$s' does not exist.", this.sdkFolder));
                }
                this.sdkLoader = DefaultSdkLoader.getLoader((File)this.sdkFolder);
            } else {
                this.sdkLoader = PlatformLoader.getLoader((File)this.sdkFolder);
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            if (this.isRegularSdk) {
                DefaultSdkLoader.unload();
            } else {
                PlatformLoader.unload();
            }
            this.sdkLoader = null;
        }
    }

    public static Pair<File, Boolean> findSdkLocation(Properties properties, File rootDir) {
        String sdkDirProp = properties.getProperty("sdk.dir");
        if (sdkDirProp != null) {
            File sdk = new File(sdkDirProp);
            if (!sdk.isAbsolute()) {
                sdk = new File(rootDir, sdkDirProp);
            }
            return Pair.of((Object)sdk, (Object)true);
        }
        sdkDirProp = properties.getProperty("android.dir");
        if (sdkDirProp != null) {
            File sdk = new File(sdkDirProp);
            if (!sdk.isAbsolute()) {
                sdk = new File(rootDir, sdkDirProp);
            }
            return Pair.of((Object)sdk, (Object)false);
        }
        String envVar = System.getenv("ANDROID_SDK_ROOT");
        if (envVar == null) {
            envVar = System.getenv("ANDROID_HOME");
        }
        if (envVar != null) {
            File sdk = new File(envVar);
            if (!sdk.isAbsolute()) {
                sdk = new File(rootDir, envVar);
            }
            return Pair.of((Object)sdk, (Object)true);
        }
        String property = System.getProperty("android.home");
        if (property != null) {
            return Pair.of((Object)new File(property), (Object)true);
        }
        return Pair.of(null, (Object)true);
    }

    /*
     * Loose catch block
     */
    private void findLocation(Project project) {
        String symLinkDirPath;
        String cmakeProperty;
        Properties properties;
        File rootDir;
        block16: {
            if (sTestSdkFolder != null) {
                this.sdkFolder = sTestSdkFolder;
                return;
            }
            rootDir = project.getRootDir();
            File localProperties = new File(rootDir, "local.properties");
            properties = new Properties();
            if (localProperties.isFile()) {
                InputStreamReader reader = null;
                FileInputStream fis2232322322 = new FileInputStream(localProperties);
                reader = new InputStreamReader((InputStream)fis2232322322, Charsets.UTF_8);
                properties.load(reader);
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException fis2232322322) {}
                break block16;
                catch (FileNotFoundException fis2232322322) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException fis2232322322) {}
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Unable to read %1$s.", localProperties.getAbsolutePath()), e);
                    {
                        catch (Throwable throwable) {
                            try {
                                Closeables.close(reader, (boolean)true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        Pair<File, Boolean> sdkLocation = SdkHandler.findSdkLocation(properties, rootDir);
        this.sdkFolder = (File)sdkLocation.getFirst();
        this.isRegularSdk = (Boolean)sdkLocation.getSecond();
        if (this.sdkFolder == null) {
            String filePath = new File(project.getRootDir(), "local.properties").getAbsolutePath();
            String message = "SDK location not found. Define location with an ANDROID_SDK_ROOT environment variable or by setting the sdk.dir path in your project's local properties file at '" + filePath + "'.";
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.SDK_NOT_SET, new EvalIssueException(message, filePath, null));
        }
        if ((cmakeProperty = properties.getProperty("cmake.dir")) != null) {
            Matcher m = PATTERN_FIND_QUOTES.matcher(cmakeProperty);
            this.cmakePathInLocalProp = m.find() ? new File(m.group(1)) : new File(cmakeProperty);
        }
        this.ndkSymlinkDirInLocalProp = (symLinkDirPath = properties.getProperty("ndk.symlinkdir")) != null ? new File(symLinkDirPath) : null;
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    public void installNdk(NdkHandler ndkHandler2) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        SdkLoader loader = this.getSdkLoader();
        if (loader == null) {
            return;
        }
        loader.getSdkInfo(this.logger);
        ndkHandler2.installFromSdk(loader, this.sdkLibData);
    }

    public void installCMake(String version) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        try {
            SdkLoader loader = this.getSdkLoader();
            if (loader == null) {
                return;
            }
            loader.getSdkInfo(this.logger);
            loader.installSdkTool(this.sdkLibData, "cmake;" + version);
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PATTERN_FIND_QUOTES = Pattern.compile("\"([^\"]*)\"");
    }
}

