/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import java.io.File;
import java.util.Locale;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;

public enum InternalArtifactType implements ArtifactType
{
    JAVAC,
    NAMESPACED_CLASSES_JAR,
    TESTED_CODE_CLASSES,
    FIXED_STACK_FRAMES,
    RUNTIME_LIBRARY_CLASSES(ArtifactType.Kind.FILE),
    COMPILE_LIBRARY_CLASSES(ArtifactType.Kind.FILE),
    EXTERNAL_LIBS_DEX,
    EXTERNAL_FILE_LIB_DEX_ARCHIVES,
    DEX,
    APP_CLASSES,
    JAVA_RES,
    MERGED_JAVA_RES(ArtifactType.Kind.FILE),
    LIBRARY_JAVA_RES(ArtifactType.Kind.FILE),
    FULL_JAR,
    JACOCO_INSTRUMENTED_CLASSES,
    JACOCO_INSTRUMENTED_JARS,
    CODE_COVERAGE(Category.OUTPUTS),
    DEVICE_PROVIDER_CODE_COVERAGE(Category.OUTPUTS),
    MERGED_RES,
    NOT_NAMESPACED_R_CLASS_SOURCES(Category.GENERATED),
    COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR(ArtifactType.Kind.FILE),
    MERGED_NOT_COMPILED_RES,
    UNIT_TEST_CONFIG_DIRECTORY,
    PROCESSED_RES,
    PACKAGED_RES,
    SYMBOL_LIST,
    SYMBOL_LIST_WITH_PACKAGE_NAME,
    DEFINED_ONLY_SYMBOL_LIST,
    LOCAL_ONLY_SYMBOL_LIST,
    PUBLIC_RES,
    SHRUNK_PROCESSED_RES,
    DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES,
    ABI_PROCESSED_SPLIT_RES,
    DENSITY_OR_LANGUAGE_PACKAGED_SPLIT,
    INSTANT_RUN_MAIN_APK_RESOURCES,
    INSTANT_RUN_PACKAGED_RESOURCES,
    INSTANT_RUN_SPLIT_APK_RESOURCES,
    LINKED_RES_FOR_BUNDLE,
    SHRUNK_LINKED_RES_FOR_BUNDLE,
    LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES,
    LEGACY_MULTIDEX_MAIN_DEX_LIST(ArtifactType.Kind.FILE),
    RES_COMPILED_FLAT_FILES,
    RES_STATIC_LIBRARY,
    RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES,
    COMPILE_ONLY_NAMESPACED_R_CLASS_JAR(ArtifactType.Kind.FILE),
    COMPILE_ONLY_NAMESPACED_DEPENDENCIES_R_JAR,
    NON_NAMESPACED_CLASSES,
    RUNTIME_R_CLASS_SOURCES(Category.GENERATED),
    RUNTIME_R_CLASS_CLASSES,
    PARTIAL_R_FILES,
    LIBRARY_JNI,
    LIBRARY_AND_LOCAL_JARS_JNI,
    MERGED_JNI_LIBS,
    MERGED_SHADERS,
    NDK_LIBS,
    MERGED_NATIVE_LIBS,
    STRIPPED_NATIVE_LIBS,
    SHADER_ASSETS,
    LIBRARY_ASSETS,
    MERGED_ASSETS,
    AIDL_PARCELABLE,
    AIDL_SOURCE_OUTPUT_DIR(Category.GENERATED),
    RENDERSCRIPT_HEADERS,
    RENDERSCRIPT_SOURCE_OUTPUT_DIR(Category.GENERATED),
    RENDERSCRIPT_LIB,
    CHECK_MANIFEST_RESULT,
    COMPATIBLE_SCREEN_MANIFEST,
    MERGED_MANIFESTS,
    LIBRARY_MANIFEST(ArtifactType.Kind.FILE),
    NON_NAMESPACED_LIBRARY_MANIFEST(ArtifactType.Kind.FILE),
    NAMESPACED_MANIFESTS,
    AAPT_FRIENDLY_MERGED_MANIFESTS,
    INSTANT_APP_MANIFEST,
    MANIFEST_METADATA,
    MANIFEST_MERGE_REPORT,
    MANIFEST_MERGE_BLAME_FILE(ArtifactType.Kind.FILE),
    STATIC_LIBRARY_MANIFEST,
    ANNOTATION_PROCESSOR_LIST(ArtifactType.Kind.FILE),
    AP_GENERATED_SOURCES(Category.GENERATED, ArtifactType.Kind.DIRECTORY),
    CONSUMER_PROGUARD_FILE(ArtifactType.Kind.FILE),
    AAPT_PROGUARD_FILE(ArtifactType.Kind.FILE),
    MERGED_AAPT_PROGUARD_FILE(ArtifactType.Kind.FILE),
    DATA_BINDING_ARTIFACT,
    DATA_BINDING_DEPENDENCY_ARTIFACTS,
    DATA_BINDING_LAYOUT_INFO_TYPE_MERGE,
    DATA_BINDING_LAYOUT_INFO_TYPE_PACKAGE,
    DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS,
    DATA_BINDING_BASE_CLASS_LOG_ARTIFACT,
    DATA_BINDING_BASE_CLASS_SOURCE_OUT(Category.GENERATED),
    LINT_JAR,
    LINT_PUBLISH_JAR,
    ANNOTATIONS_ZIP,
    ANNOTATIONS_TYPEDEF_FILE,
    ANNOTATIONS_PROGUARD,
    AAR_MAIN_JAR,
    AAR_LIBS_DIRECTORY,
    ABI_PACKAGED_SPLIT,
    FULL_APK,
    APK,
    APK_FOR_LOCAL_TEST,
    APK_MAPPING,
    AAR,
    INSTANTAPP_BUNDLE,
    SPLIT_LIST,
    APK_LIST,
    MODULE_BUNDLE,
    MAIN_DEX_LIST_FOR_BUNDLE(ArtifactType.Kind.FILE),
    BUNDLE(Category.OUTPUTS, ArtifactType.Kind.FILE),
    INTERMEDIARY_BUNDLE(Category.INTERMEDIATES, ArtifactType.Kind.FILE),
    APKS_FROM_BUNDLE,
    EXTRACTED_APKS,
    UNIVERSAL_APK(Category.OUTPUTS, ArtifactType.Kind.FILE),
    BUNDLE_MANIFEST,
    FEATURE_SET_METADATA,
    METADATA_BASE_MODULE_DECLARATION,
    METADATA_APPLICATION_ID,
    FEATURE_RESOURCE_PKG,
    FEATURE_TRANSITIVE_DEPS,
    FEATURE_DATA_BINDING_BASE_FEATURE_INFO,
    FEATURE_DATA_BINDING_FEATURE_INFO,
    FEATURE_DEX,
    MODULE_AND_RUNTIME_DEPS_CLASSES,
    SIGNING_CONFIG,
    VALIDATE_SIGNING_CONFIG,
    METADATA_FEATURE_DECLARATION,
    METADATA_FEATURE_MANIFEST,
    METADATA_INSTALLED_BASE_DECLARATION,
    METADATA_LIBRARY_DEPENDENCIES_REPORT(ArtifactType.Kind.FILE),
    BUNDLE_DEPENDENCY_REPORT(ArtifactType.Kind.FILE),
    INSTANT_RUN_APP_INFO_OUTPUT_FILE,
    DUPLICATE_CLASSES_CHECK,
    GENERATED_PROGUARD_FILE(ArtifactType.Kind.FILE);

    final Category category;
    final ArtifactType.Kind kind;

    public ArtifactType.Kind kind() {
        return this.kind;
    }

    public Provider<? extends FileSystemLocation> createOutputLocation(BuildArtifactsHolder artifacts, BuildArtifactsHolder.OperationType operationType, String taskName, String outputLocation) {
        switch (this.kind) {
            case DIRECTORY: {
                return artifacts.createDirectory((ArtifactType)this, operationType, taskName, outputLocation);
            }
            case FILE: {
                return artifacts.createArtifactFile((ArtifactType)this, operationType, taskName, outputLocation);
            }
        }
        throw new RuntimeException("ArtifactType.Kind not handled " + this.kind);
    }

    private InternalArtifactType() {
        this(Category.INTERMEDIATES, ArtifactType.Kind.DIRECTORY);
    }

    private InternalArtifactType(Category category) {
        this(category, ArtifactType.Kind.DIRECTORY);
    }

    private InternalArtifactType(ArtifactType.Kind kind) {
        this(Category.INTERMEDIATES, kind);
    }

    private InternalArtifactType(Category category, ArtifactType.Kind kind) {
        this.category = category;
        this.kind = kind;
    }

    static enum Category {
        GENERATED,
        INTERMEDIATES,
        OUTPUTS;


        File getOutputDir(File parentDir) {
            return new File(parentDir, this.name().toLowerCase(Locale.US));
        }

        String getOutputPath() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

