/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.profile.WorkerProfilingRecord;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTaskExecution;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/profile/RecordingBuildListener;", "Lorg/gradle/api/execution/TaskExecutionListener;", "projectName", "", "recordWriter", "Lcom/android/builder/profile/ProfileRecordWriter;", "(Ljava/lang/String;Lcom/android/builder/profile/ProfileRecordWriter;)V", "taskRecords", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "taskState", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "closeTaskRecord", "taskPath", "getTaskRecord", "getWorkerRecord", "Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "worker", "recordAnonymousSpan", "builder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "Companion", "gradle"})
public final class RecordingBuildListener
implements TaskExecutionListener {
    private final ConcurrentHashMap<String, TaskProfilingRecord> taskRecords;
    private final String projectName;
    private final ProfileRecordWriter recordWriter;
    private static final LoggerWrapper logger;
    public static final Companion Companion;

    public void beforeExecute(@NotNull Task task) {
        GradleBuildProfileSpan.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        logger.verbose("Task " + task.getPath() + " in " + this.projectName + " Starting", new Object[0]);
        GradleBuildProfileSpan.Builder builder2 = builder = GradleBuildProfileSpan.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        builder2.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        builder.setId(this.recordWriter.allocateRecordId());
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        builder.setThreadId(thread.getId());
        String string = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        String string2 = project.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.project.path");
        TaskProfilingRecord taskRecord2 = new TaskProfilingRecord(this.recordWriter, builder, string, string2, RecordingBuildListener.Companion.getVariantName(task));
        Map map = this.taskRecords;
        String string3 = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"task.path");
        map.put(string3, taskRecord2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)taskState, (String)"taskState");
        logger.verbose("Task " + task.getPath() + " in " + this.projectName + " Finished", new Object[0]);
        try {
            TaskProfilingRecord taskProfilingRecord = this.taskRecords.get(task.getPath());
            if (taskProfilingRecord == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProfilingRecord, (String)"taskRecords[task.path] ?: return");
            TaskProfilingRecord taskRecord2 = taskProfilingRecord;
            GradleBuildProfileSpan.Builder record = taskRecord2.getSpanBuilder();
            GradleTaskExecution.Builder builder = record.getTaskBuilder();
            GradleTaskExecutionType gradleTaskExecutionType = AnalyticsUtil.getTaskExecutionType(task.getClass());
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleTaskExecutionType, (String)"AnalyticsUtil.getTaskExecutionType(task.javaClass)");
            builder.setType(gradleTaskExecutionType.getNumber()).setDidWork(taskState.getDidWork()).setSkipped(taskState.getSkipped()).setUpToDate(taskState.getUpToDate()).setFailed(taskState.getFailure() != null);
            taskRecord2.setTaskFinished();
            if (taskRecord2.allWorkersFinished()) {
                taskRecord2.writeTaskSpan();
                String string = task.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
                this.closeTaskRecord(string);
            }
        }
        finally {
            ProcessProfileWriter.recordMemorySample();
        }
    }

    @Nullable
    public final TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkParameterIsNotNull((Object)taskPath, (String)"taskPath");
        return this.taskRecords.get(taskPath);
    }

    private final void closeTaskRecord(String taskPath) {
        this.taskRecords.remove(taskPath);
    }

    @Nullable
    public final WorkerProfilingRecord getWorkerRecord(@NotNull String taskPath, @NotNull String worker) {
        Intrinsics.checkParameterIsNotNull((Object)taskPath, (String)"taskPath");
        Intrinsics.checkParameterIsNotNull((Object)worker, (String)"worker");
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        return taskProfilingRecord != null ? taskProfilingRecord.get(worker) : null;
    }

    public final void recordAnonymousSpan(@NotNull GradleBuildProfileSpan.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        GradleBuildProfileSpan.Builder builder2 = builder.setId(this.recordWriter.allocateRecordId());
        String string = null;
        String string2 = ':' + this.projectName;
        ProfileRecordWriter profileRecordWriter = this.recordWriter;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        profileRecordWriter.writeRecord(string2, string, builder2, list);
    }

    public RecordingBuildListener(@NotNull String projectName, @NotNull ProfileRecordWriter recordWriter) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)recordWriter, (String)"recordWriter");
        this.projectName = projectName;
        this.recordWriter = recordWriter;
        this.taskRecords = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(RecordingBuildListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026uildListener::class.java)");
        logger = loggerWrapper;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/profile/RecordingBuildListener$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getVariantName", "", "task", "Lorg/gradle/api/Task;", "gradle"})
    public static final class Companion {
        private final String getVariantName(Task task) {
            if (!(task instanceof VariantAwareTask)) {
                return null;
            }
            String variantName = ((VariantAwareTask)task).getVariantName();
            CharSequence charSequence = variantName;
            boolean bl = false;
            return charSequence.length() == 0 ? null : variantName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

