/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageBundleTaskKt;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0005/0123B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010-\u001a\u00020.H\u0014R,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00148G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001c8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR \u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020 8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R$\u0010'\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000eR$\u0010)\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000eR\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "", "", "aaptOptionsNoCompress", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseModuleZip", "getBaseModuleZip", "()Lcom/android/build/api/artifact/BuildableArtifact;", "bundleDeps", "getBundleDeps", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleFlags", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleLocation", "Ljava/io/File;", "getBundleLocation", "()Ljava/io/File;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleOptions", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "fileName", "getFileName", "()Ljava/lang/String;", "mainDexList", "getMainDexList", "obsfuscationMappingFile", "getObsfuscationMappingFile", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doTaskAction", "", "BundleFlags", "BundleOptions", "BundleToolRunnable", "CreationAction", "Params", "gradle"})
public class PackageBundleTask
extends NonIncrementalTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact baseModuleZip;
    @NotNull
    private FileCollection featureZips;
    @NotNull
    private BuildableArtifact bundleDeps;
    @Nullable
    private BuildableArtifact mainDexList;
    @Nullable
    private BuildableArtifact obsfuscationMappingFile;
    @NotNull
    private Collection<String> aaptOptionsNoCompress;
    @NotNull
    private BundleOptions bundleOptions;
    @NotNull
    private BundleFlags bundleFlags;
    private Provider<RegularFile> bundleFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final BuildableArtifact getBaseModuleZip() {
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection2 = this.featureZips;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection2;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getBundleDeps() {
        BuildableArtifact buildableArtifact = this.bundleDeps;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleDeps");
        }
        return buildableArtifact;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getMainDexList() {
        return this.mainDexList;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getObsfuscationMappingFile() {
        return this.obsfuscationMappingFile;
    }

    @Input
    @NotNull
    public final Collection<String> getAaptOptionsNoCompress() {
        Collection<String> collection = this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    @Nested
    @NotNull
    public final BundleOptions getBundleOptions() {
        BundleOptions bundleOptions = this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    @Nested
    @NotNull
    public final BundleFlags getBundleFlags() {
        BundleFlags bundleFlags = this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final File getBundleLocation() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"bundleFile.get().asFile.parentFile");
        return file2;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundleFile.get().asFile.name");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.workers;
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            BuildableArtifact buildableArtifact = this.baseModuleZip;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection2 = this.featureZips;
            if (fileCollection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
            }
            Set set = fileCollection2.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureZips.files");
            BuildableArtifact buildableArtifact2 = this.mainDexList;
            File file2 = buildableArtifact2 != null ? BuildableArtifactUtil.singleFile(buildableArtifact2) : null;
            BuildableArtifact buildableArtifact3 = this.obsfuscationMappingFile;
            File file3 = buildableArtifact3 != null ? BuildableArtifactUtil.singleFile(buildableArtifact3) : null;
            Collection<String> collection = this.aaptOptionsNoCompress;
            if (collection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
            }
            BundleOptions bundleOptions = this.bundleOptions;
            if (bundleOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
            }
            BundleFlags bundleFlags = this.bundleFlags;
            if (bundleFlags == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
            }
            Provider<RegularFile> provider = this.bundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
            File file4 = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"bundleFile.get().asFile");
            BuildableArtifact buildableArtifact4 = this.bundleDeps;
            if (buildableArtifact4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleDeps");
            }
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, set, file2, file3, collection, bundleOptions, bundleFlags, file4, BuildableArtifactUtil.singleFile(buildableArtifact4)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public PackageBundleTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    public static final /* synthetic */ Provider access$getBundleFile$p(PackageBundleTask $this) {
        Provider<RegularFile> provider = $this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return provider;
    }

    public static final /* synthetic */ BuildableArtifact access$getBaseModuleZip$p(PackageBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ FileCollection access$getFeatureZips$p(PackageBundleTask $this) {
        FileCollection fileCollection2 = $this.featureZips;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection2;
    }

    public static final /* synthetic */ BuildableArtifact access$getBundleDeps$p(PackageBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.bundleDeps;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleDeps");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ Collection access$getAaptOptionsNoCompress$p(PackageBundleTask $this) {
        Collection<String> collection = $this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    public static final /* synthetic */ BundleOptions access$getBundleOptions$p(PackageBundleTask $this) {
        BundleOptions bundleOptions = $this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    public static final /* synthetic */ BundleFlags access$getBundleFlags$p(PackageBundleTask $this) {
        BundleFlags bundleFlags = $this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    public static final /* synthetic */ BuildableArtifact access$getMainDexList$p(PackageBundleTask $this) {
        return $this.mainDexList;
    }

    public static final /* synthetic */ BuildableArtifact access$getObsfuscationMappingFile$p(PackageBundleTask $this) {
        return $this.obsfuscationMappingFile;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003Js\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\nH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "Ljava/io/Serializable;", "baseModuleFile", "Ljava/io/File;", "featureFiles", "", "mainDexList", "obfuscationMappingFile", "aaptOptionsNoCompress", "", "", "bundleOptions", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleFlags", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleFile", "bundleDeps", "(Ljava/io/File;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;Ljava/io/File;Ljava/io/File;)V", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "getBaseModuleFile", "()Ljava/io/File;", "getBundleDeps", "getBundleFile", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "getFeatureFiles", "()Ljava/util/Set;", "getMainDexList", "getObfuscationMappingFile", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File baseModuleFile;
        @NotNull
        private final Set<File> featureFiles;
        @Nullable
        private final File mainDexList;
        @Nullable
        private final File obfuscationMappingFile;
        @NotNull
        private final Collection<String> aaptOptionsNoCompress;
        @NotNull
        private final BundleOptions bundleOptions;
        @NotNull
        private final BundleFlags bundleFlags;
        @NotNull
        private final File bundleFile;
        @NotNull
        private final File bundleDeps;

        @NotNull
        public final File getBaseModuleFile() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        @Nullable
        public final File getMainDexList() {
            return this.mainDexList;
        }

        @Nullable
        public final File getObfuscationMappingFile() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> getAaptOptionsNoCompress() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions getBundleOptions() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags getBundleFlags() {
            return this.bundleFlags;
        }

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        @NotNull
        public final File getBundleDeps() {
            return this.bundleDeps;
        }

        public Params(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @NotNull File bundleFile, @NotNull File bundleDeps) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)bundleDeps, (String)"bundleDeps");
            this.baseModuleFile = baseModuleFile;
            this.featureFiles = featureFiles;
            this.mainDexList = mainDexList;
            this.obfuscationMappingFile = obfuscationMappingFile;
            this.aaptOptionsNoCompress = aaptOptionsNoCompress;
            this.bundleOptions = bundleOptions;
            this.bundleFlags = bundleFlags;
            this.bundleFile = bundleFile;
            this.bundleDeps = bundleDeps;
        }

        @NotNull
        public final File component1() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.featureFiles;
        }

        @Nullable
        public final File component3() {
            return this.mainDexList;
        }

        @Nullable
        public final File component4() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> component5() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions component6() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags component7() {
            return this.bundleFlags;
        }

        @NotNull
        public final File component8() {
            return this.bundleFile;
        }

        @NotNull
        public final File component9() {
            return this.bundleDeps;
        }

        @NotNull
        public final Params copy(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @NotNull File bundleFile, @NotNull File bundleDeps) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)bundleDeps, (String)"bundleDeps");
            return new Params(baseModuleFile, featureFiles, mainDexList, obfuscationMappingFile, aaptOptionsNoCompress, bundleOptions, bundleFlags, bundleFile, bundleDeps);
        }

        @NotNull
        public static /* synthetic */ Params copy$default(Params params, File file, Set set, File file2, File file3, Collection collection, BundleOptions bundleOptions, BundleFlags bundleFlags, File file4, File file5, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.baseModuleFile;
            }
            if ((n & 2) != 0) {
                set = params.featureFiles;
            }
            if ((n & 4) != 0) {
                file2 = params.mainDexList;
            }
            if ((n & 8) != 0) {
                file3 = params.obfuscationMappingFile;
            }
            if ((n & 0x10) != 0) {
                collection = params.aaptOptionsNoCompress;
            }
            if ((n & 0x20) != 0) {
                bundleOptions = params.bundleOptions;
            }
            if ((n & 0x40) != 0) {
                bundleFlags = params.bundleFlags;
            }
            if ((n & 0x80) != 0) {
                file4 = params.bundleFile;
            }
            if ((n & 0x100) != 0) {
                file5 = params.bundleDeps;
            }
            return params.copy(file, set, file2, file3, collection, bundleOptions, bundleFlags, file4, file5);
        }

        @NotNull
        public String toString() {
            return "Params(baseModuleFile=" + this.baseModuleFile + ", featureFiles=" + this.featureFiles + ", mainDexList=" + this.mainDexList + ", obfuscationMappingFile=" + this.obfuscationMappingFile + ", aaptOptionsNoCompress=" + this.aaptOptionsNoCompress + ", bundleOptions=" + this.bundleOptions + ", bundleFlags=" + this.bundleFlags + ", bundleFile=" + this.bundleFile + ", bundleDeps=" + this.bundleDeps + ")";
        }

        public int hashCode() {
            File file = this.baseModuleFile;
            Set<File> set = this.featureFiles;
            File file2 = this.mainDexList;
            File file3 = this.obfuscationMappingFile;
            Collection<String> collection = this.aaptOptionsNoCompress;
            BundleOptions bundleOptions = this.bundleOptions;
            BundleFlags bundleFlags = this.bundleFlags;
            File file4 = this.bundleFile;
            File file5 = this.bundleDeps;
            return ((((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (bundleOptions != null ? ((Object)bundleOptions).hashCode() : 0)) * 31 + (bundleFlags != null ? ((Object)bundleFlags).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (file5 != null ? ((Object)file5).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.baseModuleFile, (Object)params.baseModuleFile) || !Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !Intrinsics.areEqual((Object)this.mainDexList, (Object)params.mainDexList) || !Intrinsics.areEqual((Object)this.obfuscationMappingFile, (Object)params.obfuscationMappingFile) || !Intrinsics.areEqual(this.aaptOptionsNoCompress, params.aaptOptionsNoCompress) || !Intrinsics.areEqual((Object)this.bundleOptions, (Object)params.bundleOptions) || !Intrinsics.areEqual((Object)this.bundleFlags, (Object)params.bundleFlags) || !Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile) || !Intrinsics.areEqual((Object)this.bundleDeps, (Object)params.bundleDeps)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;)V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File it;
            boolean bl;
            boolean bl2;
            File bundleFile = this.params.getBundleFile();
            FileUtils.cleanOutputDir((File)bundleFile.getParentFile());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.getBundlePath(this.params.getBaseModuleFile()));
            Iterable $this$forEach$iv = this.params.getFeatureFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl3 = false;
                builder.add((Object)this.getBundlePath(it2));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle(this.params.getAaptOptionsNoCompress());
            Config.SplitsConfig.Builder builder2 = Config.SplitsConfig.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Config.SplitsConfig.newBuilder()");
            Config.SplitsConfig.Builder splitsConfig = PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(builder2, Config.SplitDimension.Value.ABI, this.params.getBundleOptions().getEnableAbi()), Config.SplitDimension.Value.SCREEN_DENSITY, this.params.getBundleOptions().getEnableDensity()), Config.SplitDimension.Value.LANGUAGE, this.params.getBundleOptions().getEnableLanguage());
            Config.UncompressNativeLibraries.Builder uncompressNativeLibrariesConfig = Config.UncompressNativeLibraries.newBuilder().setEnabled(this.params.getBundleFlags().getEnableUncompressedNativeLibs());
            Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder().setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).setOptimizations(Config.Optimizations.newBuilder().setSplitsConfig(splitsConfig).setUncompressNativeLibraries(uncompressNativeLibrariesConfig));
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setBundleConfig(bundleConfig.build()).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build()).addMetadataFile("com.android.tools.build.libraries", "dependencies.pb", this.params.getBundleDeps().toPath());
            File file = this.params.getMainDexList();
            if (file != null) {
                File file2 = file;
                bl2 = false;
                bl = false;
                it = file2;
                boolean bl4 = false;
                command.setMainDexListFile(it.toPath());
            }
            File file3 = this.params.getObfuscationMappingFile();
            if (file3 != null) {
                File file4 = file3;
                bl2 = false;
                bl = false;
                it = file4;
                boolean bl5 = false;
                command.addMetadataFile("com.android.tools.build.obfuscation", "proguard.map", it.toPath());
            }
            command.build().execute();
        }

        private final Path getBundlePath(File folder) {
            File[] children = folder.listFiles();
            Preconditions.checkNotNull((Object)children);
            Preconditions.checkState((children.length == 1 ? 1 : 0) != 0);
            Path path = children[0].toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
            return path;
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ2\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\bR\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Ljava/io/Serializable;", "enableAbi", "", "enableDensity", "enableLanguage", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getEnableAbi", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnableDensity", "getEnableLanguage", "component1", "component2", "component3", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleOptions
    implements Serializable {
        @Nullable
        private final Boolean enableAbi;
        @Nullable
        private final Boolean enableDensity;
        @Nullable
        private final Boolean enableLanguage;

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableAbi() {
            return this.enableAbi;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDensity() {
            return this.enableDensity;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableLanguage() {
            return this.enableLanguage;
        }

        public BundleOptions(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            this.enableAbi = enableAbi;
            this.enableDensity = enableDensity;
            this.enableLanguage = enableLanguage;
        }

        @Nullable
        public final Boolean component1() {
            return this.enableAbi;
        }

        @Nullable
        public final Boolean component2() {
            return this.enableDensity;
        }

        @Nullable
        public final Boolean component3() {
            return this.enableLanguage;
        }

        @NotNull
        public final BundleOptions copy(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            return new BundleOptions(enableAbi, enableDensity, enableLanguage);
        }

        @NotNull
        public static /* synthetic */ BundleOptions copy$default(BundleOptions bundleOptions, Boolean bl, Boolean bl2, Boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleOptions.enableAbi;
            }
            if ((n & 2) != 0) {
                bl2 = bundleOptions.enableDensity;
            }
            if ((n & 4) != 0) {
                bl3 = bundleOptions.enableLanguage;
            }
            return bundleOptions.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "BundleOptions(enableAbi=" + this.enableAbi + ", enableDensity=" + this.enableDensity + ", enableLanguage=" + this.enableLanguage + ")";
        }

        public int hashCode() {
            Boolean bl = this.enableAbi;
            Boolean bl2 = this.enableDensity;
            Boolean bl3 = this.enableLanguage;
            return ((bl != null ? ((Object)bl).hashCode() : 0) * 31 + (bl2 != null ? ((Object)bl2).hashCode() : 0)) * 31 + (bl3 != null ? ((Object)bl3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleOptions)) break block3;
                    BundleOptions bundleOptions = (BundleOptions)object;
                    if (!Intrinsics.areEqual((Object)this.enableAbi, (Object)bundleOptions.enableAbi) || !Intrinsics.areEqual((Object)this.enableDensity, (Object)bundleOptions.enableDensity) || !Intrinsics.areEqual((Object)this.enableLanguage, (Object)bundleOptions.enableLanguage)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "Ljava/io/Serializable;", "enableUncompressedNativeLibs", "", "(Z)V", "getEnableUncompressedNativeLibs", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleFlags
    implements Serializable {
        private final boolean enableUncompressedNativeLibs;

        @Input
        public final boolean getEnableUncompressedNativeLibs() {
            return this.enableUncompressedNativeLibs;
        }

        public BundleFlags(boolean enableUncompressedNativeLibs) {
            this.enableUncompressedNativeLibs = enableUncompressedNativeLibs;
        }

        public final boolean component1() {
            return this.enableUncompressedNativeLibs;
        }

        @NotNull
        public final BundleFlags copy(boolean enableUncompressedNativeLibs) {
            return new BundleFlags(enableUncompressedNativeLibs);
        }

        @NotNull
        public static /* synthetic */ BundleFlags copy$default(BundleFlags bundleFlags, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleFlags.enableUncompressedNativeLibs;
            }
            return bundleFlags.copy(bl);
        }

        @NotNull
        public String toString() {
            return "BundleFlags(enableUncompressedNativeLibs=" + this.enableUncompressedNativeLibs + ")";
        }

        public int hashCode() {
            int n = this.enableUncompressedNativeLibs ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleFlags)) break block3;
                    BundleFlags bundleFlags = (BundleFlags)object;
                    if (!(this.enableUncompressedNativeLibs == bundleFlags.enableUncompressedNativeLibs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageBundleTask> {
        private Provider<RegularFile> bundleFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("package", "Bundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"package\", \"Bundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<PackageBundleTask> getType() {
            return PackageBundleTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            StringBuilder stringBuilder2 = stringBuilder.append(globalScope.getProjectBaseName()).append('-');
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            String bundleName = stringBuilder2.append(gradleVariantConfiguration.getBaseName()).append(".aab").toString();
            this.bundleFile = this.getVariantScope().getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.INTERMEDIARY_BUNDLE, BuildArtifactsHolder.OperationType.INITIAL, taskName, bundleName);
        }

        @Override
        public void configure(@NotNull PackageBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            Provider<RegularFile> provider = this.bundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            task.bundleFile = provider;
            task.baseModuleZip = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MODULE_BUNDLE);
            FileCollection fileCollection2 = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getArtifact\u2026DULE_BUNDLE\n            )");
            task.featureZips = fileCollection2;
            task.bundleDeps = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.BUNDLE_DEPENDENCY_REPORT);
            PackageBundleTask packageBundleTask = task;
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            AndroidConfig androidConfig = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"variantScope.globalScope.extension");
            AaptOptions aaptOptions = androidConfig.getAaptOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"variantScope.globalScope.extension.aaptOptions");
            Collection collection = aaptOptions.getNoCompress();
            if (collection == null) {
                PackageBundleTask packageBundleTask2 = packageBundleTask;
                boolean bl = false;
                List list = CollectionsKt.emptyList();
                packageBundleTask = packageBundleTask2;
                collection = list;
            }
            packageBundleTask.aaptOptionsNoCompress = collection;
            if (this.getVariantScope().getType().isHybrid()) {
                GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
                AndroidConfig androidConfig2 = globalScope2.getExtension();
                if (androidConfig2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.FeatureExtension");
                }
                com.android.build.gradle.internal.dsl.BundleOptions bundleOptions = ((FeatureExtension)androidConfig2).getBundle();
                Intrinsics.checkExpressionValueIsNotNull((Object)bundleOptions, (String)"((variantScope.globalSco\u2026FeatureExtension).bundle)");
                task.bundleOptions = PackageBundleTaskKt.access$convert(bundleOptions);
            } else {
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                AndroidConfig androidConfig3 = globalScope3.getExtension();
                if (androidConfig3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
                }
                task.bundleOptions = PackageBundleTaskKt.access$convert(((BaseAppModuleExtension)androidConfig3).getBundle());
            }
            GlobalScope globalScope4 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope4, (String)"variantScope.globalScope");
            task.bundleFlags = new BundleFlags(globalScope4.getProjectOptions().get(BooleanOption.ENABLE_UNCOMPRESSED_NATIVE_LIBS_IN_BUNDLE));
            if (this.getVariantScope().getNeedsMainDexListForBundle()) {
                task.mainDexList = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE);
            }
            if (this.getVariantScope().getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING)) {
                task.obsfuscationMappingFile = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING);
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

