/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskCollection;

class ReportingPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private TestOptions extension;

    @Inject
    public ReportingPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project2) {
        project2.evaluationDependsOnChildren();
        this.extension = (TestOptions)project2.getExtensions().create("android", TestOptions.class, new Object[]{this.objectFactory});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project2.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.setResultsDir(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return new File(project2.getBuildDir(), "androidTest-results");
            }
            return project2.file((Object)resultsDir);
        });
        mergeReportsTask.setReportsDir(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return new File(new File(project2.getBuildDir(), "reports"), "androidTests");
            }
            return project2.file((Object)reportsDir);
        });
        project2.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project2.getGradle().getStartParameter().isContinueOnFailure()) {
            project2.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

