/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsCopyParams;
import com.android.build.gradle.internal.scope.BuildElementsCopyRunnable;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;

public abstract class CopyOutputs
extends NonIncrementalTask {
    private final WorkerExecutorFacade workers;

    @Inject
    public CopyOutputs(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workerExecutor);
    }

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDir();

    @InputFiles
    public abstract DirectoryProperty getFullApks();

    @InputFiles
    @Optional
    public abstract DirectoryProperty getAbiSplits();

    @InputFiles
    @Optional
    public abstract DirectoryProperty getResourcesSplits();

    @Override
    protected void doTaskAction() throws IOException, ExecutionException {
        FileUtils.cleanOutputDir((File)((Directory)this.getDestinationDir().get()).getAsFile());
        ArrayList<Callable<BuildElements>> buildElementsCallables = new ArrayList<Callable<BuildElements>>();
        buildElementsCallables.add(this.copy(InternalArtifactType.FULL_APK, this.getFullApks()));
        buildElementsCallables.add(this.copy(InternalArtifactType.ABI_PACKAGED_SPLIT, this.getAbiSplits()));
        buildElementsCallables.add(this.copy(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.getResourcesSplits()));
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        for (Callable callable : buildElementsCallables) {
            try {
                buildOutputs.addAll((Iterable)callable.call());
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(((Directory)this.getDestinationDir().get()).getAsFile());
    }

    private Callable<BuildElements> copy(InternalArtifactType inputType, DirectoryProperty inputs) {
        return ExistingBuildElements.from((ArtifactType)inputType, (Provider<Directory>)inputs).transform(this.workers, BuildElementsCopyRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, inputFile) -> new BuildElementsCopyParams((File)inputFile, new File(((Directory)this.getDestinationDir().get()).getAsFile(), inputFile.getName())))).intoCallable(InternalArtifactType.APK);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CopyOutputs> {
        private final File destinationDir;

        public CreationAction(VariantScope variantScope, File destinationDir) {
            super(variantScope);
            this.destinationDir = destinationDir;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends CopyOutputs> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.APK, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, CopyOutputs::getDestinationDir, (Provider<Directory>)this.getVariantScope().getGlobalScope().getProject().getLayout().getBuildDirectory().dir(this.destinationDir.getAbsolutePath()), "");
        }

        @Override
        public void configure(CopyOutputs task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.FULL_APK, task.getFullApks());
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.ABI_PACKAGED_SPLIT, task.getAbiSplits());
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, task.getResourcesSplits());
        }
    }
}

