/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CmakeCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeProperty;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.settings.LookupSettingFromModelKt;
import com.android.build.gradle.internal.cxx.settings.Macro;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0002\u00a8\u0006\u0006"}, d2={"getCmakeCommandLineVariables", "", "Lcom/android/build/gradle/internal/cxx/configure/CommandLineArgument;", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getToolchainFile", "Ljava/io/File;", "gradle"})
public final class CmakeCommandLineBuilderKt {
    @NotNull
    public static final List<CommandLineArgument> getCmakeCommandLineVariables(@NotNull CxxAbiModel $this$getCmakeCommandLineVariables) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getCmakeCommandLineVariables, (String)"$this$getCmakeCommandLineVariables");
        CxxCmakeModuleModel cxxCmakeModuleModel = $this$getCmakeCommandLineVariables.getVariant().getModule().getCmake();
        if (cxxCmakeModuleModel == null) {
            Intrinsics.throwNpe();
        }
        CxxCmakeModuleModel cmake2 = cxxCmakeModuleModel;
        SortedMap variables = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        ((Map)variables).put(CmakeProperty.ANDROID_ABI, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.ABI));
        ((Map)variables).put(CmakeProperty.ANDROID_PLATFORM, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.PLATFORM));
        ((Map)variables).put(CmakeProperty.CMAKE_LIBRARY_OUTPUT_DIRECTORY, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.GRADLE_LIBRARY_OUTPUT_DIRECTORY));
        ((Map)variables).put(CmakeProperty.CMAKE_BUILD_TYPE, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.GRADLE_CMAKE_BUILD_TYPE));
        ((Map)variables).put(CmakeProperty.ANDROID_NDK, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.NDK_DIR));
        ((Map)variables).put(CmakeProperty.CMAKE_C_FLAGS, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.GRADLE_C_FLAGS));
        ((Map)variables).put(CmakeProperty.CMAKE_CXX_FLAGS, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.GRADLE_CPP_FLAGS));
        if (CmakeLocatorKt.isCmakeForkVersion(cmake2.getMinimumCmakeVersion())) {
            ((Map)variables).put(CmakeProperty.CMAKE_TOOLCHAIN_FILE, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.NDK_CMAKE_TOOLCHAIN));
            ((Map)variables).put(CmakeProperty.CMAKE_MAKE_PROGRAM, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.NINJA_EXE));
        } else {
            ((Map)variables).put(CmakeProperty.CMAKE_SYSTEM_NAME, "Android");
            ((Map)variables).put(CmakeProperty.CMAKE_ANDROID_ARCH_ABI, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.ABI));
            ((Map)variables).put(CmakeProperty.CMAKE_SYSTEM_VERSION, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.PLATFORM_SYSTEM_VERSION));
            ((Map)variables).put(CmakeProperty.CMAKE_EXPORT_COMPILE_COMMANDS, "ON");
            ((Map)variables).put(CmakeProperty.CMAKE_ANDROID_NDK, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.NDK_DIR));
            ((Map)variables).put(CmakeProperty.CMAKE_TOOLCHAIN_FILE, CmakeCommandLineBuilderKt.getToolchainFile($this$getCmakeCommandLineVariables).getAbsolutePath());
            ((Map)variables).put(CmakeProperty.CMAKE_MAKE_PROGRAM, LookupSettingFromModelKt.resolveMacroValue($this$getCmakeCommandLineVariables, Macro.NINJA_EXE));
        }
        boolean bl = false;
        List result = new ArrayList();
        Object object = result;
        StringBuilder stringBuilder = new StringBuilder().append("-G");
        CxxCmakeAbiModel cxxCmakeAbiModel = $this$getCmakeCommandLineVariables.getCmake();
        if (cxxCmakeAbiModel == null) {
            Intrinsics.throwNpe();
        }
        Object object2 = CmakeCommandLineKt.toCmakeArgument(stringBuilder.append(cxxCmakeAbiModel.getGenerator()).toString());
        boolean bl2 = false;
        object.add(object2);
        Map map = variables;
        boolean bl3 = false;
        object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = (Map.Entry)object2.next();
            boolean bl4 = false;
            CmakeProperty name = (CmakeProperty)((Object)object3.getKey());
            object3 = object;
            bl4 = false;
            String value = (String)object3.getValue();
            object3 = result;
            CommandLineArgument commandLineArgument = CmakeCommandLineKt.toCmakeArgument("-D" + (Object)((Object)name) + '=' + value);
            boolean bl5 = false;
            object3.add(commandLineArgument);
        }
        object = result;
        object2 = CmakeCommandLineKt.parseCmakeArguments($this$getCmakeCommandLineVariables.getVariant().getBuildSystemArgumentList());
        boolean bl6 = false;
        CollectionsKt.addAll((Collection)object, (Iterable)object2);
        return result;
    }

    private static final File getToolchainFile(@NotNull CxxAbiModel $this$getToolchainFile) {
        File file;
        if ($this$getToolchainFile.getVariant().getModule().getNdkVersion().getMajor() >= 15) {
            file = new File(LookupSettingFromModelKt.resolveMacroValue($this$getToolchainFile, Macro.NDK_CMAKE_TOOLCHAIN));
        } else {
            File toolchainFile = com.android.utils.FileUtils.join((File)$this$getToolchainFile.getCxxBuildFolder(), (String[])new String[]{"pre-ndk-r15-wrapper-android.toolchain.cmake"});
            FileUtils.writeStringToFile((File)toolchainFile, (String)StringsKt.trimIndent((String)("\n            # This toolchain file was generated by Gradle to support NDK versions r14 and below.\n            include(\"" + StringsKt.replace$default((String)LookupSettingFromModelKt.resolveMacroValue($this$getToolchainFile, Macro.NDK_CMAKE_TOOLCHAIN), (String)"\\", (String)"/", (boolean)false, (int)4, null) + "\")\n            set(" + (Object)((Object)CmakeProperty.CMAKE_SYSTEM_VERSION) + " 1)\n            ")));
            File file2 = toolchainFile;
            file = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"toolchainFile");
        }
        return file;
    }
}

