/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.cmake.MakeCmakeMessagePathsAbsoluteKt;
import com.android.build.gradle.internal.cxx.configure.CmakeCommandLineBuilderKt;
import com.android.build.gradle.internal.cxx.configure.CmakeCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class CmakeExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    protected final CxxCmakeModuleModel cmake;

    CmakeExternalNativeJsonGenerator(CxxVariantModel variant2, List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) {
        super(variant2, abis, stats);
        this.stats.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        this.cmake = Objects.requireNonNull(variant2.getModule().getCmake());
        File cmakelists = this.getMakefile();
        if (cmakelists.isDirectory()) {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path %s is a folder. It must be CMakeLists.txt", cmakelists);
        } else if (cmakelists.isFile()) {
            String filename = cmakelists.getName();
            if (!filename.equals("CMakeLists.txt")) {
                LoggingEnvironmentKt.errorln("Gradle project cmake.path specifies %s but it must be CMakeLists.txt", filename);
            }
        } else {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path is %s but that file doesn't exist", cmakelists);
        }
    }

    public abstract String executeProcessAndGetOutput(CxxAbiModel var1) throws ProcessException, IOException;

    @Override
    public String executeProcess(CxxAbiModel abi) throws ProcessException, IOException {
        String output2 = this.executeProcessAndGetOutput(abi);
        return MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(output2, this.getMakefile().getParentFile());
    }

    @Override
    void processBuildOutput(String buildOutput, CxxAbiModel abi) {
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(CxxAbiModel abi) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.cmake.getCmakeExe());
        ArrayList arguments = Lists.newArrayList();
        arguments.add(CommandLineArgument.CmakeListsPath.from(this.variant.getModule().getMakeFile().getParentFile().getPath()));
        arguments.add(CommandLineArgument.BinaryOutputPath.from(abi.getCxxBuildFolder().getPath()));
        arguments.addAll(CmakeCommandLineBuilderKt.getCmakeCommandLineVariables(abi));
        builder.addArgs(CmakeCommandLineKt.convertCmakeCommandLineArgumentsToStringList(arguments));
        return builder;
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.CMAKE;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        Stl stl = null;
        for (String argument : this.getBuildArguments()) {
            String stlName;
            if (!(argument = argument.replace(" ", "")).startsWith("-DANDROID_STL=") || (stl = Stl.fromArgumentName(stlName = argument.split("=", 2)[1])) != null) continue;
            LoggingEnvironmentKt.errorln("Unrecognized STL in arguments: %s", stlName);
        }
        if (stl == null) {
            return Maps.newHashMap();
        }
        return this.variant.getModule().getStlSharedObjectMap().get((Object)stl).entrySet().stream().filter(e -> this.getAbis().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

