/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.function.Supplier;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

public abstract class FeatureSplitDeclarationWriterTask
extends NonIncrementalTask {
    @VisibleForTesting
    String uniqueIdentifier;
    @VisibleForTesting
    Supplier<String> originalApplicationIdSupplier;

    @Input
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Input
    public String getApplicationId() {
        return this.originalApplicationIdSupplier.get();
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Override
    protected void doTaskAction() throws IOException {
        FeatureSplitDeclaration declaration = new FeatureSplitDeclaration(this.uniqueIdentifier, this.getApplicationId());
        declaration.save(((Directory)this.getOutputDirectory().get()).getAsFile());
    }

    public static class CreationAction
    extends VariantTaskCreationAction<FeatureSplitDeclarationWriterTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("feature", "Writer");
        }

        @Override
        public Class<FeatureSplitDeclarationWriterTask> getType() {
            return FeatureSplitDeclarationWriterTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends FeatureSplitDeclarationWriterTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.METADATA_FEATURE_DECLARATION, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, FeatureSplitDeclarationWriterTask::getOutputDirectory, "out");
        }

        @Override
        public void configure(FeatureSplitDeclarationWriterTask task) {
            super.configure(task);
            task.uniqueIdentifier = this.getVariantScope().getGlobalScope().getProject().getPath();
            task.originalApplicationIdSupplier = this.getVariantScope().getVariantConfiguration()::getOriginalApplicationId;
        }
    }
}

