/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTaskKt;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.ide.common.resources.FileStatus;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.BuildException;

public abstract class PackageSplitAbi
extends NonIncrementalTask {
    private boolean jniDebuggable;
    private FileCollection signingConfig;
    private FileCollection jniFolders;
    private AndroidVersion minSdkVersion;
    private File incrementalDir;
    private Collection<String> aaptOptionsNoCompress;
    private Set<String> splits;
    private boolean keepTimestampsInApk;
    private String createdBy;

    @InputFiles
    public abstract DirectoryProperty getProcessedAbiResources();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    @InputFiles
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getFeatureLevel();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public boolean getKeepTimestampsInApk() {
        return this.keepTimestampsInApk;
    }

    @Input
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    protected void doTaskAction() throws IOException {
        FileUtils.cleanOutputDir((File)this.incrementalDir);
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.ABI_PROCESSED_SPLIT_RES, (Provider<Directory>)this.getProcessedAbiResources()).transform(this.getWorkerFacadeWithWorkers(), PackageSplitAbiTransformRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, input) -> new PackageSplitAbiTransformParams((ApkData)apkInfo, (File)input, this))).into(InternalArtifactType.ABI_PACKAGED_SPLIT, ((Directory)this.getOutputDirectory().get()).getAsFile());
    }

    private static String getApkName(ApkData apkData, String archivesBaseName, boolean isSigned) {
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (isSigned ? "" : "-unsigned") + ".apk";
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageSplitAbi> {
        private final boolean packageCustomClassDependencies;

        public CreationAction(VariantScope scope, boolean packageCustomClassDependencies) {
            super(scope);
            this.packageCustomClassDependencies = packageCustomClassDependencies;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageSplitAbi> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageSplitAbiTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.ABI_PACKAGED_SPLIT, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, PackageSplitAbi::getOutputDirectory, "out");
        }

        @Override
        public void configure(PackageSplitAbi task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            GlobalScope globalScope = scope.getGlobalScope();
            GradleVariantConfiguration config2 = scope.getVariantConfiguration();
            scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.ABI_PROCESSED_SPLIT_RES, task.getProcessedAbiResources());
            task.signingConfig = scope.getSigningConfigFileCollection();
            task.minSdkVersion = config2.getMinSdkVersion();
            task.incrementalDir = scope.getIncrementalDir(task.getName());
            task.aaptOptionsNoCompress = globalScope.getExtension().getAaptOptions().getNoCompress();
            task.jniDebuggable = config2.getBuildType().isJniDebuggable();
            task.jniFolders = PerModuleBundleTaskKt.getNativeLibsFiles(scope, this.packageCustomClassDependencies);
            task.jniDebuggable = config2.getBuildType().isJniDebuggable();
            task.splits = scope.getVariantData().getFilters(VariantOutput.FilterType.ABI);
            task.keepTimestampsInApk = globalScope.getProjectOptions().get(BooleanOption.KEEP_TIMESTAMPS_IN_APK);
            task.createdBy = globalScope.getCreatedBy();
            MutableTaskContainer taskContainer = scope.getTaskContainer();
            if (taskContainer.getExternalNativeBuildTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getExternalNativeBuildTask()});
            }
        }
    }

    private static class PackageSplitAbiTransformParams
    extends BuildElementsTransformParams {
        private final File input;
        private final ApkData apkInfo;
        private final File output;
        private final File incrementalDir;
        private final File signingConfigFile;
        private final String createdBy;
        private final Collection<String> aaptOptionsNoCompress;
        private final Set<File> jniFolders;
        private final boolean keepTimestampsInApk;
        private final boolean isJniDebuggable;
        private final int minSdkVersion;

        PackageSplitAbiTransformParams(ApkData apkInfo, File input, PackageSplitAbi task) {
            this.apkInfo = apkInfo;
            this.input = input;
            this.output = new File(((Directory)task.getOutputDirectory().get()).getAsFile(), PackageSplitAbi.getApkName(apkInfo, (String)task.getProject().getProperties().get("archivesBaseName"), task.signingConfig != null));
            this.incrementalDir = task.incrementalDir;
            this.signingConfigFile = SigningConfigUtils.Companion.getOutputFile(task.signingConfig);
            this.createdBy = task.getCreatedBy();
            this.aaptOptionsNoCompress = task.aaptOptionsNoCompress;
            this.jniFolders = task.getJniFolders().getFiles();
            this.keepTimestampsInApk = task.getKeepTimestampsInApk();
            this.isJniDebuggable = task.jniDebuggable;
            this.minSdkVersion = task.getMinSdkVersion();
        }

        @Override
        public File getOutput() {
            return this.output;
        }
    }

    private static class PackageSplitAbiTransformRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public PackageSplitAbiTransformRunnable(PackageSplitAbiTransformParams params) {
            super(params);
        }

        @Override
        public void run() {
            PackageSplitAbiTransformParams params = (PackageSplitAbiTransformParams)this.getParams();
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder(IncrementalPackagerBuilder.ApkFormat.FILE).withOutputFile(params.getOutput()).withSigning(SigningConfigUtils.Companion.load(params.signingConfigFile), params.minSdkVersion).withCreatedBy(params.createdBy).withAaptOptionsNoCompress(params.aaptOptionsNoCompress).withIntermediateDir(params.incrementalDir).withKeepTimestampsInApk(params.keepTimestampsInApk).withDebuggableBuild(params.isJniDebuggable).withJniDebuggableBuild(params.isJniDebuggable).withAcceptedAbis((Set<String>)ImmutableSet.of((Object)params.apkInfo.getFilterName())).withApkCreatorType(ApkCreatorType.APK_Z_FILE_CREATOR).withChangedNativeLibs((Map<RelativeFile, FileStatus>)IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.jniFolders)).withChangedAndroidResources((Map<RelativeFile, FileStatus>)IncrementalRelativeFileSets.fromZip((File)params.input)).build();){
                pkg.updateFiles();
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

