/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment$WhenMappings;
import com.android.utils.ILogger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "close", "", "Companion", "gradle"})
public abstract class ThreadLoggingEnvironment
implements LoggingEnvironment {
    private static final ThreadLocal<Companion.LoggerStack> loggerStack;
    private static final Companion.BottomLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;
    public static final Companion Companion;

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    static {
        Companion = new Companion(null);
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"ThreadLocal.withInitial { null }");
        loggerStack = threadLocal;
        BOTTOM_LOGGING_ENVIRONMENT = new Companion.BottomLoggingEnvironment();
    }

    @JvmStatic
    @NotNull
    public static final LoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "()V", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "getILogger", "Lcom/android/utils/ILogger;", "parentLogger", "pop", "", "push", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "reportFormattedErrorToCurrentLogger", "message", "", "reportFormattedInfoToCurrentLogger", "reportFormattedWarningToCurrentLogger", "BottomLoggingEnvironment", "LoggerStack", "gradle"})
    public static final class Companion {
        private final LoggingEnvironment getLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        private final void push(ThreadLoggingEnvironment logger) {
            loggerStack.set(new LoggerStack(logger, (LoggerStack)loggerStack.get()));
        }

        private final void pop() {
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            loggerStack.set(loggerStack2 != null ? loggerStack2.getNext() : null);
        }

        @JvmStatic
        @NotNull
        public final LoggingEnvironment parentLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getNext()) == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.errorRecordOf(message));
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.warnRecordOf(message));
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.infoRecordOf(message));
        }

        @NotNull
        public final ILogger getILogger() {
            return new ILogger(){

                public void error(@Nullable Throwable t, @Nullable String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    if (t != null) {
                        throw t;
                    }
                    LoggingEnvironment loggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion);
                    String string = format;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    loggingEnvironment.log(LoggingMessageKt.errorRecordOf(LoggingEnvironmentKt.access$checkedFormat(string, args2)));
                }

                public void warning(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.warnRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args2)));
                }

                public void info(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args2)));
                }

                public void verbose(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args2)));
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ LoggingEnvironment access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "next", "(Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;)V", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getNext", "()Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle"})
        private static final class LoggerStack {
            @NotNull
            private final LoggingEnvironment logger;
            @Nullable
            private final LoggerStack next;

            @NotNull
            public final LoggingEnvironment getLogger() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack getNext() {
                return this.next;
            }

            public LoggerStack(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
                this.logger = logger;
                this.next = next;
            }

            @NotNull
            public final LoggingEnvironment component1() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack component2() {
                return this.next;
            }

            @NotNull
            public final LoggerStack copy(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
                return new LoggerStack(logger, next);
            }

            public static /* synthetic */ LoggerStack copy$default(LoggerStack loggerStack2, LoggingEnvironment loggingEnvironment, LoggerStack loggerStack3, int n, Object object) {
                if ((n & 1) != 0) {
                    loggingEnvironment = loggerStack2.logger;
                }
                if ((n & 2) != 0) {
                    loggerStack3 = loggerStack2.next;
                }
                return loggerStack2.copy(loggingEnvironment, loggerStack3);
            }

            @NotNull
            public String toString() {
                return "LoggerStack(logger=" + this.logger + ", next=" + this.next + ")";
            }

            public int hashCode() {
                LoggingEnvironment loggingEnvironment = this.logger;
                LoggerStack loggerStack2 = this.next;
                return (loggingEnvironment != null ? loggingEnvironment.hashCode() : 0) * 31 + (loggerStack2 != null ? ((Object)loggerStack2).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LoggerStack)) break block3;
                        LoggerStack loggerStack2 = (LoggerStack)object;
                        if (!Intrinsics.areEqual((Object)this.logger, (Object)loggerStack2.logger) || !Intrinsics.areEqual((Object)this.next, (Object)loggerStack2.next)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "log", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "gradle"})
        private static final class BottomLoggingEnvironment
        implements LoggingEnvironment {
            private final Logger logger = Logging.getLogger(BottomLoggingEnvironment.class);

            @Override
            public void log(@NotNull LoggingMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                switch (ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment$WhenMappings.$EnumSwitchMapping$0[message.getLevel().ordinal()]) {
                    case 1: {
                        this.logger.error(message.toString());
                        break;
                    }
                    case 2: {
                        this.logger.warn(message.toString());
                        break;
                    }
                    case 3: {
                        this.logger.info(message.toString());
                    }
                }
            }

            @Override
            public void close() {
            }
        }
    }
}

