/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J.\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J*\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ \u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "", "ndkRoot", "Ljava/io/File;", "(Ljava/io/File;)V", "platformNameAliases", "", "", "", "sensibleDefaultPlatformApiVersionForErrorCase", "veryHighPlatformApiVersion", "clamp", "minSdkVersion", "displayVersion", "Lcom/android/sdklib/AndroidVersion;", "min", "max", "computeMinSdkVersion", "abiName", "androidVersionOrNull", "displayVersionString", "findPlatformConfiguratorLegacy", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "platformDir", "findSuitablePlatformVersion", "androidVersion", "findSuitablePlatformVersionLogged", "ndkMetaPlatforms", "Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms;", "getLinkerSysrootPath", "platformVersion", "gradle"})
public final class PlatformConfigurator {
    private final int sensibleDefaultPlatformApiVersionForErrorCase = 22;
    private final int veryHighPlatformApiVersion = Integer.MAX_VALUE;
    private final Map<String, Integer> platformNameAliases;
    private final File ndkRoot;

    public final int findSuitablePlatformVersionLogged(@NotNull String abiName, @Nullable AndroidVersion androidVersionOrNull, @Nullable NdkMetaPlatforms ndkMetaPlatforms2) {
        Intrinsics.checkParameterIsNotNull((Object)abiName, (String)"abiName");
        Abi abi = Abi.getByName(abiName);
        if (abi == null) {
            PlatformConfigurator platformConfigurator = this;
            boolean bl = false;
            boolean bl2 = false;
            PlatformConfigurator $this$run = platformConfigurator;
            boolean bl3 = false;
            LoggingEnvironmentKt.errorln("Specified abi='" + abiName + "' is not recognized.", new Object[0]);
            return $this$run.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)abi), (String)"Abi.getByName(abiName) ?\u2026ionForErrorCase\n        }");
        Abi abi2 = abi;
        if (ndkMetaPlatforms2 == null) {
            File platformDir;
            File file = platformDir = FileUtils.join((File)this.ndkRoot, (String[])new String[]{"platforms"});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"platformDir");
            if (!file.isDirectory()) {
                LoggingEnvironmentKt.warnln("NDK folder '" + this.ndkRoot + "' specified does not contain 'platforms'.", new Object[0]);
                return this.sensibleDefaultPlatformApiVersionForErrorCase;
            }
            int minSdkVersion = this.computeMinSdkVersion(abiName, androidVersionOrNull, this.platformNameAliases);
            return this.findPlatformConfiguratorLegacy(abi2, minSdkVersion, androidVersionOrNull, platformDir);
        }
        int minSdkVersion = this.computeMinSdkVersion(abiName, androidVersionOrNull, ndkMetaPlatforms2.getAliases());
        return this.clamp(minSdkVersion, androidVersionOrNull, ndkMetaPlatforms2.getMin(), ndkMetaPlatforms2.getMax());
    }

    /*
     * Unable to fully structure code
     */
    private final int computeMinSdkVersion(String abiName, AndroidVersion androidVersionOrNull, Map<String, Integer> platformNameAliases) {
        v0 = androidVersionOrNull;
        minSdkVersionOrNull = v0 != null ? Integer.valueOf(v0.getApiLevel()) : null;
        v1 = androidVersionOrNull;
        codeNameOrNull = v1 != null ? v1.getCodename() : null;
        if (codeNameOrNull == null) ** GOTO lbl-1000
        var7_6 = codeNameOrNull;
        var8_8 = 0;
        if (var7_6.length() == 0) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            lookup = platformNameAliases.get(codeNameOrNull);
            if (lookup != null) {
                LoggingEnvironmentKt.infoln("Version minSdkVersion='" + codeNameOrNull + "' is mapped to '" + lookup + "'.", new Object[0]);
                v3 = lookup;
            } else {
                LoggingEnvironmentKt.errorln("API codeName '" + codeNameOrNull + "' is not supported by NDK '" + this.ndkRoot + "'.", new Object[0]);
                v3 = this.veryHighPlatformApiVersion;
            }
            v2 = v3;
        }
        minSdkVersionFromCodeName = v2;
        v4 = minSdkVersionOrNull;
        v5 = AndroidVersion.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"AndroidVersion.DEFAULT");
        var8_8 = v5.getApiLevel();
        minSdkVersionIsDefault = v4 != null && v4 == var8_8;
        if (minSdkVersionIsDefault && minSdkVersionFromCodeName == null) {
            LoggingEnvironmentKt.infoln("Neither codeName nor minSdkVersion specified. Using minimum platform " + "version for '" + abiName + "'.", new Object[0]);
            v6 = 0;
        } else if (!minSdkVersionIsDefault && minSdkVersionFromCodeName != null) {
            var8_9 = minSdkVersionOrNull;
            if (Intrinsics.areEqual((Object)var8_9, minSdkVersionFromCodeName)) {
                LoggingEnvironmentKt.warnln("Both codeName and minSdkVersion specified. They agree but only one should be specified.", new Object[0]);
                v6 = minSdkVersionOrNull;
            } else {
                LoggingEnvironmentKt.warnln("Disagreement between codeName='" + codeNameOrNull + "' " + "and minSdkVersion='" + minSdkVersionOrNull + "'. Only one " + "should be specified.", new Object[0]);
                v6 = minSdkVersionOrNull;
            }
        } else if (minSdkVersionIsDefault) {
            v6 = minSdkVersionFromCodeName;
        } else {
            lookup = platformNameAliases.get(String.valueOf(minSdkVersionOrNull));
            if (lookup != null) {
                v7 = new StringBuilder().append("Version minSdkVersion='");
                v8 = minSdkVersionOrNull;
                if (v8 == null) {
                    Intrinsics.throwNpe();
                }
                LoggingEnvironmentKt.infoln(v7.append(this.displayVersionString(v8, androidVersionOrNull)).append("' is mapped to '").append(lookup).append("'.").toString(), new Object[0]);
                return lookup;
            }
            v6 = minSdkVersionOrNull;
        }
        return v6 != null ? v6 : 22;
    }

    /*
     * WARNING - void declaration
     */
    private final int findPlatformConfiguratorLegacy(Abi abi, int minSdkVersion, AndroidVersion displayVersion, File platformDir) {
        int max;
        int clamped;
        void $this$mapNotNullTo$iv$iv;
        Object $this$filterTo$iv$iv;
        String linkerSysrootPath = this.getLinkerSysrootPath(this.ndkRoot, abi, "android-" + minSdkVersion);
        if (new File(linkerSysrootPath).isDirectory()) {
            return minSdkVersion;
        }
        File[] $this$orEmpty$iv = platformDir.listFiles(findPlatformConfiguratorLegacy.platformSubDirs.1.INSTANCE);
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            fileArray = new File[]{};
        }
        File[] platformSubDirs2 = fileArray;
        Object $this$filter$iv = platformSubDirs2;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = ((void)iterator).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            if (!StringsKt.startsWith$default((String)string, (String)"android-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            File it = (File)element$iv$iv;
            boolean bl = false;
            File file = FileUtils.join((File)it, (String[])new String[]{"arch-" + abi.getArchitecture()});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(it, \"arch-\" + abi.architecture)");
            if (!file.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n2;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)file.getName(), (String)"it.name");
            int n3 = "android-".length();
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            Integer version = StringsKt.toIntOrNull((String)string3);
            if (version == null) {
                LoggingEnvironmentKt.infoln("Found non-numeric platform folder '" + it.getName() + "'. Ignoring.", new Object[0]);
            }
            if (version == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            Integer it$iv$iv = n2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List versions = (List)destination$iv$iv;
        if (versions.isEmpty()) {
            LoggingEnvironmentKt.errorln("Abi '" + (Object)((Object)abi) + "' is not recognized in '" + this.ndkRoot + "'.", new Object[0]);
            return this.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        Comparable comparable = CollectionsKt.min((Iterable)versions);
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        int min = ((Number)((Object)comparable)).intValue();
        Comparable comparable2 = CollectionsKt.max((Iterable)versions);
        if (comparable2 == null) {
            Intrinsics.throwNpe();
        }
        if (!versions.contains(clamped = this.clamp(minSdkVersion, displayVersion, min, max = ((Number)((Object)comparable2)).intValue()))) {
            LoggingEnvironmentKt.warnln("Expected platform folder platforms/android-" + clamped + ", " + "using platform API " + min + " instead.", new Object[0]);
            return min;
        }
        return clamped;
    }

    private final int clamp(int minSdkVersion, AndroidVersion displayVersion, int min, int max) {
        int n;
        if (minSdkVersion < min) {
            n = min;
        } else if (minSdkVersion > max) {
            if (minSdkVersion < this.veryHighPlatformApiVersion) {
                LoggingEnvironmentKt.warnln("Platform version '" + this.displayVersionString(minSdkVersion, displayVersion) + "' is beyond '" + max + "', the maximum API level supported by this NDK.", new Object[0]);
            }
            n = max;
        } else {
            n = minSdkVersion;
        }
        return n;
    }

    private final String displayVersionString(int minSdkVersion, AndroidVersion displayVersion) {
        String string;
        if (displayVersion == null) {
            string = String.valueOf(minSdkVersion);
        } else {
            int n = displayVersion.getApiLevel();
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"AndroidVersion.DEFAULT");
            String string2 = n == androidVersion.getApiLevel() ? displayVersion.getApiString() : String.valueOf(displayVersion.getApiLevel());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (displayVersion.apiLe\u2026.toString()\n            }");
        }
        return string;
    }

    public final int findSuitablePlatformVersion(@NotNull String abiName, @Nullable AndroidVersion androidVersion) {
        Intrinsics.checkParameterIsNotNull((Object)abiName, (String)"abiName");
        File ndkMetaPlatformsFile = NdkMetaPlatforms.Companion.jsonFile(this.ndkRoot);
        NdkMetaPlatforms ndkMetaPlatforms2 = ndkMetaPlatformsFile.isFile() ? NdkMetaPlatforms.Companion.fromReader(new FileReader(ndkMetaPlatformsFile)) : null;
        return this.findSuitablePlatformVersionLogged(abiName, androidVersion, ndkMetaPlatforms2);
    }

    private final String getLinkerSysrootPath(File ndkRoot, Abi abi, String platformVersion) {
        String string = FileUtils.join((String[])new String[]{ndkRoot.getPath(), "platforms", platformVersion, "arch-" + abi.getArchitecture()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtils.join(\n        \u2026bi.architecture\n        )");
        return string;
    }

    public PlatformConfigurator(@NotNull File ndkRoot) {
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        this.ndkRoot = ndkRoot;
        this.sensibleDefaultPlatformApiVersionForErrorCase = 22;
        this.veryHighPlatformApiVersion = Integer.MAX_VALUE;
        this.platformNameAliases = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"20", (Object)19), TuplesKt.to((Object)"25", (Object)24), TuplesKt.to((Object)"J", (Object)16), TuplesKt.to((Object)"J-MR1", (Object)17), TuplesKt.to((Object)"J-MR2", (Object)18), TuplesKt.to((Object)"K", (Object)19), TuplesKt.to((Object)"L", (Object)21), TuplesKt.to((Object)"L-MR1", (Object)22), TuplesKt.to((Object)"M", (Object)23), TuplesKt.to((Object)"N", (Object)24), TuplesKt.to((Object)"N-MR1", (Object)24), TuplesKt.to((Object)"O", (Object)26), TuplesKt.to((Object)"O-MR1", (Object)27), TuplesKt.to((Object)"P", (Object)28)});
    }
}

