/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.ConfigurationVariantMapping;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BundleLibraryClasses;
import com.android.build.gradle.internal.tasks.BundleLibraryJavaRes;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.build.gradle.internal.tasks.LibraryDexingTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    public LibraryTaskManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, BaseExtension extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope, List<VariantScope> variantScopesForLint) {
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        GlobalScope globalScope = variantScope.getGlobalScope();
        this.createAnchorTasks(variantScope);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(variantScope));
        this.createDependencyStreams(variantScope);
        this.taskFactory.register(new BuildArtifactReportTask.BuildArtifactReportCreationAction(variantScope));
        this.createGenerateResValuesTask(variantScope);
        this.taskFactory.register(new CheckManifest.CreationAction(variantScope));
        this.createMergeLibManifestsTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTasks(variantScope);
        this.createCompileLibraryResourcesTask(variantScope);
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createLibraryAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createProcessResTask(variantScope, null, TaskManager.MergeType.PACKAGE, globalScope.getProjectBaseName());
        if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() && !variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            this.createVerifyLibraryResTask(variantScope);
        }
        this.registerLibraryRClassTransformStream(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createDataBindingTasksIfNecessary(variantScope);
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, variantScope);
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(variantScope));
        this.createExternalNativeBuildJsonGenerators(variantScope);
        this.createExternalNativeBuildTasks(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(variantScope));
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(variantScope));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(variantScope));
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(variantScope));
        if (this.projectOptions.get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(variantScope));
        }
        boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled();
        TransformManager transformManager = variantScope.getTransformManager();
        if (instrumented) {
            this.createJacocoTask(variantScope);
        }
        List<Transform> customTransforms = this.extension.getTransforms();
        List<List<Object>> customTransformsDependencies = this.extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
            if (!difference.isEmpty()) {
                String scopes = difference.toString();
                globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes));
            }
            List<Object> deps = customTransformsDependencies.get(i2);
            transformManager.addTransform(this.taskFactory, variantScope, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        this.taskFactory.register(new BundleLibraryClasses.CreationAction(variantScope, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS, this.excludeDataBindingClassesIfNecessary(variantScope)));
        this.taskFactory.register(new BundleLibraryJavaRes.CreationAction(variantScope));
        this.taskFactory.register(new LibraryDexingTask.CreationAction(variantScope));
        this.taskFactory.register(new ZipMergingTask.CreationAction(variantScope));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectOnlyCreationAction(variantScope, InternalArtifactType.LIBRARY_JNI));
        this.createMergeJavaResTask(variantScope);
        this.maybeCreateJavaCodeShrinkerTransform(variantScope);
        this.maybeCreateResourcesShrinkerTasks(variantScope);
        this.taskFactory.register(new LibraryAarJarsTask.CreationAction(variantScope, this.extension.getPackageBuildConfig(), this.excludeDataBindingClassesIfNecessary(variantScope)));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectAndLocalJarsCreationAction(variantScope, InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI));
        this.createLintTasks(variantScope, variantScopesForLint);
        this.createBundleTask(variantScope);
    }

    private void registerLibraryRClassTransformStream(VariantScope variantScope) {
        InternalArtifactType rClassJar = this.globalScope.getExtension().getAaptOptions().getNamespaced() ? InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR : InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR;
        QualifiedContent.Scope scopeType = variantScope.getCodeShrinker() != null ? QualifiedContent.Scope.PROJECT : QualifiedContent.Scope.PROVIDED_ONLY;
        ConfigurableFileCollection compileRClass = this.project.files(new Object[]{variantScope.getArtifacts().getFinalProduct(rClassJar)});
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "compile-only-r-class").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)scopeType).setFileCollection((FileCollection)compileRClass).build());
    }

    private void createBundleTask(VariantScope variantScope) {
        TaskProvider<BundleAar> bundle = this.taskFactory.register(new BundleAar.CreationAction(variantScope));
        TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), bundle);
        VariantDependencies variantDependencies = variantScope.getVariantDependencies();
        AdhocComponentWithVariants component = this.globalScope.getComponentFactory().adhoc(variantScope.getFullVariantName());
        Configuration apiPub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.API_PUBLICATION);
        Configuration runtimePub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION);
        component.addVariantsFromConfiguration(apiPub, (Action)new ConfigurationVariantMapping("compile", false));
        component.addVariantsFromConfiguration(runtimePub, (Action)new ConfigurationVariantMapping("runtime", false));
        this.project.getComponents().add((Object)component);
        if (this.extension.getDefaultPublishConfig().equals(variantScope.getVariantConfiguration().getFullName())) {
            VariantHelper.setupArchivesConfig(this.project, variantDependencies.getRuntimeClasspath());
            this.project.getArtifacts().add("default", bundle);
        }
    }

    @Override
    protected void createDependencyStreams(VariantScope variantScope) {
        super.createDependencyStreams(variantScope);
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(variantScope.getLocalPackagedJars()).build());
    }

    private void createMergeResourcesTasks(VariantScope variantScope) {
        ImmutableSet flags = variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced() ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES}) : Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
        MergeResourceCallback callback = new MergeResourceCallback(variantScope);
        this.basicCreateMergeResourcesTask(variantScope, TaskManager.MergeType.PACKAGE, variantScope.getIntermediateDir(InternalArtifactType.PACKAGED_RES), false, false, false, (ImmutableSet<MergeResources.Flag>)flags, callback);
        this.createMergeResourcesTask(variantScope, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
    }

    private void createCompileLibraryResourcesTask(VariantScope variantScope) {
        if (variantScope.isPrecompileDependenciesResourcesEnabled()) {
            this.taskFactory.register(new CompileLibraryResourcesTask.CreationAction(variantScope));
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection files = scope.getGlobalScope().getProject().files(new Object[]{scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC), scope.getVariantData().getAllPreJavacGeneratedBytecode(), scope.getVariantData().getAllPostJavacGeneratedBytecode()});
        scope.getArtifacts().appendToAllClasses((FileCollection)files);
        this.taskFactory.register(new BundleLibraryClasses.CreationAction(scope, AndroidArtifacts.PublishedConfigType.API_ELEMENTS, this.excludeDataBindingClassesIfNecessary(scope)));
    }

    private Supplier<List<String>> excludeDataBindingClassesIfNecessary(VariantScope variantScope) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return Collections::emptyList;
        }
        return () -> {
            File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
            File dependencyArtifactsDir = ((FileSystemLocation)variantScope.getArtifacts().getFinalProduct(InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS).get()).getAsFile();
            return this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile, dependencyArtifactsDir);
        };
    }

    public void createLibraryAssetsTask(VariantScope scope) {
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(scope));
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(VariantScope variantScope, QualifiedContent.ContentType contentType) {
        Preconditions.checkArgument((contentType == QualifiedContent.DefaultContentType.RESOURCES || contentType == ExtendedContentType.NATIVE_LIBS ? 1 : 0) != 0, (Object)"contentType must be RESOURCES or NATIVE_LIBS");
        if (variantScope.getTestedVariantData() != null) {
            if (contentType == QualifiedContent.DefaultContentType.RESOURCES) {
                return TransformManager.SCOPE_FULL_PROJECT_WITH_LOCAL_JARS;
            }
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        if (contentType == QualifiedContent.DefaultContentType.RESOURCES) {
            return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
        }
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    public void createVerifyLibraryResTask(VariantScope scope) {
        TaskProvider<VerifyLibraryResourcesTask> verifyLibraryResources = this.taskFactory.register(new VerifyLibraryResourcesTask.CreationAction(scope));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getAssembleTask(), verifyLibraryResources);
    }

    private static class MergeResourceCallback
    implements TaskProviderCallback<MergeResources> {
        private final VariantScope variantScope;

        private MergeResourceCallback(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeResources> taskProvider) {
            this.variantScope.getArtifacts().producesFile(InternalArtifactType.PUBLIC_RES, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, MergeResources::getPublicFile, "public.txt");
        }
    }
}

