/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.Library;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"buildBuildTools", "Lcom/android/sdklib/BuildToolInfo;", "sdkDirectory", "Ljava/io/File;", "revision", "Lcom/android/repository/Revision;", "parseAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "localPackage", "Lcom/android/repository/api/LocalPackage;", "parseOptionalLibraries", "parsePackage", "packageXml", "gradle"})
public final class SdkParsingUtilsKt {
    @Nullable
    public static final BuildToolInfo buildBuildTools(@NotNull File sdkDirectory, @NotNull Revision revision) {
        Intrinsics.checkParameterIsNotNull((Object)sdkDirectory, (String)"sdkDirectory");
        Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
        String string = DetailsTypes.getBuildToolsPath((Revision)revision);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DetailsTypes.getBuildToolsPath(revision)");
        String buildToolsPath = StringsKt.replace$default((String)string, (char)';', (char)'/', (boolean)false, (int)4, null);
        File buildToolsXml = FilesKt.resolve((File)FilesKt.resolve((File)sdkDirectory, (String)buildToolsPath), (String)"package.xml");
        LocalPackage localPackage = SdkParsingUtilsKt.parsePackage(buildToolsXml);
        if (localPackage == null) {
            return null;
        }
        LocalPackage buildToolsPackage = localPackage;
        BuildToolInfo buildToolInfo = BuildToolInfo.fromLocalPackage((LocalPackage)buildToolsPackage);
        if (!buildToolInfo.isValid(null)) {
            return null;
        }
        BuildToolInfo buildToolInfo2 = buildToolInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildToolInfo2, (String)"buildToolInfo");
        if (!buildToolInfo2.getRevision().equals((Object)revision)) {
            return null;
        }
        return buildToolInfo;
    }

    @Nullable
    public static final LocalPackage parsePackage(@NotNull File packageXml) {
        Repository repo;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)packageXml, (String)"packageXml");
            if (!packageXml.exists()) {
                return null;
            }
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            repo = null;
            try {
                Object parsedObject;
                Object object = SchemaModuleUtil.unmarshal((InputStream)new FileInputStream(packageXml), (Collection)AndroidSdkHandler.getAllModules(), (boolean)false, (ProgressIndicator)((ProgressIndicator)progress));
                if (object == null) {
                    return null;
                }
                Object object2 = parsedObject = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.repository.api.Repository");
                }
                repo = (Repository)object2;
            }
            catch (IOException e) {
                progress.logError("Error parsing " + packageXml + '.', (Throwable)e);
                return null;
            }
            Repository repository = repo;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repo");
            }
            LocalPackage localPackage = repository.getLocalPackage();
            if (localPackage == null) break block6;
            localPackage.setInstalledPath(packageXml.getParentFile());
        }
        return repo.getLocalPackage();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<OptionalLibrary> parseAdditionalLibraries(@NotNull LocalPackage localPackage) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)localPackage, (String)"localPackage");
        if (!(localPackage.getTypeDetails() instanceof DetailsTypes.AddonDetailsType)) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        TypeDetails typeDetails = localPackage.getTypeDetails();
        if (typeDetails == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.AddonDetailsType");
        }
        DetailsTypes.AddonDetailsType details = (DetailsTypes.AddonDetailsType)typeDetails;
        DetailsTypes.AddonDetailsType.Libraries libraries = details.getLibraries();
        if (libraries != null) {
            void $this$filterTo$iv$iv;
            DetailsTypes.AddonDetailsType.Libraries libraries2 = libraries;
            boolean bl = false;
            boolean bl2 = false;
            DetailsTypes.AddonDetailsType.Libraries libraries3 = libraries2;
            boolean bl3 = false;
            List list2 = libraries3.getLibrary();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"libraries.library");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Library it = (Library)element$iv$iv;
                boolean bl4 = false;
                Library library = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)library, (String)"it");
                if (!(library.getLocalJarPath() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            iterable = $this$onEach$iv;
            boolean bl5 = false;
            boolean bl6 = false;
            Iterable $this$apply$iv = iterable;
            boolean bl7 = false;
            for (Object element$iv : $this$apply$iv) {
                Library it = (Library)element$iv;
                boolean bl8 = false;
                it.setPackagePath(localPackage.getLocation());
            }
            list = (List)iterable;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<OptionalLibrary> parseOptionalLibraries(@NotNull LocalPackage localPackage) {
        Intrinsics.checkParameterIsNotNull((Object)localPackage, (String)"localPackage");
        File optionalJson = new File(localPackage.getLocation(), "optional/optional.json");
        if (optionalJson.isFile()) {
            List list = PlatformTarget.getLibsFromJson((File)optionalJson);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PlatformTarget.getLibsFromJson(optionalJson)");
            return list;
        }
        return CollectionsKt.emptyList();
    }
}

