/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.errors.EvalIssueException;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

public abstract class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseFeature;
    private boolean hasFeaturePlugin;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @Override
    public void doTaskAction() throws IOException {
        Project project2 = this.getProject();
        if (!this.isBaseFeature) {
            ExportConsumerProguardFilesTask.checkProguardFiles(project2, this.isDynamicFeature, this.hasFeaturePlugin, this.getConsumerProguardFiles().getFiles(), errorMessage -> {
                throw new EvalIssueException(errorMessage);
            });
        }
        super.doTaskAction();
    }

    public static class CreationAction
    extends TaskCreationAction<MergeConsumerProguardFilesTask> {
        private final VariantScope variantScope;

        public CreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeConsumerProguardFilesTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.variantScope.getArtifacts().producesFile(InternalArtifactType.MERGED_CONSUMER_PROGUARD_FILE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, MergeFileTask::getOutputFile, "proguard.txt");
        }

        @Override
        public void configure(MergeConsumerProguardFilesTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            Project project2 = globalScope.getProject();
            task.hasFeaturePlugin = project2.getPlugins().hasPlugin(FeaturePlugin.class);
            task.isBaseFeature = task.hasFeaturePlugin && globalScope.getExtension().getBaseFeature() != false;
            if (task.isBaseFeature) {
                task.isDynamicFeature = this.variantScope.getType().isDynamicFeature();
            }
            task.getConsumerProguardFiles().from(new Object[]{this.variantScope.getConsumerProguardFilesForFeatures()});
            ConfigurableFileCollection inputFiles2 = project2.files(new Object[]{task.getConsumerProguardFiles(), this.variantScope.getArtifacts().getFinalProduct(InternalArtifactType.GENERATED_PROGUARD_FILE)});
            task.setInputFiles((FileCollection)inputFiles2);
        }
    }
}

