/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.ide.BuildOutputsSupplier;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultProjectSyncIssues;
import com.android.build.gradle.internal.ide.DefaultTestVariantBuildOutput;
import com.android.build.gradle.internal.ide.DefaultVariantBuildOutput;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.ide.FailsafeModelBuilderParameter;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SigningConfigImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.StudioVersions;
import com.android.build.gradle.internal.ide.TestOptionsImpl;
import com.android.build.gradle.internal.ide.TestedTargetVariantImpl;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.ViewBindingOptionsImpl;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilderKt;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesUtils;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.GlobalLibraryMapImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.ProjectSyncIssues;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildOutput;
import com.android.builder.model.ViewBindingOptions;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class ModelBuilder<Extension extends BaseExtension>
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    protected final GlobalScope globalScope;
    protected final Extension extension;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private final TaskManager taskManager;
    private final int projectType;
    private int modelLevel = 0;
    private boolean modelWithFullDependency = false;
    private ImmutableMap<String, String> buildMapping = null;

    public ModelBuilder(GlobalScope globalScope, VariantManager variantManager, TaskManager taskManager, Extension extension, ExtraModelInfo extraModelInfo, int projectType) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
        this.taskManager = taskManager;
        this.projectType = projectType;
    }

    public static void clearCaches() {
        LibraryUtils.clearCaches();
        MavenCoordinatesUtils.clearMavenCaches();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(GlobalLibraryMap.class.getName()) || modelName.equals(ProjectBuildOutput.class.getName()) || modelName.equals(Variant.class.getName()) || modelName.equals(ProjectSyncIssues.class.getName());
    }

    public Object buildAll(String modelName, Project project2) {
        this.initBuildMapping(project2);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, true);
        }
        if (modelName.equals(Variant.class.getName())) {
            throw new RuntimeException("Please use parameterized tooling API to obtain Variant model.");
        }
        return this.buildNonParameterizedModels(modelName);
    }

    public Object buildAll(String modelName, ModelBuilderParameter parameter, Project project2) {
        parameter = new FailsafeModelBuilderParameter(parameter);
        this.initBuildMapping(project2);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, parameter.getShouldBuildVariant());
        }
        if (modelName.equals(Variant.class.getName())) {
            return this.buildVariant(project2, parameter.getVariantName(), parameter.getShouldGenerateSources());
        }
        return this.buildNonParameterizedModels(modelName);
    }

    private Object buildNonParameterizedModels(String modelName) {
        if (modelName.equals(ProjectBuildOutput.class.getName())) {
            return this.buildMinimalisticModel();
        }
        if (modelName.equals(GlobalLibraryMap.class.getName())) {
            return ModelBuilder.buildGlobalLibraryMap();
        }
        if (modelName.equals(ProjectSyncIssues.class.getName())) {
            return this.buildProjectSyncIssuesModel();
        }
        throw new RuntimeException("Invalid model requested: " + modelName);
    }

    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    @VisibleForTesting
    ProjectBuildOutput buildMinimalisticModel() {
        boolean isTestComponent;
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        ArrayListMultimap sortedVariants = ArrayListMultimap.create();
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isTestComponent = variantScope.getVariantData().getType().isTestComponent();
            if (!isTestComponent || variantScope.getTestedVariantData() == null) continue;
            sortedVariants.put((Object)variantScope.getTestedVariantData().getScope(), (Object)variantScope);
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isTestComponent = variantScope.getType().isTestComponent();
            if (isTestComponent) continue;
            Collection testingVariants = sortedVariants.get((Object)variantScope);
            Object testVariantBuildOutputs = testingVariants == null ? ImmutableList.of() : (Collection)testingVariants.stream().map(testVariantScope -> new DefaultTestVariantBuildOutput(testVariantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(testVariantScope.getVariantData()).get(), variantScope.getFullVariantName(), testVariantScope.getType() == VariantTypeImpl.ANDROID_TEST ? TestVariantBuildOutput.TestType.ANDROID_TEST : TestVariantBuildOutput.TestType.UNIT)).collect(Collectors.toList());
            variantsOutput.add((Object)new DefaultVariantBuildOutput(variantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(variantScope.getVariantData()).get(), (Collection<TestVariantBuildOutput>)testVariantBuildOutputs));
        }
        return new DefaultProjectBuildOutput((ImmutableList<VariantBuildOutput>)variantsOutput.build());
    }

    private static Object buildGlobalLibraryMap() {
        return new GlobalLibraryMapImpl(LibraryUtils.getGlobalLibMap());
    }

    private Object buildProjectSyncIssuesModel() {
        this.extraModelInfo.getSyncIssueHandler().lockHandler();
        return new DefaultProjectSyncIssues((Collection<? extends SyncIssue>)ImmutableSet.copyOf(this.extraModelInfo.getSyncIssueHandler().getSyncIssues()));
    }

    private Object buildAndroidProject(Project project2, boolean shouldBuildVariant) {
        List<String> bootClasspath2;
        ProjectOptions projectOptions = new ProjectOptions(project2);
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        StudioVersions.verifyStudioIsNotOld(projectOptions);
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        if (((Boolean)this.globalScope.getSdkComponents().getSdkSetupCorrectly().get()).booleanValue()) {
            List bootClasspath3 = this.globalScope.getFilteredBootClasspath().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList());
        } else {
            bootClasspath2 = Collections.emptyList();
        }
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.Companion.getTestComponents()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        com.android.builder.model.LintOptions lintOptions = LintOptions.create(((BaseExtension)this.extension).getLintOptions());
        AaptOptions aaptOptions = AaptOptionsImpl.create(((BaseExtension)this.extension).getAaptOptions());
        ViewBindingOptions viewBindingOptions = ViewBindingOptionsImpl.create(((BaseExtension)this.extension).getViewBinding());
        ArrayList flavorDimensionList = ((BaseExtension)this.extension).getFlavorDimensionList() != null ? ((BaseExtension)this.extension).getFlavorDimensionList() : Lists.newArrayList();
        ProductFlavorContainer defaultConfig = ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName()));
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        ArrayList variantNames = Lists.newArrayList();
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        String defaultVariant = this.variantManager.getDefaultVariant(this.extraModelInfo.getSyncIssueHandler());
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent()) continue;
            variantNames.add(variantScope.getFullVariantName());
            if (!shouldBuildVariant) continue;
            variants.add(this.createVariant(variantScope.getVariantData()));
        }
        String string = project2.getGroup().toString();
        return new DefaultAndroidProject(project2.getName(), string, defaultConfig, flavorDimensionList, buildTypes, productFlavors, variants, variantNames, defaultVariant, this.globalScope.getExtension().getCompileSdkVersion(), bootClasspath2, frameworkSource, ModelBuilder.cloneSigningConfigs(((BaseExtension)this.extension).getSigningConfigs()), aaptOptions, artifactMetaDataList, (Collection<SyncIssue>)ImmutableList.of(), ((BaseExtension)this.extension).getCompileOptions(), lintOptions, project2.getBuildDir(), ((BaseExtension)this.extension).getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.of(), ((BaseExtension)this.extension).getBuildToolsVersion(), this.projectType, Version.BUILDER_MODEL_API_VERSION, this.isBaseSplit(), this.getDynamicFeatures(), viewBindingOptions);
    }

    protected boolean isBaseSplit() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean inspectManifestForInstantTag(BaseVariantData variantData) {
        if (this.projectType != 0 && this.projectType != 6) {
            return false;
        }
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        ArrayList<File> manifests = new ArrayList<File>(variantConfiguration.getManifestOverlays());
        File mainManifest = variantConfiguration.getMainManifestIfExists();
        if (mainManifest != null) {
            manifests.add(mainManifest);
        }
        if (manifests.isEmpty()) {
            return false;
        }
        Iterator iterator = manifests.iterator();
        while (iterator.hasNext()) {
            File manifest = (File)iterator.next();
            try {
                FileInputStream inputStream = new FileInputStream(manifest);
                Throwable throwable = null;
                try {
                    XMLInputFactory factory2 = XMLInputFactory.newInstance();
                    XMLEventReader eventReader = factory2.createXMLEventReader(inputStream);
                    while (eventReader.hasNext() && !eventReader.peek().isEndDocument()) {
                        XMLEvent event = eventReader.nextTag();
                        if (event.isStartElement()) {
                            Attribute instant;
                            StartElement startElement = event.asStartElement();
                            if (!startElement.getName().getNamespaceURI().equals("http://schemas.android.com/apk/distribution") || !startElement.getName().getLocalPart().equalsIgnoreCase("module") || (instant = startElement.getAttributeByName(new QName("http://schemas.android.com/apk/distribution", "instant"))) == null || !instant.getValue().equals("true") && !instant.getValue().equals("1")) continue;
                            eventReader.close();
                            boolean bl = true;
                            return bl;
                        }
                        if (!event.isEndElement() || !((EndElement)event).getName().getLocalPart().equalsIgnoreCase("manifest")) continue;
                    }
                    eventReader.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException | XMLStreamException e) {
                this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        return false;
    }

    protected Collection<String> getDynamicFeatures() {
        return ImmutableList.of();
    }

    private VariantImpl buildVariant(Project project2, String variantName, boolean shouldScheduleSourceGeneration) {
        if (variantName == null) {
            throw new IllegalArgumentException("Variant name cannot be null.");
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent() || !variantScope.getFullVariantName().equals(variantName)) continue;
            VariantImpl variant2 = this.createVariant(variantScope.getVariantData());
            if (shouldScheduleSourceGeneration) {
                ModelBuilder.scheduleSourceGeneration(project2, variant2);
            }
            return variant2;
        }
        throw new IllegalArgumentException(String.format("Variant with name '%s' doesn't exist.", variantName));
    }

    private static void scheduleSourceGeneration(Project project2, Variant variant2) {
        ArrayList artifacts2 = Lists.newArrayList((Object[])new BaseArtifact[]{variant2.getMainArtifact()});
        artifacts2.addAll(variant2.getExtraAndroidArtifacts());
        artifacts2.addAll(variant2.getExtraJavaArtifacts());
        Set sourceGenerationTasks = artifacts2.stream().map(BaseArtifact::getIdeSetupTaskNames).flatMap(Collection::stream).map(taskName -> project2.getPath() + ":" + taskName).collect(Collectors.toSet());
        try {
            StartParameter startParameter = project2.getGradle().getStartParameter();
            HashSet tasks = new HashSet(startParameter.getTaskNames());
            tasks.addAll(sourceGenerationTasks);
            startParameter.setTaskNames(tasks);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't modify scheduled tasks at current build step", e);
        }
    }

    private VariantImpl createVariant(BaseVariantData variantData) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", variantData);
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        File manifest = variantConfiguration.getMainManifestIfExists();
        if (manifest != null) {
            DefaultManifestParser attributeSupplier = new DefaultManifestParser(manifest, () -> true, (EvalIssueReporter)this.extraModelInfo.getSyncIssueHandler());
            try {
                this.validateMinSdkVersion((ManifestAttributeSupplier)attributeSupplier);
                this.validateTargetSdkVersion((ManifestAttributeSupplier)attributeSupplier);
            }
            catch (Throwable e) {
                this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        String variantName = variantConfiguration.getFullName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        List<JavaArtifact> clonedExtraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName).stream().map(javaArtifact -> JavaArtifactImpl.clone(javaArtifact, this.modelLevel, this.modelWithFullDependency)).collect(Collectors.toList());
        if (variantData instanceof TestedVariantData) {
            block6: for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                TestVariantData testVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData(variantType);
                if (testVariantData == null) continue;
                switch ((VariantTypeImpl)variantType) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariantData));
                        continue block6;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariantData));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        Collection<TestedTargetVariant> testTargetVariants = this.getTestTargetVariants(variantData);
        this.checkProguardFiles(variantData.getScope());
        return new VariantImpl(variantName, variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), ModelBuilder.getProductFlavorNames(variantData), new ProductFlavorImpl(variantConfiguration.getMergedFlavor()), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts, testTargetVariants, this.inspectManifestForInstantTag(variantData));
    }

    private void checkProguardFiles(VariantScope variantScope) {
        boolean isBaseFeature;
        GlobalScope globalScope = variantScope.getGlobalScope();
        Project project2 = globalScope.getProject();
        boolean hasFeaturePlugin = project2.getPlugins().hasPlugin(FeaturePlugin.class);
        boolean bl = isBaseFeature = hasFeaturePlugin && globalScope.getExtension().getBaseFeature() != false;
        if (!isBaseFeature) {
            List<File> consumerProguardFiles2 = variantScope.getConsumerProguardFilesForFeatures();
            boolean isDynamicFeature = variantScope.getType().isDynamicFeature();
            ExportConsumerProguardFilesTask.checkProguardFiles(project2, isDynamicFeature, hasFeaturePlugin, consumerProguardFiles2, errorMessage -> this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, (String)errorMessage));
        }
    }

    private Collection<TestedTargetVariant> getTestTargetVariants(BaseVariantData variantData) {
        if (this.extension instanceof TestAndroidConfig) {
            TestAndroidConfig testConfig = (TestAndroidConfig)this.extension;
            ArtifactCollection apkArtifacts = variantData.getScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST_METADATA);
            if (apkArtifacts.getArtifacts().size() == 1) {
                ResolvedArtifactResult result = (ResolvedArtifactResult)Iterables.getOnlyElement((Iterable)apkArtifacts.getArtifacts());
                String variant2 = LibraryUtils.getVariantName(result);
                return ImmutableList.of((Object)new TestedTargetVariantImpl(testConfig.getTargetProjectPath(), variant2));
            }
            if (!apkArtifacts.getFailures().isEmpty()) {
                VariantScope variantScope = variantData.getScope();
                new DependencyFailureHandler().addErrors(variantScope.getGlobalScope().getProject().getPath() + "@" + variantScope.getFullVariantName() + "/testTarget", apkArtifacts.getFailures()).registerIssues(this.extraModelInfo.getSyncIssueHandler());
            }
        }
        return ImmutableList.of();
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, BaseVariantData variantData) {
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        VariantScope scope = variantData.getScope();
        Pair<Dependencies, DependencyGraphs> result = ModelBuilder.getDependencies(scope, this.buildMapping, this.extraModelInfo, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        if (scope.getArtifacts().hasFinalProduct(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE)) {
            additionalTestClasses.add(((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE).get()).getAsFile());
        }
        if (!this.globalScope.getExtension().getAaptOptions().getNamespaced() && !this.globalScope.getProjectOptions().get(BooleanOption.GENERATE_R_JAVA)) {
            additionalTestClasses.add(((RegularFile)scope.getRJarForUnitTests().get()).getAsFile());
        }
        File mockableJar = this.globalScope.getMockableJarArtifact().getFiles().stream().findFirst().orElse(null);
        return new JavaArtifactImpl(variantType.getArtifactName(), scope.getTaskContainer().getAssembleTask().getName(), scope.getTaskContainer().getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{this.taskManager.createMockableJar.getName()}), ModelBuilder.getGeneratedSourceFoldersForUnitTests(variantData), ((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalTestClasses, variantData.getJavaResourcesForUnitTesting(), mockableJar, (Dependencies)result.getFirst(), (DependencyGraphs)result.getSecond(), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    public static Pair<Dependencies, DependencyGraphs> getDependencies(VariantScope variantScope, ImmutableMap<String, String> buildMapping, ExtraModelInfo extraModelInfo, int modelLevel, boolean modelWithFullDependency) {
        Pair result;
        if (extraModelInfo.getSyncIssueHandler().hasSyncIssue(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            result = Pair.of((Object)DependenciesImpl.EMPTY, (Object)EmptyDependencyGraphs.EMPTY);
        } else {
            Project project2 = variantScope.getGlobalScope().getProject();
            DependencyGraphBuilder graphBuilder = DependencyGraphBuilderKt.getDependencyGraphBuilder();
            result = modelLevel >= 4 ? Pair.of((Object)DependenciesImpl.EMPTY, (Object)graphBuilder.createLevel4DependencyGraph(variantScope, modelWithFullDependency, buildMapping, extraModelInfo.getSyncIssueHandler())) : Pair.of((Object)graphBuilder.createDependencies(variantScope, buildMapping, extraModelInfo.getSyncIssueHandler()), (Object)EmptyDependencyGraphs.EMPTY);
        }
        return result;
    }

    private void checkSigningConfig(VariantScope scope, GradleVariantConfiguration configuration2) {
        if (scope.getType().isDynamicFeature() && (configuration2.getMergedFlavor().getSigningConfig() != null || ((CoreBuildType)configuration2.getBuildType()).getSigningConfig() != null)) {
            String message = "Signing configuration should not be declared in the dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, message);
        }
    }

    private AndroidArtifact createAndroidArtifact(String name, BaseVariantData variantData) {
        String applicationId;
        VariantScope scope = variantData.getScope();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        this.checkSigningConfig(scope, variantConfiguration);
        SigningConfig signingConfig = variantConfiguration.getSigningConfig();
        String signingConfigName = null;
        if (signingConfig != null) {
            signingConfigName = signingConfig.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        BuildOutputSupplier<Collection<EarlySyncBuildOutput>> splitOutputsProxy = ModelBuilder.getBuildOutputSupplier(variantData);
        BuildOutputSupplier<Collection<EarlySyncBuildOutput>> manifestsProxy = ModelBuilder.getManifestsSupplier(variantData);
        InstantRunImpl instantRun = new InstantRunImpl(scope.getGlobalScope().getProject().file((Object)"build_info_removed"), 7);
        Pair<Dependencies, DependencyGraphs> dependencies = ModelBuilder.getDependencies(scope, this.buildMapping, this.extraModelInfo, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        ArrayList<File> additionalRuntimeApks = new ArrayList<File>();
        TestOptionsImpl testOptions = null;
        if (variantData.getType().isTestComponent()) {
            Configuration testHelpers = (Configuration)scope.getGlobalScope().getProject().getConfigurations().findByName("androidTestUtil");
            if (testHelpers != null) {
                additionalRuntimeApks.addAll(testHelpers.getFiles());
            }
            DeviceProviderInstrumentTestTask.checkForNonApks(additionalRuntimeApks, message -> this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, (String)message));
            TestOptions testOptionsDsl = scope.getGlobalScope().getExtension().getTestOptions();
            testOptions = new TestOptionsImpl(testOptionsDsl.getAnimationsDisabled(), testOptionsDsl.getExecutionEnum());
        }
        try {
            applicationId = variantConfiguration.getApplicationId();
        }
        catch (RuntimeException e) {
            applicationId = "";
            this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.GENERIC, e);
        }
        MutableTaskContainer taskContainer = scope.getTaskContainer();
        return new AndroidArtifactImpl(name, scope.getGlobalScope().getProjectBaseName() + "-" + variantConfiguration.getBaseName(), taskContainer.getAssembleTask().getName(), variantConfiguration.isSigningReady() || variantData.outputsAreSigned, signingConfigName, applicationId, taskContainer.getSourceGenTask().getName(), taskContainer.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(variantData), ModelBuilder.getGeneratedResourceFolders(variantData), ((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalTestClasses, scope.getVariantData().getJavaResourcesForUnitTesting(), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), additionalRuntimeApks, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantConfiguration.getSupportedAbis(), variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), instantRun, splitOutputsProxy, manifestsProxy, testOptions, taskContainer.getConnectedTask() == null ? null : taskContainer.getConnectedTask().getName(), taskContainer.getBundleTask() == null ? scope.getTaskName("bundle") : taskContainer.getBundleTask().getName(), ExtractApksTask.Companion.getTaskName(scope));
    }

    private void validateMinSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getMinSdkVersion() != null) {
            this.extraModelInfo.getSyncIssueHandler().reportError(EvalIssueReporter.Type.MIN_SDK_VERSION_IN_MANIFEST, "The minSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private void validateTargetSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getTargetSdkVersion() != null) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.TARGET_SDK_VERSION_IN_MANIFEST, "The targetSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private static BuildOutputSupplier<Collection<EarlySyncBuildOutput>> getBuildOutputSupplier(BaseVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        VariantTypeImpl variantType = (VariantTypeImpl)variantData.getType();
        switch (variantType) {
            case BASE_APK: 
            case OPTIONAL_APK: 
            case BASE_FEATURE: 
            case FEATURE: 
            case TEST_APK: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.APK.INSTANCE), (Object)((Object)InternalArtifactType.ABI_PACKAGED_SPLIT.INSTANCE), (Object)((Object)InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT.INSTANCE)), (List<File>)ImmutableList.of((Object)variantScope.getApkLocation()));
            }
            case LIBRARY: {
                ApkData mainApkInfo = ApkData.of(VariantOutput.OutputType.MAIN, (Collection<FilterData>)ImmutableList.of(), 0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.AAR.INSTANCE, mainApkInfo.getType(), mainApkInfo.getFilters(), mainApkInfo.getVersionCode(), ((RegularFile)variantScope.getArtifacts().getFinalProduct(InternalArtifactType.AAR.INSTANCE).get()).getAsFile())));
            }
            case ANDROID_TEST: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.APK.INSTANCE)), (List<File>)ImmutableList.of((Object)variantScope.getApkLocation()));
            }
            case UNIT_TEST: {
                return () -> {
                    BaseVariantData testedVariantData = variantScope.getTestedVariantData();
                    VariantScope testedVariantScope = testedVariantData.getScope();
                    PublishingSpecs.VariantSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
                    PublishingSpecs.OutputSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES, AndroidArtifacts.PublishedConfigType.API_ELEMENTS);
                    ArtifactType<? extends FileSystemLocation> testedOutputType = taskOutputSpec.getOutputType();
                    return ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.JAVAC.INSTANCE, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), variantData.getVariantConfiguration().getVersionCode(), (File)((FileCollection)variantScope.getArtifacts().getFinalProductAsFileCollection(testedOutputType).get()).iterator().next()));
                };
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static BuildOutputSupplier<Collection<EarlySyncBuildOutput>> getManifestsSupplier(BaseVariantData variantData) {
        VariantTypeImpl variantType = (VariantTypeImpl)variantData.getType();
        switch (variantType) {
            case ANDROID_TEST: 
            case BASE_APK: 
            case OPTIONAL_APK: 
            case BASE_FEATURE: 
            case FEATURE: 
            case TEST_APK: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.MERGED_MANIFESTS.INSTANCE)), (List<File>)ImmutableList.of((Object)variantData.getScope().getManifestOutputDirectory()));
            }
            case LIBRARY: {
                ApkData mainApkInfo = ApkData.of(VariantOutput.OutputType.MAIN, (Collection<FilterData>)ImmutableList.of(), 0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, mainApkInfo.getType(), mainApkInfo.getFilters(), mainApkInfo.getVersionCode(), new File(variantData.getScope().getManifestOutputDirectory(), "AndroidManifest.xml"))));
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static SourceProviders determineSourceProviders(BaseVariantData variantData) {
        SourceProvider variantSourceProvider = variantData.getVariantConfiguration().getVariantSourceProvider();
        SourceProvider multiFlavorSourceProvider = variantData.getVariantConfiguration().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? new SourceProviderImpl(variantSourceProvider) : null, multiFlavorSourceProvider != null ? new SourceProviderImpl(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(BaseVariantData variantData) {
        return variantData.getVariantConfiguration().getProductFlavors().stream().map(ProductFlavor::getName).collect(Collectors.toList());
    }

    private static List<File> getGeneratedSourceFoldersForUnitTests(BaseVariantData variantData) {
        if (variantData == null) {
            return Collections.emptyList();
        }
        ArrayList folders = Lists.newArrayList(variantData.getExtraGeneratedSourceFolders());
        folders.add(((Directory)variantData.getScope().getArtifacts().getFinalProduct(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE).get()).getAsFile());
        return folders;
    }

    private static List<File> getGeneratedSourceFolders(BaseVariantData variantData) {
        if (variantData == null) {
            return Collections.emptyList();
        }
        VariantScope scope = variantData.getScope();
        BuildArtifactsHolder artifacts2 = scope.getArtifacts();
        GlobalScope globalScope = variantData.getScope().getGlobalScope();
        boolean isDataBindingEnabled = globalScope.getExtension().getDataBinding().isEnabled();
        boolean isViewBindingEnabled = globalScope.getExtension().getViewBinding().isEnabled();
        boolean addBindingSources = (isDataBindingEnabled || isViewBindingEnabled) && artifacts2.hasFinalProduct(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE);
        List<File> extraFolders = ModelBuilder.getGeneratedSourceFoldersForUnitTests(variantData);
        int additionalFolders = 4;
        if (addBindingSources) {
            ++additionalFolders;
        }
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)(additionalFolders + extraFolders.size()));
        folders.addAll(extraFolders);
        folders.add(((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE).get()).getAsFile());
        folders.add(scope.getBuildConfigSourceOutputDir());
        Boolean ndkMode = variantData.getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled();
        if (ndkMode == null || !ndkMode.booleanValue()) {
            folders.add(((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE).get()).getAsFile());
        }
        if (addBindingSources && scope.getArtifacts().hasFinalProduct(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE)) {
            folders.add(((Directory)scope.getArtifacts().getFinalProduct(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE).get()).getAsFile());
        }
        return folders;
    }

    private static List<File> getGeneratedResourceFolders(BaseVariantData variantData) {
        ArrayList result;
        Set extraFolders;
        if (variantData == null) {
            return Collections.emptyList();
        }
        FileCollection extraResFolders = variantData.getExtraGeneratedResFolders();
        Set set = extraFolders = extraResFolders != null ? extraResFolders.getFiles() : null;
        if (extraFolders != null && !extraFolders.isEmpty()) {
            result = Lists.newArrayListWithCapacity((int)(extraFolders.size() + 2));
            result.addAll(extraFolders);
        } else {
            result = Lists.newArrayListWithCapacity((int)2);
        }
        VariantScope scope = variantData.getScope();
        result.add(scope.getRenderscriptResOutputDir());
        return result;
    }

    private static Collection<SigningConfig> cloneSigningConfigs(Collection<? extends SigningConfig> signingConfigs) {
        return signingConfigs.stream().map(SigningConfigImpl::createSigningConfig).collect(Collectors.toList());
    }

    private void initBuildMapping(Project project2) {
        if (this.buildMapping == null) {
            this.buildMapping = BuildMappingUtils.computeBuildMapping(project2.getGradle());
        }
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }
}

